/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.util.ArrayList;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayShort;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;

public class TestStandardVar
extends TestCase {
    private String filename = TestAll.cdmLocalTestDataDir + "standardVar.nc";
    private NetcdfFile ncfileRead;
    private NetcdfDataset dsRead;

    public TestStandardVar(String name) {
        super(name);
    }

    public void testWriteStandardVar() throws Exception {
        int j;
        int i;
        NetcdfFileWriteable ncfile = new NetcdfFileWriteable(this.filename, false);
        Dimension latDim = ncfile.addDimension("lat", 2);
        Dimension lonDim = ncfile.addDimension("lon", 3);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        dims.add(latDim);
        dims.add(lonDim);
        ncfile.addVariable("t1", DataType.DOUBLE, dims);
        ncfile.addVariableAttribute("t1", "scale_factor", (Number)new Double(2.0));
        ncfile.addVariableAttribute("t1", "add_offset", (Number)new Double(77.0));
        ncfile.addVariable("t2", DataType.BYTE, dims);
        ncfile.addVariableAttribute("t2", "scale_factor", (Number)new Short(2));
        ncfile.addVariableAttribute("t2", "add_offset", (Number)new Short(77));
        ncfile.addVariable("t3", DataType.BYTE, dims);
        ncfile.addVariableAttribute("t3", "_FillValue", (Number)new Byte(-1));
        ncfile.addVariable("t4", DataType.SHORT, dims);
        ncfile.addVariableAttribute("t4", "missing_value", (Number)new Short(-9999));
        ncfile.addVariable("t5", DataType.SHORT, dims);
        ncfile.addVariableAttribute("t5", "missing_value", (Number)new Short(-9999));
        ncfile.addVariableAttribute("t5", "scale_factor", (Number)new Short(2));
        ncfile.addVariableAttribute("t5", "add_offset", (Number)new Short(77));
        ncfile.addVariable("m1", DataType.DOUBLE, dims);
        ncfile.addVariableAttribute("m1", "missing_value", (Number)-999.99);
        ncfile.create();
        ArrayDouble.D2 A = new ArrayDouble.D2(latDim.getLength(), lonDim.getLength());
        Index ima = A.getIndex();
        for (i = 0; i < latDim.getLength(); ++i) {
            for (j = 0; j < lonDim.getLength(); ++j) {
                A.setDouble(ima.set(i, j), (double)i * 10.0 + (double)j);
            }
        }
        int[] origin = new int[2];
        ncfile.write("t1", origin, (Array)A);
        ArrayByte.D2 Ab = new ArrayByte.D2(latDim.getLength(), lonDim.getLength());
        ima = Ab.getIndex();
        for (i = 0; i < latDim.getLength(); ++i) {
            for (j = 0; j < lonDim.getLength(); ++j) {
                Ab.setByte(ima.set(i, j), (byte)(i * 10 + j));
            }
        }
        ncfile.write("t2", origin, (Array)Ab);
        ncfile.write("t3", origin, (Array)Ab);
        ArrayShort.D2 As = new ArrayShort.D2(latDim.getLength(), lonDim.getLength());
        ima = As.getIndex();
        for (i = 0; i < latDim.getLength(); ++i) {
            for (j = 0; j < lonDim.getLength(); ++j) {
                As.setShort(ima.set(i, j), (short)(i * 10 + j));
            }
        }
        ncfile.write("t4", origin, (Array)As);
        As.setShort(ima.set(0, 0), (short)-9999);
        ncfile.write("t5", origin, (Array)As);
        ArrayDouble.D2 Ad = new ArrayDouble.D2(latDim.getLength(), lonDim.getLength());
        for (i = 0; i < latDim.getLength(); ++i) {
            for (j = 0; j < lonDim.getLength(); ++j) {
                Ad.setDouble(ima.set(i, j), (double)i * 10.0 + (double)j);
            }
        }
        Ad.set(1, 1, -999.99);
        ncfile.write("m1", new int[2], (Array)Ad);
        ncfile.close();
        System.out.println("**************TestStandardVar Write done");
    }

    public void testReadStandardVar() throws Exception {
        this.ncfileRead = NetcdfFile.open((String)this.filename);
        this.dsRead = NetcdfDataset.openDataset((String)this.filename);
        this.readDouble();
        this.readByte2Short();
        this.readByte();
        this.readShortMissing();
        this.readShort2FloatMissing();
        this.readDoubleMissing();
        this.ncfileRead.close();
        this.dsRead.close();
    }

    public void readDouble() throws Exception {
        int j;
        int i;
        Variable t1 = null;
        assert (null != (t1 = this.ncfileRead.findVariable("t1")));
        assert (t1.getDataType() == DataType.DOUBLE);
        Attribute att = t1.findAttribute("scale_factor");
        assert (null != att);
        assert (!att.isArray());
        assert (1 == att.getLength());
        assert (2.0 == att.getNumericValue().doubleValue());
        assert (DataType.DOUBLE == att.getDataType());
        Array A = t1.read();
        Index ima = A.getIndex();
        int[] shape = A.getShape();
        for (i = 0; i < shape[0]; ++i) {
            for (j = 0; j < shape[1]; ++j) {
                assert (A.getDouble(ima.set(i, j)) == (double)i * 10.0 + (double)j);
            }
        }
        assert (null != (t1 = this.dsRead.findVariable("t1")));
        assert (t1 instanceof VariableEnhanced);
        VariableEnhanced dsVar = (VariableEnhanced)t1;
        assert (dsVar.getDataType() == DataType.DOUBLE);
        A = dsVar.read();
        ima = A.getIndex();
        shape = A.getShape();
        for (i = 0; i < shape[0]; ++i) {
            for (j = 0; j < shape[1]; ++j) {
                assert (A.getDouble(ima.set(i, j)) == 2.0 * ((double)i * 10.0 + (double)j) + 77.0);
            }
        }
        assert (null == t1.findAttribute("scale_factor"));
        assert (null == t1.findAttribute("add_offset"));
        System.out.println("**************TestStandardVar ReadDouble");
    }

    public void readByte2Short() throws Exception {
        Variable t2 = null;
        assert (null != (t2 = this.ncfileRead.findVariable("t2")));
        assert (t2.getDataType() == DataType.BYTE);
        Attribute att = t2.findAttribute("scale_factor");
        assert (null != att);
        assert (!att.isArray());
        assert (1 == att.getLength());
        assert (2.0 == att.getNumericValue().doubleValue());
        assert (DataType.SHORT == att.getDataType());
        assert (null != (t2 = this.dsRead.findVariable("t2")));
        assert (t2 instanceof VariableEnhanced);
        VariableDS vs = (VariableDS)t2;
        assert (vs.getDataType() == DataType.SHORT) : vs.getDataType();
        assert (!vs.hasMissing());
        Array A = vs.read();
        assert (A.getElementType() == Short.TYPE) : A.getElementType();
        Index ima = A.getIndex();
        int[] shape = A.getShape();
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                assert (A.getShort(ima.set(i, j)) == 2 * (i * 10 + j) + 77);
            }
        }
        System.out.println("**************TestStandardVar readByte2Short");
    }

    public void readByte() throws Exception {
        Variable v = null;
        assert (null != (v = this.ncfileRead.findVariable("t3")));
        assert (v.getDataType() == DataType.BYTE);
        assert (null != (v = this.dsRead.findVariable("t3")));
        assert (v instanceof VariableEnhanced);
        assert (v instanceof VariableDS);
        VariableDS vs = (VariableDS)v;
        assert (vs.getDataType() == DataType.BYTE);
        Attribute att = vs.findAttribute("_FillValue");
        assert (null != att);
        assert (!att.isArray());
        assert (1 == att.getLength());
        System.out.println("_FillValue = " + att.getNumericValue().byteValue());
        assert (-1 == att.getNumericValue().byteValue());
        assert (DataType.BYTE == att.getDataType());
        assert (vs.hasMissing());
        assert (vs.hasFillValue());
        assert (vs.isMissing(-1.0));
        assert (vs.isFillValue(-1.0));
        Array A = vs.read();
        assert (A.getElementType() == Byte.TYPE) : A.getElementType();
        Index ima = A.getIndex();
        int[] shape = A.getShape();
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                assert (A.getFloat(ima.set(i, j)) == (float)(i * 10 + j));
            }
        }
        System.out.println("**************TestStandardVar ReadByte");
    }

    public void readShortMissing() throws Exception {
        Variable v = null;
        assert (null != (v = this.ncfileRead.findVariable("t4")));
        assert (v.getDataType() == DataType.SHORT);
        assert (null != (v = this.dsRead.findVariable("t4")));
        assert (v instanceof VariableEnhanced);
        assert (v instanceof VariableDS);
        VariableDS vs = (VariableDS)v;
        assert (vs.getDataType() == DataType.SHORT);
        Attribute att = vs.findAttribute("missing_value");
        assert (null != att);
        assert (!att.isArray());
        assert (1 == att.getLength());
        System.out.println("missing_value = " + att.getNumericValue().shortValue());
        assert (-9999 == att.getNumericValue().shortValue());
        assert (DataType.SHORT == att.getDataType());
        assert (vs.hasMissing());
        assert (vs.hasMissingValue());
        assert (vs.isMissing(-9999.0));
        assert (vs.isMissingValue(-9999.0));
        Array A = vs.read();
        Index ima = A.getIndex();
        int[] shape = A.getShape();
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                assert (A.getFloat(ima.set(i, j)) == (float)(i * 10 + j));
            }
        }
        vs.setMissingDataIsMissing(false);
        assert (vs.getDataType() == DataType.SHORT);
        assert (!vs.hasMissing());
        assert (vs.hasMissingValue());
        assert (!vs.isMissing(-9999.0));
        assert (vs.isMissingValue(-9999.0));
        vs.setMissingDataIsMissing(true);
        assert (vs.hasMissing());
        assert (vs.isMissing(-9999.0));
        System.out.println("**************TestStandardVar Read readShortMissing");
    }

    public void readShort2FloatMissing() throws Exception {
        int j;
        int i;
        Variable v = null;
        assert (null != (v = this.ncfileRead.findVariable("t5")));
        assert (v.getDataType() == DataType.SHORT);
        assert (null != (v = this.dsRead.findVariable("t5")));
        assert (v instanceof VariableEnhanced);
        assert (v instanceof VariableDS);
        VariableDS vs = (VariableDS)v;
        assert (vs.getDataType() == DataType.FLOAT);
        assert (vs.hasMissing());
        assert (vs.hasMissingValue());
        double mv = -19921.0;
        assert (vs.isMissing(mv));
        assert (vs.isMissingValue(mv));
        Array A = vs.read();
        Index ima = A.getIndex();
        int[] shape = A.getShape();
        assert (vs.isMissing((double)A.getFloat(ima.set(0, 0))));
        for (i = 0; i < shape[0]; ++i) {
            for (j = 1; j < shape[1]; ++j) {
                float want;
                float val = A.getFloat(ima.set(i, j));
                if (val != (want = (float)(2 * (i * 10 + j) + 77))) {
                    System.out.println(i + " " + j + " " + val + " " + want);
                }
                assert (val == want);
            }
        }
        vs.setUseNaNs(true);
        assert (vs.getDataType() == DataType.FLOAT);
        assert (vs.hasMissing());
        assert (vs.hasMissingValue());
        double mv2 = -19921.0;
        assert (vs.isMissing(mv2));
        assert (vs.isMissingValue(mv2));
        Array A2 = vs.read();
        Index ima2 = A2.getIndex();
        int[] shape2 = A2.getShape();
        double mval = A2.getFloat(ima2.set(0, 0));
        assert (vs.isMissing(mval));
        assert (Double.isNaN(mval));
        for (i = 0; i < shape2[0]; ++i) {
            for (j = 1; j < shape2[1]; ++j) {
                float want;
                float val = A2.getFloat(ima2.set(i, j));
                if (val != (want = (float)(2 * (i * 10 + j) + 77))) {
                    System.out.println(i + " " + j + " " + val + " " + want);
                }
                assert (val == want) : val + " != " + want;
            }
        }
        assert (null == vs.findAttribute("scale_factor"));
        assert (null == vs.findAttribute("add_offset"));
        assert (null == vs.findAttribute("missing_value"));
        System.out.println("**************TestStandardVar Read readShort2FloatMissing");
    }

    public void readDoubleMissing() throws Exception {
        VariableDS v = null;
        assert (null != (v = (VariableDS)this.dsRead.findVariable("m1")));
        assert (v.getDataType() == DataType.DOUBLE);
        Array A = v.read();
        Index ima = A.getIndex();
        double val = A.getFloat(ima.set(1, 1));
        assert (Double.isNaN(val));
        assert (v.isMissing(val));
        v.setUseNaNs(false);
        v.createNewCache();
        A = v.read();
        ima = A.getIndex();
        val = A.getFloat(ima.set(1, 1));
        assert (TestAll.closeEnough(val, -999.99)) : val;
        assert (v.isMissing(val));
    }
}

