/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

public class TestScaleOffsetMissingForStructure
extends TestCase {
    public TestScaleOffsetMissingForStructure(String name) {
        super(name);
    }

    public void testNetcdfFile() throws IOException, InvalidRangeException {
        NetcdfFile ncfile = NetcdfDataset.openFile((String)(TestAll.cdmLocalTestDataDir + "testScaleRecord.nc"), null);
        Variable v = ncfile.findVariable("testScale");
        assert (null != v);
        assert (v.getDataType() == DataType.SHORT);
        Array data = v.read();
        Index ima = data.getIndex();
        short val = data.getShort(ima);
        assert (val == -999);
        assert (v.getUnitsString().equals("m"));
        v.addAttribute(new Attribute("units", "meters"));
        assert (v.getUnitsString().equals("meters"));
        ncfile.sendIospMessage((Object)"AddRecordStructure");
        Structure s = (Structure)ncfile.findVariable("record");
        assert (s != null);
        Variable v2 = s.findVariable("testScale");
        Attribute att = v2.findAttribute("units");
        assert (att.getStringValue().equals("meters"));
        assert (v2.getUnitsString().equals("meters"));
        StructureData sdata = s.readStructure(0);
        StructureMembers.Member m = sdata.findMember("testScale");
        assert (null != m);
        assert (m.getUnitsString().equals("meters"));
        double dval = sdata.convertScalarDouble(m.getName());
        assert (dval == -999.0);
        int count = 0;
        StructureDataIterator siter = s.getStructureIterator();
        while (siter.hasNext()) {
            double expect;
            sdata = siter.next();
            m = sdata.findMember("testScale");
            assert (m.getUnitsString().equals("meters"));
            assert (null != m);
            dval = sdata.convertScalarDouble(m.getName());
            double d = expect = count == 0 ? -999.0 : 13.0;
            assert (dval == expect) : dval + "!=" + expect;
            ++count;
        }
        ncfile.close();
    }

    public void testNetcdfDataset() throws IOException, InvalidRangeException {
        NetcdfDataset ncfile = NetcdfDataset.openDataset((String)(TestAll.cdmLocalTestDataDir + "testScaleRecord.nc"));
        System.out.printf("Open %s%n", ncfile.getLocation());
        VariableDS v = (VariableDS)ncfile.findVariable("testScale");
        assert (null != v);
        assert (v.getDataType() == DataType.FLOAT);
        Array data = v.read();
        Index ima = data.getIndex();
        float val = data.getFloat(ima);
        assert (v.isMissing((double)val));
        assert (Float.isNaN(val)) : val;
        ncfile.sendIospMessage((Object)"AddRecordStructure");
        Structure s = (Structure)ncfile.findVariable("record");
        assert (s != null);
        VariableDS vm = (VariableDS)s.findVariable("testScale");
        Array vmData = vm.read();
        if (vmData.hasNext()) {
            float vmval = vmData.nextFloat();
            assert (vm.isMissing((double)vmval));
            assert (Float.isNaN(vmval)) : vmval;
        }
        StructureData sdata = s.readStructure(0);
        StructureMembers.Member m = sdata.findMember("testScale");
        assert (null != m);
        ncfile.close();
    }

    public void testNetcdfDatasetAttributes() throws IOException, InvalidRangeException {
        NetcdfDataset ncfile = NetcdfDataset.openDataset((String)(TestAll.cdmLocalTestDataDir + "testScaleRecord.nc"));
        VariableDS v = (VariableDS)ncfile.findVariable("testScale");
        assert (null != v);
        assert (v.getDataType() == DataType.FLOAT);
        assert (v.getUnitsString().equals("m"));
        v.addAttribute(new Attribute("units", "meters"));
        assert (v.getUnitsString().equals("meters"));
        ncfile.sendIospMessage((Object)"AddRecordStructure");
        Structure s = (Structure)ncfile.findVariable("record");
        assert (s != null);
        Variable v2 = s.findVariable("testScale");
        assert (v2.getUnitsString().equals("meters"));
        assert (v2.getDataType() == DataType.FLOAT);
        StructureData sdata = s.readStructure(0);
        StructureMembers.Member m = sdata.findMember("testScale");
        assert (null != m);
        assert (m.getUnitsString().equals("meters")) : m.getUnitsString();
        assert (m.getDataType() == DataType.FLOAT);
        StructureDataIterator siter = s.getStructureIterator();
        while (siter.hasNext()) {
            sdata = siter.next();
            m = sdata.findMember("testScale");
            assert (null != m);
            assert (m.getUnitsString().equals("meters"));
        }
        ncfile.close();
    }
}

