/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.net.MalformedURLException;
import junit.framework.TestCase;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.TestCompareNetcdf;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;

public class TestCompareSubset
extends TestCase {
    static NetcdfFile ncfile = null;
    String filename = "file:./" + TestNcML.topDir + "aggSynthetic.xml";

    public TestCompareSubset(String name) {
        super(name);
    }

    public void setUp() {
        if (ncfile != null) {
            return;
        }
        try {
            new NcMLReader();
            ncfile = NcMLReader.readNcML((String)this.filename, null);
        }
        catch (MalformedURLException e) {
            System.out.println("bad URL error = " + e);
        }
        catch (IOException e) {
            System.out.println("IO error = " + e);
            e.printStackTrace();
        }
    }

    public void testStructure() {
        Dimension latDim = ncfile.findDimension("lat");
        assert (null != latDim);
        assert (latDim.getName().equals("lat"));
        assert (latDim.getLength() == 3);
        assert (!latDim.isUnlimited());
        Dimension timeDim = ncfile.findDimension("time");
        assert (null != timeDim);
        assert (timeDim.getName().equals("time"));
        assert (timeDim.getLength() == 3);
        assert (timeDim.isUnlimited());
    }

    public void testSubsetData() {
        NetcdfFile subset = null;
        try {
            subset = NetcdfFile.open((String)"C:/dev/netcdf/test/data/time0.nc");
            System.out.println("testSubsetData = " + TestCompareNetcdf.compareSubset(ncfile, subset));
            subset.close();
        }
        catch (MalformedURLException e) {
            System.out.println("bad URL error = " + e);
        }
        catch (IOException e) {
            System.out.println("IO error = " + e);
            e.printStackTrace();
        }
    }

    boolean close(double d1, double d2) {
        if (d1 != 0.0) {
            return Math.abs((d1 - d2) / d1) < 1.0E-5;
        }
        return Math.abs(d1 - d2) < 1.0E-5;
    }
}

