/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.TestAll;
import ucar.nc2.TestLocal;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.IO;

public class TestWriteMiscProblems
extends TestCase {
    public TestWriteMiscProblems(String name) {
        super(name);
    }

    public void testWriteBigString() throws IOException {
        String filename = TestLocal.temporaryDataDir + "testWriteMisc.nc";
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew((String)filename, (boolean)false);
        int len = 120000;
        ArrayChar.D1 arrayCharD1 = new ArrayChar.D1(len);
        for (int i = 0; i < len; ++i) {
            arrayCharD1.set(i, '1');
        }
        ncfile.addGlobalAttribute("tooLongChar", (Array)arrayCharD1);
        char[] carray = new char[len];
        for (int i = 0; i < len; ++i) {
            carray[i] = 50;
        }
        String val = new String(carray);
        ncfile.addGlobalAttribute("tooLongString", val);
        ncfile.create();
        ncfile.close();
    }

    public void testBig() throws IOException, InvalidRangeException {
        long start = System.nanoTime();
        System.out.println("Begin <=");
        String varName = "example";
        int timeSize = 8;
        int latSize = 8022;
        int lonSize = 10627;
        System.out.println("File size  (B)  = " + (long)timeSize * (long)latSize * (long)lonSize * 4L);
        System.out.println("File size~ (MB) = " + Math.round((double)((long)timeSize * (long)latSize * (long)lonSize * 4L) / Math.pow(2.0, 20.0)));
        NetcdfFileWriteable ncFile = NetcdfFileWriteable.createNew((String)(TestAll.temporaryLocalDataDir + "bigFile2.nc"));
        ncFile.setFill(false);
        ncFile.setLargeFile(true);
        long approxSize = (long)timeSize * (long)latSize * (long)lonSize * 4L + 4000L;
        ncFile.setLength(approxSize);
        String timeUnits = "hours since 2008-06-06 12:00:0.0";
        String coordUnits = "degrees";
        Dimension[] dim = new Dimension[]{TestWriteMiscProblems.setDimension(ncFile, "time", timeUnits, timeSize), TestWriteMiscProblems.setDimension(ncFile, "lat", coordUnits, latSize), TestWriteMiscProblems.setDimension(ncFile, "lon", coordUnits, lonSize)};
        ncFile.addVariable(varName, DataType.FLOAT, dim);
        ncFile.addVariableAttribute(varName, "_FillValue", (Number)-9999);
        ncFile.addVariableAttribute(varName, "missing_value", (Number)-9999);
        System.out.println("Creating netcdf <=");
        ncFile.create();
        long stop = System.nanoTime();
        double took = (double)(stop - start) * 0.001 * 0.001 * 0.001;
        System.out.println("That took " + took + " secs");
        start = stop;
        System.out.println("Writing netcdf <=");
        int[] shape = new int[]{1, 1, lonSize};
        float[] floatStorage = new float[lonSize];
        Array floatArray = Array.factory(Float.TYPE, (int[])shape, (Object)floatStorage);
        for (int t = 0; t < timeSize; ++t) {
            int i = 0;
            while (i < latSize) {
                int[] origin = new int[]{t, i++, 0};
                ncFile.write(varName, origin, floatArray);
            }
        }
        ncFile.close();
        System.out.println("Done <=");
        stop = System.nanoTime();
        took = (double)(stop - start) * 0.001 * 0.001 * 0.001;
        System.out.println("That took " + took + " secs");
        start = stop;
    }

    private static Dimension setDimension(NetcdfFileWriteable ncFile, String name, String units, int length) {
        Dimension dimension = ncFile.addDimension(name, length);
        ncFile.addVariable(name, DataType.FLOAT, new Dimension[]{dimension});
        ncFile.addVariableAttribute(name, "units", units);
        return dimension;
    }

    public void testCharMultidim() throws IOException, InvalidRangeException {
        boolean Time_len = false;
        int DateStrLen_len = 19;
        String filename = TestLocal.temporaryDataDir + "testCharMultidim.nc";
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew((String)filename, (boolean)true);
        Dimension Time_dim = ncfile.addUnlimitedDimension("Time");
        Dimension DateStrLen_dim = ncfile.addDimension("DateStrLen", 19);
        ArrayList<Dimension> Times_dimlist = new ArrayList<Dimension>();
        Times_dimlist.add(Time_dim);
        Times_dimlist.add(DateStrLen_dim);
        ncfile.addVariable("Times", DataType.CHAR, Times_dimlist);
        ncfile.create();
        String contents = "2005-04-11_12:00:002005-04-11_13:00:00";
        ArrayChar data = new ArrayChar(new int[]{2, 19});
        IndexIterator iter = data.getIndexIterator();
        int count = 0;
        while (iter.hasNext()) {
            iter.setCharNext(contents.charAt(count++));
        }
        ncfile.write("Times", (Array)data);
        ncfile.close();
        NetcdfFile nc = NetcdfFile.open((String)filename, null);
        Variable v = nc.findTopVariable("Times");
        Array dataRead = v.read();
        assert (dataRead instanceof ArrayChar);
        ArrayChar dataC = (ArrayChar)dataRead;
        for (int i = 0; i < 2; ++i) {
            System.out.printf("%d == %s %n", i, dataC.getString(i));
        }
        assert (dataC.getString(0).equals("2005-04-11_12:00:00"));
        assert (dataC.getString(1).equals("2005-04-11_13:00:00"));
        nc.close();
    }

    public void testRemove() throws IOException, InvalidRangeException {
        try {
            String inName = TestLocal.cdmTestDataDir + "testWrite.nc";
            String outName = TestLocal.temporaryDataDir + "testRemove.nc";
            NetcdfDataset ncd = NetcdfDataset.acquireDataset((String)inName, null);
            System.out.println(ncd);
            System.out.println(ncd.removeVariable(null, "temperature"));
            System.out.println(ncd);
            ncd.finish();
            NetcdfFile ncdnew = FileWriter.writeToFile((NetcdfFile)ncd, (String)outName, (boolean)true);
            ncdnew.close();
            ncd.close();
            NetcdfDataset ncdnew2 = NetcdfDataset.acquireDataset((String)outName, null);
            assert (ncdnew2.findVariable("temperature") == null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedefine() throws IOException, InvalidRangeException {
        String org = TestLocal.cdmTestDataDir + "testWriteRecord.nc";
        String path = TestLocal.temporaryDataDir + "testWriteRecordRedefine.nc";
        File orgFile = new File(org);
        File newFile = new File(path);
        if (newFile.exists()) {
            newFile.delete();
        }
        IO.copyFile((File)orgFile, (File)newFile);
        NetcdfFileWriteable ncfile = null;
        try {
            ncfile = NetcdfFileWriteable.openExisting((String)path, (boolean)false);
            System.out.println(ncfile);
            ncfile.setRedefineMode(true);
            Variable tvar = ncfile.findVariable("T");
            ncfile.setExtraHeaderBytes(1024);
            ncfile.addVariable("header_data", DataType.FLOAT, tvar.getDimensions());
            System.out.println(ncfile);
        }
        finally {
            try {
                if (ncfile != null) {
                    ncfile.setRedefineMode(false);
                    ncfile.flush();
                    ncfile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void utestWarning() throws IOException {
        String org = "C:/tmp/example.nc";
        NetcdfDataset dds = NetcdfDataset.openDataset((String)org);
        FileWriter.writeToFile((NetcdfFile)dds, (String)"C:/tmp/testOut.nc", (boolean)true);
        dds.close();
    }
}

