/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.TestLocal;
import ucar.nc2.Variable;

public class TestWriteFill
extends TestCase {
    private boolean show = false;

    public TestWriteFill(String name) {
        super(name);
    }

    public void testCreateWithFill() throws IOException {
        String filename;
        block34: {
            int j;
            int i;
            Index ima;
            NetcdfFileWriteable ncfile;
            block33: {
                Dimension lonDim;
                Dimension latDim;
                block32: {
                    filename = TestLocal.temporaryDataDir + "testWriteFill.nc";
                    ncfile = NetcdfFileWriteable.createNew((String)filename, (boolean)true);
                    latDim = ncfile.addDimension("lat", 6);
                    lonDim = ncfile.addDimension("lon", 12);
                    Dimension timeDim = ncfile.addDimension("time", 0, true, true, false);
                    ArrayList<Dimension> dims = new ArrayList<Dimension>();
                    dims.add(latDim);
                    dims.add(lonDim);
                    ArrayList<Dimension> rdims = new ArrayList<Dimension>();
                    rdims.add(timeDim);
                    rdims.add(latDim);
                    rdims.add(lonDim);
                    ncfile.addVariable("temperature", DataType.DOUBLE, dims);
                    ncfile.addVariableAttribute("temperature", "units", "K");
                    ncfile.addVariableAttribute("temperature", "_FillValue", (Number)new Double(-999.9));
                    ncfile.addVariable("lat", DataType.DOUBLE, new Dimension[]{latDim});
                    ncfile.addVariable("lon", DataType.FLOAT, new Dimension[]{latDim});
                    ncfile.addVariable("shorty", DataType.SHORT, new Dimension[]{latDim});
                    ncfile.addVariable("rtemperature", DataType.INT, rdims);
                    ncfile.addVariableAttribute("rtemperature", "units", "K");
                    ncfile.addVariableAttribute("rtemperature", "_FillValue", (Number)new Integer(-9999));
                    ncfile.addVariable("rdefault", DataType.INT, rdims);
                    Dimension svar_len = ncfile.addDimension("svar_len", 80);
                    dims = new ArrayList();
                    dims.add(svar_len);
                    ncfile.addVariable("svar", DataType.CHAR, dims);
                    ncfile.addVariable("svar2", DataType.CHAR, dims);
                    Dimension names = ncfile.addDimension("names", 3);
                    ArrayList<Dimension> dima = new ArrayList<Dimension>();
                    dima.add(names);
                    dima.add(svar_len);
                    ncfile.addVariable("names", DataType.CHAR, dima);
                    ncfile.addVariable("names2", DataType.CHAR, dima);
                    try {
                        ncfile.create();
                    }
                    catch (IOException e) {
                        System.err.println("ERROR creating file " + ncfile.getLocation() + "\n" + e);
                        if ($assertionsDisabled) break block32;
                        throw new AssertionError();
                    }
                }
                ArrayDouble.D3 A = new ArrayDouble.D3(1, latDim.getLength(), lonDim.getLength() / 2);
                ima = A.getIndex();
                for (i = 0; i < latDim.getLength(); ++i) {
                    for (j = 0; j < lonDim.getLength() / 2; ++j) {
                        A.setDouble(ima.set(0, i, j), (double)(i * 1000000 + j * 1000));
                    }
                }
                int[] origin = new int[3];
                try {
                    ncfile.write("rtemperature", origin, (Array)A);
                }
                catch (IOException e) {
                    System.err.println("ERROR writing file");
                    assert (false);
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block33;
                    throw new AssertionError();
                }
            }
            Variable temp = ncfile.findVariable("temperature");
            assert (null != temp);
            Array tA = temp.read();
            assert (tA.getRank() == 2);
            ima = tA.getIndex();
            int[] shape = tA.getShape();
            for (i = 0; i < shape[0]; ++i) {
                for (j = shape[1]; j < shape[1]; ++j) {
                    assert (tA.getDouble(ima.set(i, j)) == -999.9);
                }
            }
            Variable rtemp = ncfile.findVariable("rtemperature");
            assert (null != rtemp);
            Array rA = rtemp.read();
            assert (rA.getRank() == 3);
            ima = rA.getIndex();
            int[] rshape = rA.getShape();
            for (i = 0; i < rshape[1]; ++i) {
                for (j = rshape[2] / 2 + 1; j < rshape[2]; ++j) {
                    assert (rA.getDouble(ima.set(0, i, j)) == -9999.0) : rA.getDouble(ima);
                }
            }
            Variable v = ncfile.findVariable("lat");
            assert (null != v);
            Array data = v.read();
            IndexIterator ii = data.getIndexIterator();
            while (ii.hasNext()) {
                assert (ii.getDoubleNext() == (double)9.96921E36f);
            }
            v = ncfile.findVariable("lon");
            assert (null != v);
            data = v.read();
            ii = data.getIndexIterator();
            while (ii.hasNext()) {
                assert (ii.getFloatNext() == 9.96921E36f);
            }
            v = ncfile.findVariable("shorty");
            assert (null != v);
            data = v.read();
            ii = data.getIndexIterator();
            while (ii.hasNext()) {
                assert (ii.getShortNext() == -32767);
            }
            v = ncfile.findVariable("rdefault");
            assert (null != v);
            data = v.read();
            ii = data.getIndexIterator();
            while (ii.hasNext()) {
                assert (ii.getIntNext() == -2147483647);
            }
            try {
                ncfile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block34;
                throw new AssertionError();
            }
        }
        System.out.println("*****************Test Write done on " + filename);
    }
}

