/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.io.OutputStream;
import ucar.ma2.Array;
import ucar.nc2.NCdump;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class TestUtils {
    public static void NCdump(String filename) {
        block2: {
            try {
                NCdump.print((String)filename, (OutputStream)System.out, (boolean)false, (boolean)true, (boolean)false, (boolean)false, null, null);
                NCdump.printNcML((String)filename, (OutputStream)System.out);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        System.out.println("**** NCdump done");
    }

    public static void testReadData(NetcdfFile ncfile, boolean showStatus) {
        block4: {
            try {
                for (Variable v : ncfile.getVariables()) {
                    TestUtils.testVarMatchesData(v, showStatus);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        if (showStatus) {
            System.out.println("**** testReadData done on " + ncfile.getLocation());
        }
    }

    public static void testVarMatchesData(Variable v, boolean showStatus) throws IOException {
        Array data = v.read();
        assert (data.getSize() == v.getSize());
        assert (data.getElementType() == v.getDataType().getPrimitiveClassType());
        assert (data.getRank() == v.getRank());
        int[] dataShape = data.getShape();
        int[] varShape = v.getShape();
        for (int i = 0; i < data.getRank(); ++i) {
            assert (dataShape[i] == varShape[i]);
        }
        if (showStatus) {
            System.out.println("**** testReadData done on " + v.getName());
        }
    }

    public static boolean close(double d1, double d2) {
        if (Double.isNaN(d1)) {
            return Double.isNaN(d2);
        }
        if (d1 != 0.0) {
            return Math.abs((d1 - d2) / d1) < 1.0E-9;
        }
        return Math.abs(d1 - d2) < 1.0E-9;
    }

    public static boolean close(float d1, float d2) {
        if (Float.isNaN(d1)) {
            return Float.isNaN(d2);
        }
        if ((double)d1 != 0.0) {
            return (double)Math.abs((d1 - d2) / d1) < 1.0E-5;
        }
        return (double)Math.abs(d1 - d2) < 1.0E-5;
    }
}

