/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.TestNC2;

public class TestStructureIterator
extends TestCase {
    public TestStructureIterator(String name) {
        super(name);
    }

    public void testStructureIterator() throws IOException, InvalidRangeException {
        NetcdfFile ncfile = TestNC2.open("C:/data/metars/Surface_METAR_20070331_0000.nc");
        ncfile.sendIospMessage((Object)"AddRecordStructure");
        Structure v = (Structure)ncfile.findVariable("record");
        assert (v != null);
        assert (v.getDataType() == DataType.STRUCTURE);
        int count = 0;
        StructureDataIterator si = v.getStructureIterator();
        while (si.hasNext()) {
            StructureData sd = si.next();
            ++count;
        }
        assert ((long)count == v.getSize());
        ncfile.close();
    }
}

