/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.FileWriter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.netcdf3.N3channelWriter;
import ucar.nc2.iosp.netcdf3.N3outputStreamWriter;
import ucar.nc2.util.CompareNetcdf;

public class TestStreamWriter
extends TestCase {
    static boolean showCompare = true;
    static boolean showEach = false;

    public TestStreamWriter(String name) {
        super(name);
    }

    public void test() throws IOException, InvalidRangeException {
        this.testChannelWriter("C:/data/metars/Surface_METAR_20070326_0000.nc");
        this.testChannelWriter("C:/data/RUC2_CONUS_40km_20070709_1800.nc");
        this.testOutputStreamWriter("C:/data/metars/Surface_METAR_20070326_0000.nc");
        this.testOutputStreamWriter("C:/data/RUC2_CONUS_40km_20070709_1800.nc");
    }

    private void testOutputStreamWriter(String fileInName) throws IOException {
        System.out.println("\nFile= " + fileInName + " size=" + new File(fileInName).length());
        NetcdfFile fileIn = NetcdfFile.open((String)fileInName);
        long start = System.currentTimeMillis();
        N3outputStreamWriter.writeFromFile((NetcdfFile)fileIn, (String)"C:/data/testStream.nc");
        long took = System.currentTimeMillis() - start;
        System.out.println("N3streamWriter took " + took + " msecs");
        NetcdfFile file2 = NetcdfFile.open((String)"C:/data/testStream.nc");
        CompareNetcdf.compareFiles((NetcdfFile)fileIn, (NetcdfFile)file2, (boolean)true, (boolean)true, (boolean)false);
        fileIn.close();
        file2.close();
    }

    private void testChannelWriter(String fileInName) throws IOException, InvalidRangeException {
        System.out.println("\nFile= " + fileInName + " size=" + new File(fileInName).length());
        NetcdfFile fileIn = NetcdfFile.open((String)fileInName);
        long start = System.currentTimeMillis();
        N3channelWriter.writeFromFile((NetcdfFile)fileIn, (String)"C:/data/testStream.nc");
        long took = System.currentTimeMillis() - start;
        System.out.println("N3streamWriter took " + took + " msecs");
        NetcdfFile file2 = NetcdfFile.open((String)"C:/data/testStream.nc");
        CompareNetcdf.compareFiles((NetcdfFile)fileIn, (NetcdfFile)file2, (boolean)true, (boolean)true, (boolean)false);
        fileIn.close();
        file2.close();
    }

    public void utestTime() throws IOException, InvalidRangeException {
        this.testTime(new String[]{"C:/data/RUC2_CONUS_40km_20070709_1800.nc", "C:/data/CopyRUC2_CONUS_40km_20070709_1800.nc", "C:/data/Copy2RUC2_CONUS_40km_20070709_1800.nc"});
        this.testTime(new String[]{"C:/data/metars/Surface_METAR_20070329_0000.nc", "C:/data/metars/Surface_METAR_20070330_0000.nc", "C:/data/metars/Surface_METAR_20070326_0000.nc"});
    }

    public void testTime(String[] filename) throws IOException, InvalidRangeException {
        System.out.println("\nFile= " + filename[0] + " size=" + new File(filename[0]).length());
        NetcdfFile fileIn = NetcdfFile.open((String)filename[0]);
        File fileOut = File.createTempFile("Test", ".tmp", new File("C:/data/"));
        long start = System.currentTimeMillis();
        N3outputStreamWriter.writeFromFile((NetcdfFile)fileIn, (String)fileOut.getPath());
        long took = System.currentTimeMillis() - start;
        System.out.println("N3streamWriter took " + took + " msecs");
        fileIn.close();
        NetcdfFile fileIn2 = NetcdfFile.open((String)filename[1]);
        File fileOut2 = File.createTempFile("Test", ".tmp", new File("C:/data/"));
        long start2 = System.currentTimeMillis();
        NetcdfFile ncout2 = FileWriter.writeToFile((NetcdfFile)fileIn2, (String)fileOut2.getPath());
        ncout2.close();
        long took2 = System.currentTimeMillis() - start2;
        System.out.println("FileWriter took " + took2 + " msecs");
        fileIn2.close();
        NetcdfFile fileIn3 = NetcdfFile.open((String)filename[2]);
        File fileOut3 = File.createTempFile("Test", ".tmp", new File("C:/data/"));
        long start3 = System.currentTimeMillis();
        N3channelWriter.writeFromFile((NetcdfFile)fileIn3, (String)fileOut3.getPath());
        long took3 = System.currentTimeMillis() - start3;
        System.out.println("N3channelWriter took " + took3 + " msecs");
        fileIn3.close();
    }
}

