/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.TestAll;
import ucar.nc2.TestLocal;
import ucar.nc2.Variable;
import ucar.nc2.util.CompareNetcdf;

public class TestRedefine
extends TestCase {
    String filename = TestLocal.temporaryDataDir + "testRedefine.nc";
    String filename2 = TestLocal.temporaryDataDir + "testRedefine2.nc";

    public TestRedefine(String name) {
        super(name);
    }

    public void testRedefine() throws IOException, InvalidRangeException {
        NetcdfFileWriteable file = NetcdfFileWriteable.createNew((String)this.filename, (boolean)true);
        file.addGlobalAttribute("Conventions", "globulate");
        file.addGlobalAttribute("history", "lava");
        file.addGlobalAttribute("att8", "12345678");
        Dimension time = file.addDimension("time", 4, true, false, false);
        Dimension[] dims = new Dimension[]{time};
        file.addVariable("time", DataType.DOUBLE, dims);
        file.addVariableAttribute("time", "quantity", "time");
        file.addVariableAttribute("time", "units", "s");
        file.addVariable("h", DataType.DOUBLE, dims);
        file.addVariableAttribute("h", "quantity", "Height");
        file.addVariableAttribute("h", "units", "m");
        try {
            file.create();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            TestRedefine.fail((String)"IOException on creation");
        }
        double[] td = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] hd = new double[]{0.0, 0.1, 0.3, 0.9};
        ArrayDouble.D1 ta = new ArrayDouble.D1(4);
        ArrayDouble.D1 ha = new ArrayDouble.D1(4);
        for (int i = 0; i < 4; ++i) {
            ta.set(i, td[i]);
            ha.set(i, hd[i]);
        }
        file.write("time", (Array)ta);
        file.write("h", (Array)ha);
        file.setRedefineMode(true);
        file.renameGlobalAttribute("history", "lamp");
        file.addGlobalAttribute("history", "final");
        file.deleteGlobalAttribute("Conventions");
        file.addVariableAttribute("h", "units", "meters");
        file.addVariableAttribute("h", "new", "stuff");
        file.renameVariableAttribute("time", "quantity", "quality");
        file.renameVariable("time", "date");
        file.renameDimension("time", "date");
        file.setRedefineMode(false);
        Attribute att = file.findGlobalAttribute("Conventions");
        assert (att == null);
        att = file.findGlobalAttribute("history");
        assert (att.getStringValue().equals("final"));
        att = file.findGlobalAttribute("lamp");
        assert (att.getStringValue().equals("lava"));
        Variable v = file.findVariable("h");
        att = v.findAttribute("units");
        assert (att != null);
        assert (att.getStringValue().equals("meters"));
        assert (file.findVariable("time") == null);
        v = file.findVariable("date");
        assert (v != null);
        assert (v.getRank() == 1);
        assert (null != v.findAttribute("quality"));
        Dimension d = v.getDimension(0);
        assert (d.getName().equals("date"));
        assert (file.findDimension("time") == null);
        Dimension dim = file.findDimension("date");
        assert (dim != null);
        assert (dim.getName().equals("date"));
        assert (dim.equals((Object)d));
        assert (dim == d);
        file.close();
    }

    public void testRewriteHeader() throws IOException, InvalidRangeException {
        NetcdfFileWriteable file = NetcdfFileWriteable.openExisting((String)this.filename, (boolean)true);
        file.setRedefineMode(true);
        file.addGlobalAttribute("att8", "1234567");
        boolean rewriteAll = file.setRedefineMode(false);
        assert (!rewriteAll);
        Attribute att = file.findGlobalAttribute("att8");
        assert (att != null);
        assert (att.getStringValue().equals("1234567")) : att.getStringValue();
        file.close();
    }

    public void testRewriteHeader2() throws IOException, InvalidRangeException {
        NetcdfFileWriteable file = NetcdfFileWriteable.openExisting((String)this.filename, (boolean)true);
        file.setRedefineMode(true);
        file.addGlobalAttribute("att8", "123456789");
        boolean rewriteAll = file.setRedefineMode(false);
        assert (rewriteAll);
        Attribute att = file.findGlobalAttribute("att8");
        assert (att != null);
        assert (att.getStringValue().equals("123456789")) : att.getStringValue();
        file.close();
    }

    public void testRewriteHeader3() throws IOException, InvalidRangeException {
        NetcdfFileWriteable file = NetcdfFileWriteable.createNew((String)this.filename2, (boolean)true);
        file.addGlobalAttribute("att8", "1234567890");
        file.setExtraHeaderBytes(10);
        file.create();
        file.setRedefineMode(true);
        file.addGlobalAttribute("att8", "123456789012345");
        boolean rewriteAll = file.setRedefineMode(false);
        assert (!rewriteAll);
        Attribute att = file.findGlobalAttribute("att8");
        assert (att != null);
        assert (att.getStringValue().equals("123456789012345")) : att.getStringValue();
        file.close();
    }

    public void testRedefine3() throws IOException, InvalidRangeException {
        String filename = TestAll.temporaryLocalDataDir + "testRedefine3.nc";
        NetcdfFileWriteable ncFile = NetcdfFileWriteable.createNew((String)filename, (boolean)false);
        ncFile.setExtraHeaderBytes(64000);
        Dimension dim = ncFile.addDimension("time", 100);
        double[] jackData = new double[100];
        for (int i = 0; i < 100; ++i) {
            jackData[i] = i;
        }
        double[] jillData = new double[100];
        for (int i = 0; i < 100; ++i) {
            jillData[i] = 2 * i;
        }
        Dimension[] dims = new Dimension[]{dim};
        ncFile.addVariable("jack", DataType.DOUBLE, dims);
        ncFile.addVariableAttribute("jack", "where", "up the hill");
        ncFile.create();
        int[] start = new int[]{0};
        int[] count = new int[]{100};
        ncFile.write("jack", start, Array.factory(Double.TYPE, (int[])count, (Object)jackData));
        ncFile.setRedefineMode(true);
        ncFile.addVariable("jill", DataType.DOUBLE, dims);
        ncFile.addVariableAttribute("jill", "where", "up the hill");
        ncFile.setRedefineMode(false);
        Array jillArray = Array.factory(Double.TYPE, (int[])count, (Object)jillData);
        ncFile.write("jill", start, jillArray);
        ncFile.flush();
        ncFile.close();
        NetcdfFile nc = NetcdfFile.open((String)filename, null);
        Variable v = nc.findVariable("jill");
        Array jillRead = v.read();
        CompareNetcdf.compareData((Array)jillArray, (Array)jillRead);
        nc.close();
    }
}

