/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestLocalNC2;
import ucar.nc2.Variable;

public class TestAttributes
extends TestCase {
    public TestAttributes(String name) {
        super(name);
    }

    public void testNC3ReadAttributes() throws IOException {
        NetcdfFile ncfile = TestLocalNC2.openFile("testWrite.nc");
        assert ("face".equals(ncfile.findAttValueIgnoreCase(null, "yo", "barf")));
        Variable temp = null;
        assert (null != (temp = ncfile.findVariable("temperature")));
        assert ("K".equals(ncfile.findAttValueIgnoreCase(temp, "units", "barf")));
        Attribute att = temp.findAttribute("scale");
        assert (null != att);
        assert (att.isArray());
        assert (3 == att.getLength());
        assert (3 == att.getNumericValue(2).intValue());
        Array aa = att.getValues();
        assert (att.getDataType() == DataType.INT);
        assert (aa.getElementType() == Integer.TYPE);
        assert (aa.getSize() == 3L);
        att = temp.findAttribute("versionD");
        assert (null != att);
        assert (!att.isArray());
        assert (1 == att.getLength());
        assert (1.2 == att.getNumericValue().doubleValue());
        assert (DataType.DOUBLE == att.getDataType());
        aa = att.getValues();
        assert (att.getDataType() == DataType.DOUBLE);
        assert (aa.getElementType() == Double.TYPE);
        assert (aa.getSize() == 1L);
        att = temp.findAttribute("versionF");
        assert (null != att);
        assert (!att.isArray());
        assert (1 == att.getLength());
        assert (1.2f == att.getNumericValue().floatValue());
        assert (this.close(1.2, att.getNumericValue().doubleValue()));
        assert (DataType.FLOAT == att.getDataType());
        aa = att.getValues();
        assert (att.getDataType() == DataType.FLOAT);
        assert (aa.getElementType() == Float.TYPE);
        assert (aa.getSize() == 1L);
        att = temp.findAttribute("versionI");
        assert (null != att);
        assert (!att.isArray());
        assert (1 == att.getLength());
        assert (1 == att.getNumericValue().intValue());
        assert (DataType.INT == att.getDataType());
        aa = att.getValues();
        assert (att.getDataType() == DataType.INT);
        assert (aa.getElementType() == Integer.TYPE);
        assert (aa.getSize() == 1L);
        att = temp.findAttribute("versionS");
        assert (null != att);
        assert (!att.isArray());
        assert (1 == att.getLength());
        assert (2 == att.getNumericValue().shortValue());
        assert (DataType.SHORT == att.getDataType());
        aa = att.getValues();
        assert (att.getDataType() == DataType.SHORT);
        assert (aa.getElementType() == Short.TYPE);
        assert (aa.getSize() == 1L);
        att = temp.findAttribute("versionB");
        assert (null != att);
        assert (!att.isArray());
        assert (1 == att.getLength());
        assert (3 == att.getNumericValue().byteValue());
        assert (DataType.BYTE == att.getDataType());
        aa = att.getValues();
        assert (att.getDataType() == DataType.BYTE);
        assert (aa.getElementType() == Byte.TYPE);
        assert (aa.getSize() == 1L);
        att = temp.findAttribute("versionString");
        assert (null != att);
        assert (!att.isArray());
        assert (1 == att.getLength());
        assert (DataType.STRING == att.getDataType());
        Number n = att.getNumericValue();
        assert (n == null);
        ncfile.close();
    }

    boolean close(double d1, double d2) {
        return Math.abs((d1 - d2) / d1) < 1.0E-5;
    }
}

