/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import thredds.catalog.TestCatalogAll;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestIosp;
import ucar.nc2.TestLocal;
import ucar.nc2.TestNC2;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TestDataset;
import ucar.nc2.dods.TestDODS;
import ucar.nc2.dt.TestTypedDatasets;
import ucar.nc2.dt.grid.TestGrid;
import ucar.nc2.ft.TestFeatureDatasets;
import ucar.nc2.ncml.TestNcML;
import ucar.nc2.ncml.TestNcMLoffsite;
import ucar.nc2.util.cache.FileCache;
import ucar.unidata.geoloc.TestGeoloc;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.TestDiskCacheUtils;

public class TestAll {
    public static long startTime;
    public static String testdataDir;
    public static String cdmUnitTestDir;
    public static String cdmLocalTestDataDir;
    public static String temporaryLocalDataDir;
    private static String testdataDirPropName;
    private static String threddsPropFileName;
    static int max_size;

    public static Test suite() {
        RandomAccessFile.setDebugLeaks((boolean)true);
        TestSuite suite = new TestSuite();
        suite.addTest(TestLocal.suite());
        suite.addTest(TestNC2.suite());
        suite.addTest(TestDataset.suite());
        suite.addTest(TestNcML.suite());
        suite.addTest(TestNcMLoffsite.suite());
        suite.addTest(TestGrid.suite());
        suite.addTest(TestFeatureDatasets.suite());
        suite.addTest(TestTypedDatasets.suite());
        suite.addTest(TestGeoloc.suite());
        suite.addTest(TestDODS.suite());
        suite.addTest(TestCatalogAll.suite());
        suite.addTest(TestIosp.suite());
        return new TestSetup((Test)suite){

            protected void setUp() {
                RandomAccessFile.setDebugLeaks((boolean)true);
                startTime = System.currentTimeMillis();
            }

            protected void tearDown() {
                TestAll.checkLeaks();
                FileCache fc = NetcdfDataset.getNetcdfFileCache();
                if (fc != null) {
                    fc.clearCache(true);
                }
                TestAll.checkLeaks();
                NetcdfDataset.shutdown();
                double took = (double)(System.currentTimeMillis() - startTime) * 0.001;
                System.out.println(" that took= " + took + " secs");
                TestAll.showFilesUsed();
            }
        };
    }

    public static void checkLeaks() {
        if (RandomAccessFile.getOpenFiles().size() > 0) {
            System.out.println("RandomAccessFile still open:");
            for (String filename : RandomAccessFile.getOpenFiles()) {
                System.out.println(" open= " + filename);
            }
        } else {
            System.out.println(" no leaks");
        }
    }

    private static void showFilesUsed() {
        System.out.println("All Files Used:");
        for (String s : RandomAccessFile.getAllFiles()) {
            System.out.printf(" %s%n", s);
        }
    }

    public static boolean closeEnough(double d1, double d2) {
        if (Math.abs(d1) < 1.0E-5) {
            return Math.abs(d1 - d2) < 1.0E-5;
        }
        return Math.abs((d1 - d2) / d1) < 1.0E-5;
    }

    public static boolean closeEnough(double d1, double d2, double tol) {
        if (Math.abs(d1) < tol) {
            return Math.abs(d1 - d2) < tol;
        }
        double pd = (d1 - d2) / d1;
        return Math.abs(pd) < tol;
    }

    public static double howClose(double d1, double d2) {
        double pd = (d1 - d2) / d1;
        return Math.abs(pd);
    }

    public static boolean closeEnough(float d1, float d2) {
        if ((double)Math.abs(d1) < 1.0E-5) {
            return (double)Math.abs(d1 - d2) < 1.0E-5;
        }
        return (double)Math.abs((d1 - d2) / d1) < 1.0E-5;
    }

    public static void showMem(String where) {
        Runtime runtime = Runtime.getRuntime();
        System.out.println(where + " memory free = " + (double)runtime.freeMemory() * 0.001 * 0.001 + " total= " + (double)runtime.totalMemory() * 0.001 * 0.001 + " max= " + (double)runtime.maxMemory() * 0.001 * 0.001 + " MB");
    }

    public static void openAllInDir(String dirName, FileFilter ff) throws IOException {
        System.out.println("---------------Reading directory " + dirName);
        File allDir = new File(dirName);
        File[] allFiles = allDir.listFiles();
        if (null == allFiles) {
            System.out.println("---------------INVALID " + dirName);
            return;
        }
        for (File f : allFiles) {
            String name = f.getAbsolutePath();
            if (f.isDirectory() || ff != null && !ff.accept(f)) continue;
            System.out.println("  try to open " + name);
            NetcdfFile ncfile = NetcdfFile.open((String)name);
            ncfile.close();
        }
        for (File f : allFiles) {
            if (!f.isDirectory()) continue;
            TestAll.openAllInDir(f.getAbsolutePath(), ff);
        }
    }

    public static int readAllDir(String dirName, FileFilter ff) {
        int count = 0;
        System.out.println("---------------Reading directory " + dirName);
        File allDir = new File(dirName);
        File[] allFiles = allDir.listFiles();
        if (null == allFiles) {
            System.out.println("---------------INVALID " + dirName);
            return count;
        }
        for (File f : allFiles) {
            String name = f.getAbsolutePath();
            if (f.isDirectory() || ff != null && !ff.accept(f) || name.endsWith(".exclude")) continue;
            count += TestAll.readAll(name);
        }
        for (File f : allFiles) {
            if (!f.isDirectory() || f.getName().equals("exclude")) continue;
            count += TestAll.readAllDir(f.getAbsolutePath(), ff);
        }
        return count;
    }

    public static int readAll(String filename) {
        block4: {
            System.out.println("\n------Reading filename " + filename);
            try {
                NetcdfFile ncfile = NetcdfFile.open((String)filename);
                for (Variable v : ncfile.getVariables()) {
                    if (v.getSize() > (long)max_size) {
                        Section s = TestAll.makeSubset(v);
                        System.out.println("  Try to read variable " + v.getNameAndDimensions() + " size= " + v.getSize() + " section= " + s);
                        v.read(s);
                        continue;
                    }
                    System.out.println("  Try to read variable " + v.getNameAndDimensions() + " size= " + v.getSize());
                    v.read();
                }
                ncfile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        return 1;
    }

    public static int readAll(NetcdfFile ncfile) {
        block4: {
            System.out.println("\n------Reading ncfile " + ncfile.location);
            try {
                for (Variable v : ncfile.getVariables()) {
                    if (v.getSize() > (long)max_size) {
                        Section s = TestAll.makeSubset(v);
                        System.out.println("  Try to read variable " + v.getNameAndDimensions() + " size= " + v.getSize() + " section= " + s);
                        v.read(s);
                        continue;
                    }
                    System.out.println("  Try to read variable " + v.getNameAndDimensions() + " size= " + v.getSize());
                    v.read();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        return 1;
    }

    public static int actOnAll(String dirName, FileFilter ff, Act act) throws IOException {
        int count = 0;
        System.out.println("---------------Reading directory " + dirName);
        File allDir = new File(dirName);
        File[] allFiles = allDir.listFiles();
        if (null == allFiles) {
            System.out.println("---------------INVALID " + dirName);
            return count;
        }
        List<File> flist = Arrays.asList(allFiles);
        Collections.sort(flist);
        for (File f : flist) {
            String name = f.getAbsolutePath();
            if (f.isDirectory() || ff != null && !ff.accept(f) || name.endsWith(".exclude")) continue;
            count += act.doAct(name);
        }
        for (File f : allFiles) {
            if (!f.isDirectory() || f.getName().equals("exclude")) continue;
            count += TestAll.actOnAll(f.getAbsolutePath(), ff, act);
        }
        return count;
    }

    static Section makeSubset(Variable v) throws InvalidRangeException {
        int[] shape = v.getShape();
        shape[0] = 1;
        Section s = new Section(shape);
        long size = s.computeSize();
        shape[0] = (int)Math.max(1L, (long)max_size / size);
        return new Section(shape);
    }

    static {
        File tmpDataDir;
        File userHomeDirFile;
        File userThreddsPropsFile;
        testdataDir = null;
        cdmUnitTestDir = null;
        cdmLocalTestDataDir = "src/test/data/";
        temporaryLocalDataDir = "target/test/tmp/";
        testdataDirPropName = "unidata.testdata.path";
        threddsPropFileName = "thredds.properties";
        String testdataDirPath = System.getProperty(testdataDirPropName);
        if (testdataDirPath == null && (userThreddsPropsFile = new File(userHomeDirFile = new File(System.getProperty("user.home")), threddsPropFileName)).exists() && userThreddsPropsFile.canRead()) {
            Properties userThreddsProps = new Properties();
            try {
                userThreddsProps.load(new FileInputStream(userThreddsPropsFile));
            }
            catch (IOException e) {
                System.out.println("**Failed loading user THREDDS property file: " + e.getMessage());
            }
            if (userThreddsProps != null && !userThreddsProps.isEmpty() && testdataDirPath == null) {
                testdataDirPath = userThreddsProps.getProperty(testdataDirPropName);
            }
        }
        if (testdataDirPath == null) {
            System.out.println("**No \"unidata.testdata.path\"property, defaulting to \"/share/testdata/\".");
            testdataDirPath = "/share/testdata/";
        }
        if (!testdataDirPath.endsWith("/") && !testdataDirPath.endsWith("\\")) {
            testdataDirPath = testdataDirPath + "/";
        }
        testdataDir = testdataDirPath;
        cdmUnitTestDir = testdataDirPath + "cdmUnitTest/";
        File file = new File(cdmUnitTestDir);
        if (!file.exists() || !file.isDirectory()) {
            System.out.println("**WARN: Non-existence of Level 3 test data directory [" + file.getAbsolutePath() + "].");
        }
        if (!(tmpDataDir = new File(temporaryLocalDataDir)).exists() && !tmpDataDir.mkdirs()) {
            System.out.println("**ERROR: Could not create temporary data dir <" + tmpDataDir.getAbsolutePath() + ">.");
        }
        TestDiskCacheUtils.setupDiskCacheInTmpDir(true);
        TestDiskCacheUtils.emptyDiskCache(null);
        TestDiskCacheUtils.setupDiskCache2WithTmpRootDir();
        max_size = 10000000;
    }

    public static class FileFilterImpl
    implements FileFilter {
        String[] suffixes;

        public FileFilterImpl(String suffixes) {
            this.suffixes = suffixes.split(" ");
        }

        @Override
        public boolean accept(File file) {
            for (String s : this.suffixes) {
                if (!file.getPath().endsWith(s)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Act {
        public int doAct(String var1) throws IOException;
    }
}

