/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.util.IO;

public class ReadRaw {
    double Mbytes = 1000000.0;
    double nano = 1.0E9;
    Formatter out = new Formatter(System.out);
    int nfiles = 0;
    long nbytes = 0L;
    boolean show = false;
    int buffersize = 100000;
    String dirName = "C:\\data\\work\\hawaii";
    String ssdName = "G:/";

    void test(String filename, Filter filter, MyClosure closure) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            if (this.show) {
                System.out.println(filename + " does not exist");
            }
            return;
        }
        if (!filter.pass(filename)) {
            if (this.show) {
                System.out.println(filename + " does not pass filter");
            }
            return;
        }
        try {
            closure.run(f.getPath());
        }
        catch (Exception ioe) {
            System.out.println("Failed on " + f.getPath() + ": " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    void testAllInDir(File dir, Filter filter, MyClosure closure) {
        List<File> list = Arrays.asList(dir.listFiles());
        Collections.sort(list);
        for (File f : list) {
            if (f.isDirectory()) {
                this.testAllInDir(f, filter, closure);
                continue;
            }
            try {
                this.test(f.getPath(), filter, closure);
            }
            catch (Exception ioe) {
                System.out.println("Failed on " + f.getPath() + ": " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    void run(String what, File dir, Filter filter, MyClosure closure) {
        this.nfiles = 0;
        this.nbytes = 0L;
        long start = System.nanoTime();
        this.testAllInDir(dir, filter, closure);
        long stop = System.nanoTime();
        double secs = (double)(stop - start) / this.nano;
        double rate = (double)this.nbytes / this.Mbytes / secs;
        this.out.format("%s %s buffersize= %d Nfiles = %d Mbytes = %f time = %f Rate = %f Mb/sec %n", what, dir, this.buffersize, this.nfiles, (double)this.nbytes / this.Mbytes, secs, rate);
    }

    ReadRaw() throws IOException {
        Filter netcdf = new Filter(){

            @Override
            public boolean pass(String filename) {
                return filename.endsWith(".nc");
            }
        };
        MyClosure readInputStream = new MyClosure(){

            @Override
            public void run(String filename) throws IOException {
                if (ReadRaw.this.show) {
                    ReadRaw.this.out.format("read %s %n", filename);
                }
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(filename), ReadRaw.this.buffersize);
                ReadRaw.this.nbytes += IO.copy2null((InputStream)is, (int)ReadRaw.this.buffersize);
                ++ReadRaw.this.nfiles;
                ((InputStream)is).close();
            }
        };
        this.run("readInputStream", new File(this.ssdName), netcdf, readInputStream);
        MyClosure readFileChannel = new MyClosure(){

            @Override
            public void run(String filename) throws IOException {
                if (ReadRaw.this.show) {
                    ReadRaw.this.out.format("read %s %n", filename);
                }
                FileInputStream fis = new FileInputStream(filename);
                FileChannel fc = fis.getChannel();
                ReadRaw.this.nbytes += IO.copy2null((FileChannel)fc, (int)ReadRaw.this.buffersize);
                ++ReadRaw.this.nfiles;
                fis.close();
            }
        };
        this.run("readFileChannel", new File(this.ssdName), netcdf, readFileChannel);
        this.run("readInputStream", new File(this.ssdName), netcdf, readInputStream);
        this.run("readFileChannel", new File(this.ssdName), netcdf, readFileChannel);
    }

    public static void main(String[] args) throws IOException {
        new ReadRaw();
    }

    static interface Filter {
        public boolean pass(String var1);
    }

    static interface MyClosure {
        public void run(String var1) throws IOException;
    }
}

