/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;

public class ReadGrid {
    public static void read(String filename) throws IOException {
        GridDataset gds = GridDataset.open((String)filename);
        GeoGrid grid = gds.findGridByName("Temperature");
        long startTime = System.currentTimeMillis();
        Array data = grid.readDataSlice(0, -1, -1, -1);
        long endTime = System.currentTimeMillis();
        long diff = endTime - startTime;
        System.out.println("read " + data.getSize() + "  took " + diff + " msecs");
        startTime = endTime;
        float[] jdata = (float[])data.get1DJavaArray(Float.TYPE);
        endTime = System.currentTimeMillis();
        diff = endTime - startTime;
        System.out.println("convert took " + diff + " msecs " + jdata[0]);
    }

    public static void main(String[] arg) throws IOException {
        String defaultFilename = "C:/data/grib/nam/conus12/NAM_CONUS_12km_20060604_1800.grib2";
        String filename = arg.length > 0 ? arg[0] : defaultFilename;
        ReadGrid.read(filename);
    }
}

