/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;

public class TestJavaArray
extends TestCase {
    public TestJavaArray(String name) {
        super(name);
    }

    public void test1Dim() {
        Array aa;
        try {
            aa = Array.factory((Object)new double[]{1.0, 2.0, 3.0});
        }
        catch (Exception e) {
            System.out.println("TestJavaArray 1D: " + e);
            assert (false);
            return;
        }
        assert (aa.getRank() == 1);
        int[] shape = aa.getShape();
        assert (shape[0] == 3);
        Index ima = aa.getIndex();
        System.out.println(aa.getFloat(ima.set(1)));
        assert ((double)aa.getFloat(ima.set(0)) == 1.0);
        assert ((double)aa.getFloat(ima.set(1)) == 2.0);
        assert ((double)aa.getFloat(ima.set(2)) == 3.0);
        IndexIterator ai = aa.getIndexIterator();
        System.out.println(ai.getFloatNext());
        assert ((double)ai.getFloatCurrent() == 1.0);
        assert ((double)ai.getFloatNext() == 2.0);
        assert ((double)ai.getFloatNext() == 3.0);
        double[] newArray = (double[])aa.copyTo1DJavaArray();
        assert (newArray[0] == 1.0);
        assert (newArray[1] == 2.0);
        assert (newArray[2] == 3.0);
        newArray = (double[])aa.copyToNDJavaArray();
        assert (newArray[0] == 1.0);
        assert (newArray[1] == 2.0);
        assert (newArray[2] == 3.0);
    }

    public void testNDim() {
        Array aa;
        double[][][] tData = new double[][][]{new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 4.0, 6.0, 8.0}, {3.0, 6.0, 9.0, 12.0}}, new double[][]{{2.5, 5.0, 7.5, 10.0}, {5.0, 10.0, 15.0, 20.0}, {7.5, 15.0, 22.5, 30.0}}};
        try {
            aa = Array.factory((Object)tData);
        }
        catch (Exception e) {
            System.out.println("TestJavaArray: " + e);
            assert (false);
            return;
        }
        assert (aa.getRank() == 3);
        int[] shape = aa.getShape();
        assert (shape[0] == 2);
        assert (shape[1] == 3);
        assert (shape[2] == 4);
        Index ima = aa.getIndex();
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    assert (aa.getDouble(ima.set(i, j, k)) == tData[i][j][k]);
                }
            }
        }
        double[][][] newArray = (double[][][])aa.copyToNDJavaArray();
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    assert (newArray[i][j][k] == tData[i][j][k]);
                }
            }
        }
    }

    public void testTypes() {
        this.typeSpecifics(new double[][][]{new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 4.0, 6.0, 8.0}, {3.0, 6.0, 9.0, 12.0}}, new double[][]{{2.5, 5.0, 7.5, 10.0}, {5.0, 10.0, 15.0, 20.0}, {7.5, 15.0, 22.5, 30.0}}});
        this.typeSpecifics(new float[][]{{1.0f, 2.0f, 3.0f, 4.0f}, {2.0f, 4.0f, 6.0f, 8.0f}, {3.0f, 6.0f, 9.0f, 12.0f}});
        this.typeSpecifics(new long[][]{{1L, 2L, 3L, 4L}, {2L, 4L, 6L, 8L}, {3L, 6L, 9L, 12L}});
        this.typeSpecifics(new int[][]{{1, 2, 3, 4}, {2, 4, 6, 8}, {3, 6, 9, 12}});
        this.typeSpecifics(new short[][]{{1, 2, 3, 4}, {2, 4, 6, 8}, {3, 6, 9, 12}});
        this.typeSpecifics(new byte[][]{{1, 2, 3, 4}, {2, 4, 6, 8}, {3, 6, 9, 12}});
        this.typeSpecifics(new char[][]{{'1', '2', '3', '4'}, {'2', '4', '6', '8'}, {'3', '6', '9', '2'}});
        this.typeSpecifics(new boolean[][]{{true, false, true}, {false, true, false}});
    }

    private void typeSpecifics(Object javaArray) {
        Array aa;
        System.out.println("typeSpecifics: " + javaArray);
        try {
            aa = Array.factory((Object)javaArray);
        }
        catch (Exception e) {
            System.out.println("TestJavaArray: " + e);
            assert (false);
            return;
        }
        Object newArray = aa.copyToNDJavaArray();
        this.testEquals(javaArray, newArray);
    }

    private void testEquals(Object jArray, Object newArray) {
        Class<?> cType = jArray.getClass().getComponentType();
        int n = java.lang.reflect.Array.getLength(jArray);
        if (cType.isPrimitive()) {
            for (int i = 0; i < n; ++i) {
                assert (java.lang.reflect.Array.get(jArray, i).equals(java.lang.reflect.Array.get(newArray, i)));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.testEquals(java.lang.reflect.Array.get(jArray, i), java.lang.reflect.Array.get(newArray, i));
            }
        }
    }
}

