/*
 * Decompiled with CFR 0.152.
 */
package timing.IO;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import ucar.nc2.util.IO;

public class TimeCompression {
    static boolean debug = false;

    public static void main(String[] args) throws IOException {
        TimeCompression.testCompressRandom();
        TimeCompression.testCompressFile("D:/data/NAM_CONUS_80km_20070501_1200.nc");
        TimeCompression.testCompressFile("D:/data/NAM_CONUS_80km_20070501_1200.nc");
    }

    public static void testCompressFile(String filename) throws IOException {
        TimeCompression.compressFile(filename, "C:/temp/tempFile.compress1", true);
        TimeCompression.compressFile(filename, "C:/temp/tempFile.gzip", false);
        TimeCompression.uncompressFile("C:/temp/tempFile.compress1", "C:/temp/tempFile.uncompress", true);
        TimeCompression.uncompressFile("C:/temp/tempFile.gzip", "C:/temp/tempFile.unzip", false);
    }

    public static void compressFile(String filenameIn, String filenameOut, boolean inflate) throws IOException {
        long lenIn = new File(filenameIn).length();
        if (debug) {
            System.out.println("read " + filenameIn + " len = " + lenIn);
        }
        FileInputStream fin = new FileInputStream(filenameIn);
        BufferedInputStream in = new BufferedInputStream(fin, 1000);
        FileOutputStream fout = new FileOutputStream(filenameOut);
        FilterOutputStream out = inflate ? new DeflaterOutputStream(fout) : new GZIPOutputStream(fout);
        out = new BufferedOutputStream(out, 1000);
        long start = System.currentTimeMillis();
        IO.copyB((InputStream)in, (OutputStream)out, (int)10000);
        ((OutputStream)out).flush();
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        ((OutputStream)out).close();
        fin.close();
        long lenOut = new File(filenameOut).length();
        if (debug) {
            System.out.println(" write compressed file= " + filenameOut + " len = " + lenOut);
        }
        double rate = (double)lenIn / took / 1000000.0;
        double ratio = (double)lenIn / (double)lenOut;
        String name = inflate ? "deflate" : "gzip";
        System.out.println(" " + name + " took = " + took + " sec; rate = " + rate + "Mb/sec; compress = " + ratio);
    }

    public static void uncompressFile(String filenameIn, String filenameOut, boolean inflate) throws IOException {
        long lenIn = new File(filenameIn).length();
        if (debug) {
            System.out.println("read compressed file= " + filenameIn + " len = " + lenIn);
        }
        FileInputStream fin = new FileInputStream(filenameIn);
        FilterInputStream in = inflate ? new InflaterInputStream(fin) : new GZIPInputStream(fin);
        in = new BufferedInputStream(in, 1000);
        FileOutputStream fout = new FileOutputStream(filenameOut);
        BufferedOutputStream out = new BufferedOutputStream(fout, 1000);
        long start = System.currentTimeMillis();
        IO.copyB((InputStream)in, (OutputStream)out, (int)10000);
        ((OutputStream)out).flush();
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        ((OutputStream)out).close();
        fin.close();
        long lenOut = new File(filenameOut).length();
        if (debug) {
            System.out.println(" write uncompressed file= " + filenameOut + " len = " + lenOut);
        }
        double rate = (double)lenIn / took / 1000000.0;
        double ratio = (double)lenOut / (double)lenIn;
        String name = inflate ? "inflate" : "gunzip";
        System.out.println(name + " took = " + took + " sec; rate = " + rate + "Mb/sec; compress = " + ratio);
    }

    public static void testCompressRandom() throws IOException {
        TimeCompression.deflateRandom("C:/temp/tempFile.compress1", false);
        TimeCompression.deflateRandom("C:/temp/tempFile.compress2", true);
        TimeCompression.gzipRandom("C:/temp/tempFile.compress3", false);
        TimeCompression.gzipRandom("C:/temp/tempFile.compress4", true);
        TimeCompression.inflateRandom("C:/temp/tempFile.compress1", false);
        TimeCompression.inflateRandom("C:/temp/tempFile.compress2", true);
        TimeCompression.unzipRandom("C:/temp/tempFile.compress3", false);
        TimeCompression.unzipRandom("C:/temp/tempFile.compress4", true);
    }

    public static void deflateRandom(String filenameOut, boolean buffer) throws IOException {
        FileOutputStream fout = new FileOutputStream(filenameOut);
        FilterOutputStream out = new DeflaterOutputStream(fout);
        if (buffer) {
            out = new BufferedOutputStream(out, 1000);
        }
        DataOutputStream dout = new DataOutputStream(out);
        Random r = new Random();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            dout.writeFloat(r.nextFloat());
        }
        dout.flush();
        fout.close();
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        File f = new File(filenameOut);
        long len = f.length();
        double ratio = 4000000.0 / (double)len;
        System.out.println(" deflateRandom took = " + took + " sec; compress = " + ratio);
    }

    public static void gzipRandom(String filenameOut, boolean buffer) throws IOException {
        FileOutputStream fout = new FileOutputStream(filenameOut);
        FilterOutputStream out = new GZIPOutputStream(fout);
        if (buffer) {
            out = new BufferedOutputStream(out, 1000);
        }
        DataOutputStream dout = new DataOutputStream(out);
        Random r = new Random();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            dout.writeFloat(r.nextFloat());
        }
        fout.flush();
        fout.close();
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        File f = new File(filenameOut);
        long len = f.length();
        double ratio = 4000000.0 / (double)len;
        System.out.println(" gzipRandom took = " + took + " sec; compress = " + ratio);
    }

    public static void inflateRandom(String filename, boolean buffer) throws IOException {
        FileInputStream fin = new FileInputStream(filename);
        FilterInputStream in = new InflaterInputStream(fin);
        if (buffer) {
            in = new BufferedInputStream(in, 1000);
        }
        DataInputStream din = new DataInputStream(in);
        long start = System.currentTimeMillis();
        float total = 0.0f;
        try {
            while (true) {
                total += din.readFloat();
            }
        }
        catch (EOFException e) {
            System.out.println("total=" + total);
            fin.close();
            double took = 0.001 * (double)(System.currentTimeMillis() - start);
            System.out.println(" inflate took = " + took + " sec");
            return;
        }
    }

    public static void unzipRandom(String filename, boolean buffer) throws IOException {
        FileInputStream fin = new FileInputStream(filename);
        FilterInputStream in = new GZIPInputStream(fin);
        if (buffer) {
            in = new BufferedInputStream(in, 1000);
        }
        DataInputStream din = new DataInputStream(in);
        long start = System.currentTimeMillis();
        float total = 0.0f;
        try {
            while (true) {
                total += din.readFloat();
            }
        }
        catch (EOFException e) {
            System.out.println("total=" + total);
            fin.close();
            double took = 0.001 * (double)(System.currentTimeMillis() - start);
            System.out.println(" unzip took = " + took + " sec");
            return;
        }
    }

    public static void main2(String[] args) throws IOException {
        String filenameIn = "C:/temp/tempFile2";
        String filenameOut = "C:/temp/tempFile2.compress2";
        FileInputStream fin = new FileInputStream(filenameIn);
        FileOutputStream fout = new FileOutputStream(filenameOut);
        BufferedOutputStream bout = new BufferedOutputStream(fout, 10000);
        DeflaterOutputStream out = new DeflaterOutputStream(fout);
        long start = System.currentTimeMillis();
        IO.copyB((InputStream)fin, (OutputStream)out, (int)10000);
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        System.out.println(" that took = " + took + "sec");
        fin.close();
        fout.close();
    }
}

