/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset.mock;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.crawlabledataset.mock.MockCrDsInfo;

public class MockCrawlableDataset
implements CrawlableDataset {
    private final String path;
    private final String name;
    private final int lastPathSegmentSeparatorIndx;
    private Date lastModified = null;
    private long length = -1L;
    private boolean exists = true;
    private final boolean isCollection;

    public MockCrawlableDataset(String path, boolean isCollection) {
        this(new MockCrDsInfo(path, true, isCollection, null, -1L));
    }

    public MockCrawlableDataset(MockCrDsInfo crDsInfo) {
        if (crDsInfo == null) {
            throw new IllegalArgumentException("CrawlableDataset info must not be null.");
        }
        if (crDsInfo.getPath() == null || crDsInfo.getPath().equals("")) {
            throw new IllegalArgumentException("Path must not be null or empty.");
        }
        this.path = crDsInfo.getPath();
        this.lastPathSegmentSeparatorIndx = this.path.lastIndexOf("/");
        if (this.lastPathSegmentSeparatorIndx == -1) {
            this.name = this.path;
        } else {
            this.name = this.path.substring(this.lastPathSegmentSeparatorIndx + 1);
            if (this.name.equals("")) {
                throw new IllegalArgumentException("Path [" + this.path + "] must not end with a slash (\"/\")");
            }
            if (!this.path.endsWith("/" + this.name)) {
                throw new IllegalArgumentException("Path [" + this.path + "] must end with name [" + this.name + "].");
            }
        }
        this.exists = crDsInfo.isExists();
        this.isCollection = crDsInfo.isCollection();
        this.lastModified = crDsInfo.getLastModified();
        this.length = crDsInfo.getLength();
    }

    public Object getConfigObject() {
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public CrawlableDataset getParentDataset() {
        if (this.lastPathSegmentSeparatorIndx == -1) {
            return null;
        }
        return new MockCrawlableDataset(this.path.substring(0, this.lastPathSegmentSeparatorIndx), true);
    }

    public boolean exists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public CrawlableDataset getDescendant(String relativePath) {
        return null;
    }

    public List<CrawlableDataset> listDatasets() throws IOException {
        return null;
    }

    public List<CrawlableDataset> listDatasets(CrawlableDatasetFilter filter) throws IOException {
        return null;
    }

    public long length() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public Date lastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }
}

