/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFactory;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.crawlabledataset.filter.MultiSelectorFilter;
import thredds.crawlabledataset.filter.RegExpMatchOnNameFilter;
import thredds.crawlabledataset.filter.WildcardMatchOnNameFilter;

public class TestCrawlableDatasetFilter
extends TestCase {
    private List resultsNcNoCVS;
    private List resultsAll;

    public TestCrawlableDatasetFilter(String name) {
        super(name);
    }

    protected void setUp() {
        this.resultsNcNoCVS = new ArrayList();
        this.resultsNcNoCVS.add("test/data/thredds/cataloggen/testData/modelNotFlat/gfs_211/2004050300_gfs_211.nc");
        this.resultsNcNoCVS.add("test/data/thredds/cataloggen/testData/modelNotFlat/gfs_211/2004050306_gfs_211.nc");
        this.resultsNcNoCVS.add("test/data/thredds/cataloggen/testData/modelNotFlat/gfs_211/2004050312_gfs_211.nc");
        this.resultsNcNoCVS.add("test/data/thredds/cataloggen/testData/modelNotFlat/gfs_211/2004050318_gfs_211.nc");
        this.resultsAll = new ArrayList(this.resultsNcNoCVS);
        this.resultsAll.add("test/data/thredds/cataloggen/testData/modelNotFlat/gfs_211/CVS");
    }

    public void testRegExpIncludeAll() {
        String path = "test/data/thredds/cataloggen/testData/modelNotFlat/gfs_211";
        String name = "gfs_211";
        CrawlableDataset cd = TestCrawlableDatasetFilter.createCrawlableDataset(path, name);
        ArrayList<MultiSelectorFilter.Selector> selectors = new ArrayList<MultiSelectorFilter.Selector>();
        selectors.add(new MultiSelectorFilter.Selector((CrawlableDatasetFilter)new RegExpMatchOnNameFilter(".*"), true, true, false));
        MultiSelectorFilter me = new MultiSelectorFilter(selectors);
        TestCrawlableDatasetFilter.assertTrue((me != null ? 1 : 0) != 0);
        List list = null;
        try {
            list = cd.listDatasets((CrawlableDatasetFilter)me);
        }
        catch (IOException e) {
            TestCrawlableDatasetFilter.assertTrue((String)("IOException getting children datasets <" + cd.getName() + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        TestCrawlableDatasetFilter.assertTrue((String)("Number of datasets <" + list.size() + "> not as expected <2>."), (list.size() == 5 ? 1 : 0) != 0);
        for (CrawlableDataset curCd : list) {
            TestCrawlableDatasetFilter.assertTrue((String)("Result path <" + curCd.getPath() + "> not as expected <" + this.resultsAll + ">."), (boolean)this.resultsAll.contains(curCd.getPath()));
        }
    }

    public void testRegExpIncludeNcExcludeCVS() {
        String path = "test/data/thredds/cataloggen/testData/modelNotFlat/gfs_211";
        String name = "gfs_211";
        CrawlableDataset cd = TestCrawlableDatasetFilter.createCrawlableDataset(path, name);
        ArrayList<MultiSelectorFilter.Selector> selectors = new ArrayList<MultiSelectorFilter.Selector>();
        selectors.add(new MultiSelectorFilter.Selector((CrawlableDatasetFilter)new RegExpMatchOnNameFilter(".*nc$"), true, true, false));
        selectors.add(new MultiSelectorFilter.Selector((CrawlableDatasetFilter)new RegExpMatchOnNameFilter("CVS"), false, false, true));
        MultiSelectorFilter me = new MultiSelectorFilter(selectors);
        TestCrawlableDatasetFilter.assertTrue((me != null ? 1 : 0) != 0);
        List list = null;
        try {
            list = cd.listDatasets((CrawlableDatasetFilter)me);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TestCrawlableDatasetFilter.assertTrue((String)("Number of datasets <" + list.size() + "> not as expected <2>."), (list.size() == 4 ? 1 : 0) != 0);
        for (CrawlableDataset curCd : list) {
            TestCrawlableDatasetFilter.assertTrue((String)("Result path <" + curCd.getPath() + "> not as expected <" + this.resultsNcNoCVS + ">."), (boolean)this.resultsNcNoCVS.contains(curCd.getPath()));
        }
    }

    public void testWildcardIncludeNcExcludeCVS() {
        String path = "test/data/thredds/cataloggen/testData/modelNotFlat/gfs_211";
        String name = "gfs_211";
        CrawlableDataset cd = TestCrawlableDatasetFilter.createCrawlableDataset(path, name);
        ArrayList<MultiSelectorFilter.Selector> selectors = new ArrayList<MultiSelectorFilter.Selector>();
        selectors.add(new MultiSelectorFilter.Selector((CrawlableDatasetFilter)new WildcardMatchOnNameFilter("*.nc$"), true, true, false));
        selectors.add(new MultiSelectorFilter.Selector((CrawlableDatasetFilter)new WildcardMatchOnNameFilter("CVS"), false, false, true));
        MultiSelectorFilter me = new MultiSelectorFilter(selectors);
        TestCrawlableDatasetFilter.assertTrue((me != null ? 1 : 0) != 0);
        List list = null;
        try {
            list = cd.listDatasets((CrawlableDatasetFilter)me);
        }
        catch (IOException e) {
            TestCrawlableDatasetFilter.assertTrue((String)("IOException getting children datasets <" + cd.getName() + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        TestCrawlableDatasetFilter.assertTrue((String)("Number of datasets <" + list.size() + "> not as expected <2>."), (list.size() == 4 ? 1 : 0) != 0);
        for (CrawlableDataset curCd : list) {
            TestCrawlableDatasetFilter.assertTrue((String)("Result path <" + curCd.getPath() + "> not as expected <" + this.resultsNcNoCVS + ">."), (boolean)this.resultsNcNoCVS.contains(curCd.getPath()));
        }
    }

    private static CrawlableDataset createCrawlableDataset(String path, String name) {
        CrawlableDataset cd = null;
        try {
            cd = CrawlableDatasetFactory.createCrawlableDataset((String)path, null, null);
        }
        catch (Exception e) {
            TestCrawlableDatasetFilter.assertTrue((String)("Failed to create CrawlableDataset <" + path + ">: " + e.getMessage()), (boolean)false);
            return null;
        }
        TestCrawlableDatasetFilter.assertTrue((String)("CD path <" + cd.getPath() + "> not as expected <" + path + ">."), (boolean)cd.getPath().equals(path));
        TestCrawlableDatasetFilter.assertTrue((String)("CD name <" + cd.getName() + "> not as expected <" + name + ">."), (boolean)cd.getName().equals(name));
        return cd;
    }
}

