/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFactory;

public class TestCrawlableDatasetAlias
extends TestCase {
    public TestCrawlableDatasetAlias(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testSingleWildcardAllDirs() {
        String path = "test/data/thredds/cataloggen/testData/uahRadarLevelII/200412*/KBMX";
        String resultPath1 = "test/data/thredds/cataloggen/testData/uahRadarLevelII/20041214/KBMX";
        String resultPath2 = "test/data/thredds/cataloggen/testData/uahRadarLevelII/20041215/KBMX";
        String name = "200412*/KBMX";
        CrawlableDataset cd = null;
        try {
            cd = CrawlableDatasetFactory.createCrawlableDataset((String)path, null, null);
        }
        catch (Exception e) {
            TestCrawlableDatasetAlias.assertTrue((String)("Failed to create CrawlableDataset <" + path + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        TestCrawlableDatasetAlias.assertTrue((String)("CD path <" + cd.getPath() + "> not as expected <" + path + ">."), (boolean)cd.getPath().equals(path));
        TestCrawlableDatasetAlias.assertTrue((String)("CD name <" + cd.getName() + "> not as expected <" + name + ">."), (boolean)cd.getName().equals(name));
        List list = null;
        try {
            list = cd.listDatasets();
        }
        catch (IOException e) {
            TestCrawlableDatasetAlias.assertTrue((String)("IOException getting children datasets <" + cd.getName() + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        TestCrawlableDatasetAlias.assertTrue((String)("Number of datasets <" + list.size() + "> not as expected <2>."), (list.size() == 2 ? 1 : 0) != 0);
        for (CrawlableDataset curCd : list) {
            TestCrawlableDatasetAlias.assertTrue((String)("Result path <" + curCd.getPath() + "> not as expected <" + resultPath1 + " -or- " + resultPath2 + ">."), (curCd.getPath().equals(resultPath1) || curCd.getPath().equals(resultPath2) ? 1 : 0) != 0);
        }
    }

    public void testFileWildcard() {
        String path = "../netcdf-java-2.2/test/data/trajectory/aircraft/uw*nc";
        String name = "uw*nc";
        String resultPath = "../netcdf-java-2.2/test/data/trajectory/aircraft/uw_kingair-2005-01-19-113957.nc";
        CrawlableDataset cd = null;
        try {
            cd = CrawlableDatasetFactory.createCrawlableDataset((String)path, null, null);
        }
        catch (Exception e) {
            TestCrawlableDatasetAlias.assertTrue((String)("Failed to create CrawlableDataset <" + path + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        TestCrawlableDatasetAlias.assertTrue((String)("CD path <" + cd.getPath() + "> not as expected <" + path + ">."), (boolean)cd.getPath().equals(path));
        TestCrawlableDatasetAlias.assertTrue((String)("CD name <" + cd.getName() + "> not as expected <" + name + ">."), (boolean)cd.getName().equals(name));
        List list = null;
        try {
            list = cd.listDatasets();
        }
        catch (IOException e) {
            TestCrawlableDatasetAlias.assertTrue((String)("IOException getting children datasets <" + cd.getName() + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        TestCrawlableDatasetAlias.assertTrue((String)("Number of datasets <" + list.size() + "> not as expected <1>."), (list.size() == 1 ? 1 : 0) != 0);
        CrawlableDataset curCd = (CrawlableDataset)list.get(0);
        TestCrawlableDatasetAlias.assertTrue((String)("Result path <" + curCd.getPath() + "> not as expected <" + resultPath + ">."), (boolean)curCd.getPath().equals(resultPath));
    }

    public void testTwoWildcardOneInFile() {
        String path = "test/data/thredds/cataloggen/testData/uahRadarLevelII/200412*/KBMX/KBMX*bz2";
        ArrayList<String> results = new ArrayList<String>();
        results.add("test/data/thredds/cataloggen/testData/uahRadarLevelII/20041214/KBMX/KBMX_20041214_1014.bz2");
        results.add("test/data/thredds/cataloggen/testData/uahRadarLevelII/20041214/KBMX/KBMX_20041214_1025.bz2");
        results.add("test/data/thredds/cataloggen/testData/uahRadarLevelII/20041215/KBMX/KBMX_20041215_1014.bz2");
        results.add("test/data/thredds/cataloggen/testData/uahRadarLevelII/20041215/KBMX/KBMX_20041215_1025.bz2");
        String name = "200412*/KBMX/KBMX*bz2";
        CrawlableDataset cd = null;
        try {
            cd = CrawlableDatasetFactory.createCrawlableDataset((String)path, null, null);
        }
        catch (Exception e) {
            TestCrawlableDatasetAlias.assertTrue((String)("Failed to create CrawlableDataset <" + path + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        TestCrawlableDatasetAlias.assertTrue((String)("CD path <" + cd.getPath() + "> not as expected <" + path + ">."), (boolean)cd.getPath().equals(path));
        TestCrawlableDatasetAlias.assertTrue((String)("CD name <" + cd.getName() + "> not as expected <" + name + ">."), (boolean)cd.getName().equals(name));
        List list = null;
        try {
            list = cd.listDatasets();
        }
        catch (IOException e) {
            TestCrawlableDatasetAlias.assertTrue((String)("IOException getting children datasets <" + cd.getName() + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        TestCrawlableDatasetAlias.assertTrue((String)("Number of datasets <" + list.size() + "> not as expected <4>."), (list.size() == 4 ? 1 : 0) != 0);
        for (CrawlableDataset curCd : list) {
            TestCrawlableDatasetAlias.assertTrue((String)("Result path <" + curCd.getPath() + "> not as expected <" + results + ">."), (boolean)results.contains(curCd.getPath()));
        }
    }
}

