/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFactory;

public class TestCrawlableDataset
extends TestCase {
    public TestCrawlableDataset(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testEmptyPath() {
        String path = "";
        CrawlableDataset crDs = this.checkCrDs(path, path);
        if (crDs.exists()) {
            TestCrawlableDataset.assertTrue((String)"Unexpected exist()==true for CrDs(\"\").", (boolean)false);
        }
    }

    public void testRootPath() {
        String path = "/";
        String name = "";
        CrawlableDataset crDs = this.checkCrDs(path, name);
        if (!crDs.exists()) {
            TestCrawlableDataset.assertTrue((String)"CrDs(\"/\") doesn't exist.", (boolean)false);
        }
    }

    public void testDotPath() {
        String path = ".";
        String name = ".";
        ArrayList<String> results = new ArrayList<String>();
        results.add("build.xml");
        this.checkCrDsChildren(path, name, results);
    }

    public void testSrcMainJavaPath() {
        String path = "src/main/java";
        String name = "java";
        ArrayList<String> results = new ArrayList<String>();
        results.add("dods");
        results.add("thredds");
        results.add("ucar");
        this.checkCrDsChildren(path, name, results);
    }

    public void testSrcMainJavaDotDotPath() {
        String path = "src/main/java/..";
        String name = "..";
        ArrayList<String> results = new ArrayList<String>();
        results.add("java");
        results.add("resources");
        this.checkCrDsChildren(path, name, results);
    }

    public void testSrcMainJavaDotDotSlashDotDotPath() {
        String path = "src/main/java/../..";
        String name = "..";
        ArrayList<String> results = new ArrayList<String>();
        results.add("main");
        results.add("test");
        results.add("timing");
        this.checkCrDsChildren(path, name, results);
    }

    private CrawlableDataset checkCrDs(String path, String name) {
        CrawlableDataset cd = null;
        try {
            cd = CrawlableDatasetFactory.createCrawlableDataset((String)path, null, null);
        }
        catch (Exception e) {
            TestCrawlableDataset.assertTrue((String)("Failed to create CrawlableDataset <" + path + ">: " + e.getMessage()), (boolean)false);
            return null;
        }
        TestCrawlableDataset.assertTrue((String)("CD path <" + cd.getPath() + "> not as expected <" + path + ">."), (boolean)cd.getPath().equals(path));
        TestCrawlableDataset.assertTrue((String)("CD name <" + cd.getName() + "> not as expected <" + name + ">."), (boolean)cd.getName().equals(name));
        return cd;
    }

    private void checkCrDsChildren(String path, String name, List expectedChildrenNames) {
        CrawlableDataset crDs = this.checkCrDs(path, name);
        if (!crDs.exists()) {
            TestCrawlableDataset.assertTrue((String)("CrDs(\"" + path + "\" doesn't exist."), (boolean)false);
            return;
        }
        if (!crDs.isCollection()) {
            TestCrawlableDataset.assertTrue((String)("CrDs(\"" + path + "\" is not a collection."), (boolean)false);
            return;
        }
        List list = null;
        try {
            list = crDs.listDatasets();
        }
        catch (IOException e) {
            TestCrawlableDataset.assertTrue((String)("IOException getting children datasets <" + crDs.getName() + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        TestCrawlableDataset.assertTrue((String)("Number of datasets <" + list.size() + "> not as expected <" + expectedChildrenNames.size() + ">."), (list.size() >= expectedChildrenNames.size() ? 1 : 0) != 0);
        ArrayList<String> crDsNameList = new ArrayList<String>();
        for (CrawlableDataset curCd : list) {
            crDsNameList.add(curCd.getName());
        }
        for (String curName : expectedChildrenNames) {
            TestCrawlableDataset.assertTrue((String)("Result path <" + curName + "> not as expected <" + expectedChildrenNames + ">."), (boolean)crDsNameList.contains(curName));
        }
    }
}

