/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import junit.framework.TestCase;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.cataloggen.DatasetEnhancer1;

public class TestDatasetEnhancer1
extends TestCase {
    private DatasetEnhancer1 me;

    public TestDatasetEnhancer1(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testAddTimeCoverage() {
        String matchPattern = "([0-9][0-9][0-9][0-9])([0-9][0-9])([0-9][0-9])([0-9][0-9])";
        String substitutionPattern = "$1-$2-$3T$4:00:00";
        String duration = "60 hours";
        DatasetEnhancer1.AddTimeCoverageModels adder = new DatasetEnhancer1.AddTimeCoverageModels(matchPattern, substitutionPattern, duration);
        InvDatasetImpl dataset = new InvDatasetImpl(null, "2005061512_NAM.wmo");
        adder.addMetadata((InvDataset)dataset);
        String expectedDateText = "2005-06-15T12:00:00";
        String dateText = dataset.getTimeCoverage().getStart().getText();
        TestDatasetEnhancer1.assertTrue((String)("Date text <" + dateText + "> not as expected <" + expectedDateText + ">."), (boolean)dateText.equals(expectedDateText));
    }

    public void testAddId() {
        DatasetEnhancer1.AddId adder = new DatasetEnhancer1.AddId("baseId");
        InvDatasetImpl dataset = new InvDatasetImpl(null, "2005061512_NAM.wmo");
        adder.addMetadata((InvDataset)dataset);
        String expectedId = "baseId/2005061512_NAM.wmo";
        String id = dataset.getID();
        TestDatasetEnhancer1.assertTrue((String)("ID <" + id + "> not as expected <" + expectedId + ">."), (boolean)id.equals(expectedId));
    }
}

