/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.xml.parser.CatalogXmlUtils;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;

public class IdAuthorityInheritanceTest {
    @Test
    public void checkDatasetWithIdAuthorityAsAttributeAsExpected() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/IdAuthorityInheritanceTest/attribute.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = IdAuthorityInheritanceTest.setupDatasetWithIdAuthorityAsAttribute();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogAsExpected(catBuilder, docBaseUri, null);
        IdAuthorityInheritanceTest.assertDatasetOneHasAuthorityOne(catBuilder);
    }

    private static String setupDatasetWithIdAuthorityAsAttribute() {
        StringBuilder sb = new StringBuilder().append("<dataset name='dataset' ID='DS1' authority='auth1' />");
        return CatalogXmlUtils.wrapThreddsXmlInCatalog(sb.toString(), null);
    }

    @Test
    public void checkDatasetWithIdAuthorityAsChildElementAsExpected() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/IdAuthorityInheritanceTest/childElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = IdAuthorityInheritanceTest.setupDatasetWithIdAuthorityAsChildElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogAsExpected(catBuilder, docBaseUri, null);
        IdAuthorityInheritanceTest.assertDatasetOneHasAuthorityOne(catBuilder);
    }

    private static String setupDatasetWithIdAuthorityAsChildElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='dataset 1' ID='DS1'>").append("  <authority>auth1</authority>").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalog(sb.toString(), null);
    }

    @Test
    public void checkDatasetWithIdAuthorityInMetadataElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/IdAuthorityInheritanceTest/metadataElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = IdAuthorityInheritanceTest.setupDatasetWithIdAuthorityInMetadataElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogAsExpected(catBuilder, docBaseUri, null);
        IdAuthorityInheritanceTest.assertDatasetOneHasAuthorityOne(catBuilder);
    }

    private static String setupDatasetWithIdAuthorityInMetadataElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='dataset 1' ID='DS1'>").append("  <metadata>").append("    <authority>auth1</authority>").append("  </metadata>").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalog(sb.toString(), null);
    }

    @Test
    public void checkDatasetWithIdAuthorityInInheritedMetadataElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/IdAuthorityInheritanceTest/inheritedMetadataElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = IdAuthorityInheritanceTest.setupDatasetWithIdAuthorityInInheritedMetadataElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogAsExpected(catBuilder, docBaseUri, null);
        IdAuthorityInheritanceTest.assertDatasetOneHasAuthorityOne(catBuilder);
    }

    private static String setupDatasetWithIdAuthorityInInheritedMetadataElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='dataset 1' ID='DS1'>").append("  <metadata inherited='true'>").append("    <authority>auth1</authority>").append("  </metadata>").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalog(sb.toString(), null);
    }

    @Test
    public void checkDatasetNotInheritingIdAuthorityFromParentAuthorityAttribute() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/IdAuthorityInheritanceTest/notInheritFromParentAttribute.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = IdAuthorityInheritanceTest.setupDatasetNotInheritingIdAuthorityFromParentAuthorityAttribute();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogAsExpected(catBuilder, docBaseUri, null);
        IdAuthorityInheritanceTest.assertDatasetTwoHasNoAuthority(catBuilder);
    }

    private static String setupDatasetNotInheritingIdAuthorityFromParentAuthorityAttribute() {
        StringBuilder sb = new StringBuilder().append("<dataset name='dataset 1' ID='DS1' authority='auth1'>").append("  <dataset name='dataset 2' ID='DS2' />").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalog(sb.toString(), null);
    }

    @Test
    public void checkDatasetNotInheritingIdAuthorityFromParentAuthorityElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/IdAuthorityInheritanceTest/notInheritFromParentElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = IdAuthorityInheritanceTest.setupDatasetNotInheritingIdAuthorityFromParentAuthorityElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogAsExpected(catBuilder, docBaseUri, null);
        IdAuthorityInheritanceTest.assertDatasetTwoHasNoAuthority(catBuilder);
    }

    private static String setupDatasetNotInheritingIdAuthorityFromParentAuthorityElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='dataset 1' ID='DS1'>").append("  <authority>auth1</authority>").append("  <dataset name='dataset 2' ID='DS2' />").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalog(sb.toString(), null);
    }

    @Test
    public void checkDatasetNotInheritingIdAuthorityFromParentMetadataAuthorityElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/IdAuthorityInheritanceTest/notInheritFromParentMetadataAuthorityElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = IdAuthorityInheritanceTest.setupDatasetNotInheritingIdAuthorityFromParentMetadataAuthorityElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogAsExpected(catBuilder, docBaseUri, null);
        IdAuthorityInheritanceTest.assertDatasetTwoHasNoAuthority(catBuilder);
    }

    private static String setupDatasetNotInheritingIdAuthorityFromParentMetadataAuthorityElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='dataset 1' ID='DS1'>").append("  <metadata>").append("    <authority>auth1</authority>").append("  </metadata>").append("  <dataset name='dataset 2' ID='DS2' />").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalog(sb.toString(), null);
    }

    @Test
    public void checkDatasetInheritingIdAuthorityFromParentInheritedMetadataAuthorityElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/IdAuthorityInheritanceTest/inheritFromParentInheritedMetadataAuthorityElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = IdAuthorityInheritanceTest.setupDatasetInheritingIdAuthorityFromParentInheritedMetadataAuthorityElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogAsExpected(catBuilder, docBaseUri, null);
        IdAuthorityInheritanceTest.assertDatasetTwoHasAuthorityOne(catBuilder);
    }

    private static String setupDatasetInheritingIdAuthorityFromParentInheritedMetadataAuthorityElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='dataset 1' ID='DS1'>").append("  <metadata inherited='true'>").append("    <authority>auth1</authority>").append("  </metadata>").append("  <dataset name='dataset 2' ID='DS2' />").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalog(sb.toString(), null);
    }

    @Test
    public void checkDatasetOverridingInheritedIdAuthorityWithAttribute() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/IdAuthorityInheritanceTest/overrideInheritedWithAttribute.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = IdAuthorityInheritanceTest.setupDatasetOverridingInheritedIdAuthorityWithAttribute();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogAsExpected(catBuilder, docBaseUri, null);
        IdAuthorityInheritanceTest.assertDatasetTwoHasAuthorityTwo(catBuilder);
    }

    private static String setupDatasetOverridingInheritedIdAuthorityWithAttribute() {
        StringBuilder sb = new StringBuilder().append("<dataset name='dataset 1' ID='DS1'>").append("  <metadata inherited='true'>").append("    <authority>auth1</authority>").append("  </metadata>").append("  <dataset name='dataset 2' ID='DS2' authority='auth2' />").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalog(sb.toString(), null);
    }

    @Test
    public void checkDatasetOverridingInheritedIdAuthorityWithChildElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/IdAuthorityInheritanceTest/overrideInheritedWithElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = IdAuthorityInheritanceTest.setupDatasetOverridingInheritedIdAuthorityWithChildElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogAsExpected(catBuilder, docBaseUri, null);
        IdAuthorityInheritanceTest.assertDatasetTwoHasAuthorityTwo(catBuilder);
    }

    private static String setupDatasetOverridingInheritedIdAuthorityWithChildElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='dataset 1' ID='DS1'>").append("  <metadata inherited='true'>").append("    <authority>auth1</authority>").append("  </metadata>").append("  <dataset name='dataset 2' ID='DS2'>").append("    <authority>auth2</authority>").append("  </dataset>").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalog(sb.toString(), null);
    }

    @Test
    public void checkDatasetOverridingInheritedIdAuthorityWithChildMetadataElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/IdAuthorityInheritanceTest/overrideInheritedWithchildMetadataElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = IdAuthorityInheritanceTest.setupDatasetOverridingInheritedIdAuthorityWithChildMetadataElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogAsExpected(catBuilder, docBaseUri, null);
        IdAuthorityInheritanceTest.assertDatasetTwoHasAuthorityTwo(catBuilder);
    }

    private static String setupDatasetOverridingInheritedIdAuthorityWithChildMetadataElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='dataset 1' ID='DS1'>").append("  <metadata inherited='true'>").append("    <authority>auth1</authority>").append("  </metadata>").append("  <dataset name='dataset 2' ID='DS2'>").append("    <metadata>").append("      <authority>auth2</authority>").append("    </metadata>").append("  </dataset>").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalog(sb.toString(), null);
    }

    @Test
    public void checkDatasetOverridingInheritedIdAuthorityWithChildInheritedMetadataElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/IdAuthorityInheritanceTest/overrideInheritedWithchildInheritedMetadataElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = IdAuthorityInheritanceTest.setupDatasetOverridingInheritedIdAuthorityWithChildInheritedMetadataElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogAsExpected(catBuilder, docBaseUri, null);
        IdAuthorityInheritanceTest.assertDatasetTwoHasAuthorityTwo(catBuilder);
    }

    private static String setupDatasetOverridingInheritedIdAuthorityWithChildInheritedMetadataElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='dataset 1' ID='DS1'>").append("  <metadata inherited='true'>").append("    <authority>auth1</authority>").append("  </metadata>").append("  <dataset name='dataset 2' ID='DS2'>").append("    <metadata inherited='true'>").append("      <authority>auth2</authority>").append("    </metadata>").append("  </dataset>").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalog(sb.toString(), null);
    }

    private static void assertDatasetOneHasAuthorityOne(CatalogBuilder catBuilder) {
        DatasetBuilder dsBldr = IdAuthorityInheritanceTest.assertGetDatasetOne(catBuilder);
        Assert.assertEquals((Object)"auth1", (Object)dsBldr.getIdAuthority());
    }

    private static void assertDatasetTwoHasNoAuthority(CatalogBuilder catBuilder) {
        DatasetBuilder dsBldr = IdAuthorityInheritanceTest.assertGetDatasetTwo(catBuilder);
        Assert.assertNull((Object)dsBldr.getIdAuthority());
    }

    private static void assertDatasetTwoHasAuthorityOne(CatalogBuilder catBuilder) {
        DatasetBuilder dsBldr = IdAuthorityInheritanceTest.assertGetDatasetTwo(catBuilder);
        Assert.assertEquals((Object)"auth1", (Object)dsBldr.getIdAuthority());
    }

    private static void assertDatasetTwoHasAuthorityTwo(CatalogBuilder catBuilder) {
        DatasetBuilder dsBldr = IdAuthorityInheritanceTest.assertGetDatasetTwo(catBuilder);
        Assert.assertEquals((Object)"auth2", (Object)dsBldr.getIdAuthority());
    }

    private static DatasetBuilder assertGetDatasetOne(CatalogBuilder catBuilder) {
        List datasetNodes = catBuilder.getDatasetNodeBuilders();
        Assert.assertEquals((long)1L, (long)datasetNodes.size());
        DatasetBuilder dsBldr = (DatasetBuilder)datasetNodes.get(0);
        Assert.assertEquals((Object)"DS1", (Object)dsBldr.getId());
        return dsBldr;
    }

    private static DatasetBuilder assertGetDatasetTwo(CatalogBuilder catBuilder) {
        DatasetBuilder dsBldr = IdAuthorityInheritanceTest.assertGetDatasetOne(catBuilder);
        List datasetNodes = dsBldr.getDatasetNodeBuilders();
        Assert.assertEquals((long)1L, (long)datasetNodes.size());
        dsBldr = (DatasetBuilder)datasetNodes.get(0);
        Assert.assertEquals((Object)"DS2", (Object)dsBldr.getId());
        return dsBldr;
    }
}

