/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import thredds.cataloggen.TestCatalogGen;
import ucar.nc2.TestAll;

public class TestInvDatasetScan
extends TestCase {
    private boolean debugShowCatalogs = true;
    private String dsScanName = "Test Data";
    private String dsScanPath = "testData";
    private String dsScanDir = TestAll.cdmLocalTestDataDir;
    private String dsScanFilter = ".*\\.nc$";
    private String serviceName = "ncdods";
    private String baseURL = "http://localhost:8080/thredds/docsC";
    private String configResourcePath = "/thredds/catalog";
    private String testInvDsScan_emptyServiceBase_ResourceName = "testInvDsScan.emptyServiceBase.result.xml";
    private String testInvDsScan_topLevelCat_ResourceName = "testInvDsScan.topLevelCat.result.xml";
    private String testInvDsScan_secondLevelCat_ResourceName = "testInvDsScan.secondLevelCat.result.xml";
    private String testInvDsScan_timeCoverage_ResourceName = "testInvDsScan.timeCoverage.result.xml";
    private String testInvDsScan_addIdTopLevel_ResourceName = "testInvDsScan.addIdTopLevel.result.xml";
    private String testInvDsScan_addIdLowerLevel_ResourceName = "testInvDsScan.addIdLowerLevel.result.xml";
    private String testInvDsScan_compoundServiceLower_ResourceName = "testInvDsScan.compoundServiceLower.result.xml";
    private String testInvDsScan_addDatasetSize_ResourceName = "testInvDsScan.addDatasetSize.result.xml";
    private String testInvDsScan_addLatest_ResourceName = "testInvDsScan.addLatest.result.xml";
    private String testInvDsScan_compoundServerFilterProblem_1_ResourceName = "testInvDsScan.compoundServerFilterProblem.1.result.xml";
    private String testInvDsScan_compoundServerFilterProblem_2_ResourceName = "testInvDsScan.compoundServerFilterProblem.2.result.xml";

    public TestInvDatasetScan(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testEmptyServiceBase() {
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.testInvDsScan_emptyServiceBase_ResourceName;
        InvCatalogImpl configCat = null;
        configCat = new InvCatalogImpl("Test Data Catalog for NetCDF-OPeNDAP Server", "1.0.1", null);
        InvService myService = new InvService(this.serviceName, ServiceType.DODS.toString(), "", null, null);
        configCat.addService(myService);
        InvDatasetScan me = new InvDatasetScan(configCat, null, this.dsScanName, this.dsScanPath, this.dsScanDir, this.dsScanFilter, false, "false", false, null, null, null);
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(myService.getName());
        InvMetadata md = new InvMetadata((InvDataset)me, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, (Object)tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        me.setLocalMetadata(tm2);
        configCat.addDataset((InvDatasetImpl)me);
        configCat.finish();
        URI reqURI = null;
        String reqUriString = this.baseURL + "/" + this.dsScanPath + "/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl catalog = me.makeCatalogForDirectory(this.dsScanPath + "/catalog.xml", reqURI);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)catalog, expectedCatalogResourceName, this.debugShowCatalogs);
    }

    public void testTopLevelCatalog() {
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.testInvDsScan_topLevelCat_ResourceName;
        InvCatalogImpl configCat = null;
        try {
            configCat = new InvCatalogImpl("Test Data Catalog for NetCDF-OPeNDAP Server", "1.0.1", new URI(this.baseURL));
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + this.baseURL + ">: " + e.getMessage()), (boolean)false);
        }
        InvService myService = new InvService(this.serviceName, ServiceType.DODS.toString(), this.baseURL, null, null);
        configCat.addService(myService);
        InvDatasetScan me = new InvDatasetScan(configCat, null, this.dsScanName, this.dsScanPath, this.dsScanDir, this.dsScanFilter, false, "false", false, null, null, null);
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(myService.getName());
        InvMetadata md = new InvMetadata((InvDataset)me, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, (Object)tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        me.setLocalMetadata(tm2);
        configCat.addDataset((InvDatasetImpl)me);
        configCat.finish();
        URI reqURI = null;
        String reqUriString = this.baseURL + "/" + this.dsScanPath + "/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl catalog = me.makeCatalogForDirectory(this.dsScanPath + "/catalog.xml", reqURI);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)catalog, expectedCatalogResourceName, this.debugShowCatalogs);
    }

    public void testSecondLevelCatalog() {
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.testInvDsScan_secondLevelCat_ResourceName;
        InvCatalogImpl configCat = null;
        try {
            configCat = new InvCatalogImpl("Test Data Catalog for NetCDF-OPeNDAP Server", "1.0.1", new URI(this.baseURL));
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + this.baseURL + ">: " + e.getMessage()), (boolean)false);
        }
        InvService myService = new InvService(this.serviceName, ServiceType.DODS.toString(), this.baseURL, null, null);
        configCat.addService(myService);
        InvDatasetScan me = new InvDatasetScan(configCat, null, this.dsScanName, this.dsScanPath, this.dsScanDir, this.dsScanFilter, false, "false", false, null, null, null);
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(myService.getName());
        InvMetadata md = new InvMetadata((InvDataset)me, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, (Object)tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        me.setLocalMetadata(tm2);
        configCat.addDataset((InvDatasetImpl)me);
        configCat.finish();
        URI reqURI = null;
        String reqUriString = this.baseURL + "/" + this.dsScanPath + "/trajectory/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl catalog = me.makeCatalogForDirectory(this.dsScanPath + "/trajectory/catalog.xml", reqURI);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)catalog, expectedCatalogResourceName, this.debugShowCatalogs);
    }

    public void testAddTimeCoverage() {
        String dsScanName = "Test Data";
        String dsScanPath = "testData";
        String dsScanDir = "test/data/thredds/cataloggen/testData/model";
        String dsScanFilter = ".*\\.nc$";
        String serviceName = "ncdods";
        String baseURL = "http://localhost:8080/thredds/docsC";
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.testInvDsScan_timeCoverage_ResourceName;
        String matchPattern = "([0-9][0-9][0-9][0-9])([0-9][0-9])([0-9][0-9])([0-9][0-9])";
        String substitutionPattern = "$1-$2-$3T$4:00:00";
        String duration = "60 hours";
        InvCatalogImpl configCat = null;
        try {
            configCat = new InvCatalogImpl("Test Data Catalog for NetCDF-OPeNDAP Server", "1.0.1", new URI(baseURL));
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + baseURL + ">: " + e.getMessage()), (boolean)false);
        }
        InvService myService = new InvService(serviceName, ServiceType.DODS.toString(), baseURL, null, null);
        configCat.addService(myService);
        InvDatasetScan me = new InvDatasetScan(configCat, null, dsScanName, dsScanPath, dsScanDir, dsScanFilter, false, "false", false, matchPattern, substitutionPattern, duration);
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(myService.getName());
        InvMetadata md = new InvMetadata((InvDataset)me, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, (Object)tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        me.setLocalMetadata(tm2);
        configCat.addDataset((InvDatasetImpl)me);
        configCat.finish();
        URI reqURI = null;
        String reqUriString = baseURL + "/" + dsScanPath + "/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl catalog = me.makeCatalogForDirectory(dsScanPath + "/catalog.xml", reqURI);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)catalog, expectedCatalogResourceName, this.debugShowCatalogs);
    }

    public void testAddIdLowerLevel() {
        String dsScanName = "Test Data";
        String dsScanPath = "testData";
        String dsScanDir = "test/data/thredds/cataloggen/testData/modelNotFlat";
        String dsScanFilter = ".*\\.nc$";
        String serviceName = "ncdods";
        String baseURL = "http://localhost:8080/thredds/docsC";
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.testInvDsScan_addIdLowerLevel_ResourceName;
        String topLevelId = "my/data/models";
        InvCatalogImpl configCat = null;
        try {
            configCat = new InvCatalogImpl("Test Data Catalog for NetCDF-OPeNDAP Server", "1.0.1", new URI(baseURL));
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + baseURL + ">: " + e.getMessage()), (boolean)false);
        }
        InvService myService = new InvService(serviceName, ServiceType.DODS.toString(), baseURL, null, null);
        configCat.addService(myService);
        InvDatasetScan me = new InvDatasetScan(configCat, null, dsScanName, dsScanPath, dsScanDir, dsScanFilter, false, "false", false, null, null, null);
        me.setID(topLevelId);
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(myService.getName());
        InvMetadata md = new InvMetadata((InvDataset)me, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, (Object)tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        me.setLocalMetadata(tm2);
        configCat.addDataset((InvDatasetImpl)me);
        configCat.finish();
        URI reqURI = null;
        String s = baseURL + "/" + dsScanPath + "/eta_211/catalog.xml";
        try {
            reqURI = new URI(s);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + s + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl catalog = me.makeCatalogForDirectory(dsScanPath + "/eta_211/catalog.xml", reqURI);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)catalog, expectedCatalogResourceName, this.debugShowCatalogs);
    }

    public void testAddIdTopLevel() {
        String dsScanName = "Test Data";
        String dsScanPath = "testData";
        String dsScanDir = "test/data/thredds/cataloggen/testData/model";
        String dsScanFilter = ".*\\.nc$";
        String serviceName = "ncdods";
        String baseURL = "http://localhost:8080/thredds/docsC";
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.testInvDsScan_addIdTopLevel_ResourceName;
        String topLevelId = "my/data/models";
        InvCatalogImpl configCat = null;
        try {
            configCat = new InvCatalogImpl("Test Data Catalog for NetCDF-OPeNDAP Server", "1.0.1", new URI(baseURL));
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + baseURL + ">: " + e.getMessage()), (boolean)false);
        }
        InvService myService = new InvService(serviceName, ServiceType.DODS.toString(), baseURL, null, null);
        configCat.addService(myService);
        InvDatasetScan me = new InvDatasetScan(configCat, null, dsScanName, dsScanPath, dsScanDir, dsScanFilter, false, "false", false, null, null, null);
        me.setID(topLevelId);
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(myService.getName());
        InvMetadata md = new InvMetadata((InvDataset)me, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, (Object)tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        me.setLocalMetadata(tm2);
        configCat.addDataset((InvDatasetImpl)me);
        configCat.finish();
        URI reqURI = null;
        String s = baseURL + "/" + dsScanPath + "/catalog.xml";
        try {
            reqURI = new URI(s);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + s + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl catalog = me.makeCatalogForDirectory(dsScanPath + "/catalog.xml", reqURI);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)catalog, expectedCatalogResourceName, this.debugShowCatalogs);
    }

    public void testCompoundServiceLower() {
        String dsScanName = "Test Data";
        String dsScanPath = "testData";
        String dsScanDir = "test/data/thredds/cataloggen/testData/modelNotFlat";
        String dsScanFilter = ".*\\.nc$";
        String serviceName = "both";
        String baseURL = "http://localhost:8080/thredds";
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.testInvDsScan_compoundServiceLower_ResourceName;
        String topLevelId = "my/data/models";
        InvCatalogImpl configCat = null;
        try {
            configCat = new InvCatalogImpl("Test Data Catalog for NetCDF-OPeNDAP Server", "1.0.1", new URI(baseURL));
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + baseURL + ">: " + e.getMessage()), (boolean)false);
        }
        InvService myService = new InvService(serviceName, ServiceType.COMPOUND.toString(), "", null, null);
        myService.addService(new InvService("tdsDods", ServiceType.DODS.toString(), "/thredds/dodsC", null, null));
        myService.addService(new InvService("tdsHttp", ServiceType.HTTPServer.toString(), "/thredds/fileServer", null, null));
        configCat.addService(myService);
        InvDatasetScan me = new InvDatasetScan(configCat, null, dsScanName, dsScanPath, dsScanDir, dsScanFilter, false, "false", false, null, null, null);
        me.setID(topLevelId);
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(myService.getName());
        InvMetadata md = new InvMetadata((InvDataset)me, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, (Object)tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        me.setLocalMetadata(tm2);
        configCat.addDataset((InvDatasetImpl)me);
        configCat.finish();
        URI reqURI = null;
        String reqUriString = baseURL + "/" + dsScanPath + "/eta_211/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl catalog = me.makeCatalogForDirectory(dsScanPath + "/eta_211/catalog.xml", reqURI);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)catalog, expectedCatalogResourceName, this.debugShowCatalogs);
    }

    public void testAddDatasetSize() {
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.testInvDsScan_addDatasetSize_ResourceName;
        InvCatalogImpl configCat = null;
        configCat = new InvCatalogImpl("Test Data Catalog for NetCDF-OPeNDAP Server", "1.0.1", null);
        InvService myService = new InvService(this.serviceName, ServiceType.DODS.toString(), "", null, null);
        configCat.addService(myService);
        InvDatasetScan me = new InvDatasetScan(configCat, null, this.dsScanName, this.dsScanPath, this.dsScanDir, ".*\\.OIS$", true, "false", false, null, null, null);
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(myService.getName());
        InvMetadata md = new InvMetadata((InvDataset)me, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, (Object)tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        me.setLocalMetadata(tm2);
        configCat.addDataset((InvDatasetImpl)me);
        configCat.finish();
        URI reqURI = null;
        String reqUriString = this.baseURL + "/" + this.dsScanPath + "/dmsp/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl catalog = me.makeCatalogForDirectory(this.dsScanPath + "/dmsp/catalog.xml", reqURI);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)catalog, expectedCatalogResourceName, this.debugShowCatalogs);
    }

    public void testAddLatest() {
        String dsScanName = "Test Data";
        String dsScanPath = "testData";
        String dsScanDir = "test/data/thredds/cataloggen/testData/modelNotFlat";
        String dsScanFilter = ".*\\.nc$";
        String baseURL = "http://localhost:8080/thredds/docsC";
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.testInvDsScan_addLatest_ResourceName;
        String topLevelId = "my/data/models";
        InvCatalogImpl configCat = null;
        try {
            configCat = new InvCatalogImpl("Test Data Catalog for NetCDF-OPeNDAP Server", "1.0.1", new URI(baseURL));
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + baseURL + ">: " + e.getMessage()), (boolean)false);
        }
        InvService myService = new InvService("myserver", ServiceType.COMPOUND.toString(), "", null, null);
        myService.addService(new InvService("tdsDods", ServiceType.DODS.toString(), "/thredds/dodsC", null, null));
        myService.addService(new InvService("tdsHttp", ServiceType.HTTPServer.toString(), "/thredds/fileServer", null, null));
        configCat.addService(myService);
        InvService latestService = new InvService("latest", ServiceType.RESOLVER.toString(), "", null, null);
        configCat.addService(latestService);
        InvDatasetScan me = new InvDatasetScan(configCat, null, dsScanName, dsScanPath, dsScanDir, dsScanFilter, false, "true", false, null, null, null);
        me.setID(topLevelId);
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(myService.getName());
        InvMetadata md = new InvMetadata((InvDataset)me, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, (Object)tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        me.setLocalMetadata(tm2);
        configCat.addDataset((InvDatasetImpl)me);
        configCat.finish();
        URI reqURI = null;
        String s = baseURL + "/" + dsScanPath + "/eta_211/catalog.xml";
        try {
            reqURI = new URI(s);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + s + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl catalog = me.makeCatalogForDirectory(dsScanPath + "/eta_211/catalog.xml", reqURI);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)catalog, expectedCatalogResourceName, this.debugShowCatalogs);
    }

    public void testAddLatestServiceBaseNotEmpty() {
        String dsScanName = "Test Data";
        String dsScanPath = "testData";
        String dsScanDir = "test/data/thredds/cataloggen/testData/modelNotFlat";
        String dsScanFilter = ".*\\.nc$";
        String baseURL = "http://localhost:8080/thredds/docsC";
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.testInvDsScan_addLatest_ResourceName;
        String topLevelId = "my/data/models";
        InvCatalogImpl configCat = null;
        try {
            configCat = new InvCatalogImpl("Test Data Catalog for NetCDF-OPeNDAP Server", "1.0.1", new URI(baseURL));
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + baseURL + ">: " + e.getMessage()), (boolean)false);
        }
        InvService myService = new InvService("myserver", ServiceType.COMPOUND.toString(), "", null, null);
        myService.addService(new InvService("tdsDods", ServiceType.DODS.toString(), "/thredds/dodsC", null, null));
        myService.addService(new InvService("tdsHttp", ServiceType.HTTPServer.toString(), "/thredds/fileServer", null, null));
        configCat.addService(myService);
        InvService latestService = new InvService("latest", ServiceType.RESOLVER.toString(), "/thredds/dqc/latest", null, null);
        configCat.addService(latestService);
        InvDatasetScan me = new InvDatasetScan(configCat, null, dsScanName, dsScanPath, dsScanDir, dsScanFilter, false, "true", false, null, null, null);
        me.setID(topLevelId);
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(myService.getName());
        InvMetadata md = new InvMetadata((InvDataset)me, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, (Object)tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        me.setLocalMetadata(tm2);
        configCat.addDataset((InvDatasetImpl)me);
        configCat.finish();
        URI reqURI = null;
        String s = baseURL + "/" + dsScanPath + "/eta_211/catalog.xml";
        try {
            reqURI = new URI(s);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + s + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl catalog = me.makeCatalogForDirectory(dsScanPath + "/eta_211/catalog.xml", reqURI);
        System.out.println("NEEDS WORK: don't have a real use case here - probably need a different ProxyDatasetHandler.");
        System.out.println("            Possible use case: current DQC Latest server URLs like \"/thredds/dqc/latest?eta_211\".");
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)catalog, expectedCatalogResourceName, this.debugShowCatalogs);
    }

    public void testCompoundServerFilterProblem() {
        InvCatalogImpl configCat;
        String expectedCatalog1ResourceName = this.configResourcePath + "/" + this.testInvDsScan_compoundServerFilterProblem_1_ResourceName;
        String expectedCatalog2ResourceName = this.configResourcePath + "/" + this.testInvDsScan_compoundServerFilterProblem_2_ResourceName;
        try {
            configCat = new InvCatalogImpl("Test Data Catalog for NetCDF-OPeNDAP Server", "1.0.1", new URI(this.baseURL));
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + this.baseURL + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        InvService myService = new InvService("myserver", ServiceType.COMPOUND.toString(), "", null, null);
        myService.addService(new InvService("tdsDods", ServiceType.DODS.toString(), "/thredds/dodsC", null, null));
        myService.addService(new InvService("tdsHttp", ServiceType.HTTPServer.toString(), "/thredds/fileServer", null, null));
        myService.addService(new InvService("tdsWcs", ServiceType.WCS.toString(), "/thredds/wcs", null, null));
        configCat.addService(myService);
        InvDatasetScan dsScan1 = new InvDatasetScan(configCat, null, "Data", "testRelative", "C:\\Program Files\\Apache Software Foundation\\Tomcat 5.0\\content\\thredds\\dodsC\\data", "^test.*nc$", true, "false", false, null, null, null);
        dsScan1.setID("test/relative");
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(myService.getName());
        InvMetadata md = new InvMetadata((InvDataset)dsScan1, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, (Object)tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        dsScan1.setLocalMetadata(tm2);
        configCat.addDataset((InvDatasetImpl)dsScan1);
        InvDatasetScan dsScan2 = new InvDatasetScan(configCat, null, "Eta", "testRelativeEta", "C:\\Program Files\\Apache Software Foundation\\Tomcat 5.0\\content\\thredds\\dodsC\\data", "^2004.*nc$", true, "false", false, null, null, null);
        dsScan2.setID("test/eta");
        tm = new ThreddsMetadata(false);
        tm.setServiceName(myService.getName());
        md = new InvMetadata((InvDataset)dsScan2, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, (Object)tm);
        tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        dsScan2.setLocalMetadata(tm2);
        configCat.addDataset((InvDatasetImpl)dsScan2);
        configCat.finish();
        URI reqURI = null;
        String reqUriString = this.baseURL + "/testRelative/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl catalog1 = dsScan1.makeCatalogForDirectory("testRelative/catalog.xml", reqURI);
        URI reqURI2 = null;
        String reqUriString2 = this.baseURL + "/testRelativeEta/catalog.xml";
        try {
            reqURI = new URI(reqUriString2);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString2 + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl catalog2 = dsScan2.makeCatalogForDirectory("testRelativeEta/catalog.xml", reqURI2);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)catalog1, expectedCatalog1ResourceName, this.debugShowCatalogs);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)catalog2, expectedCatalog2ResourceName, this.debugShowCatalogs);
    }

    public void testSubsetCatOnDs() {
        String filePath = "test/data/thredds/catalog";
        String inFileName = "testInvDsScan.subsetCatOnDs.input.xml";
        String resFileName = "testInvDsScan.subsetCatOnDs.result.xml";
        String targetDatasetID = "NCEP/GFS/Alaska_191km/GFS_Alaska_191km_20051011_1800.grib1";
        File inFile = new File(filePath, inFileName);
        InvCatalogFactory fac = InvCatalogFactory.getDefaultFactory((boolean)false);
        InvCatalogImpl cat = fac.readXML(inFile.toURI());
        InvDataset targetDs = cat.findDatasetByID(targetDatasetID);
        cat.subset(targetDs);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat, this.configResourcePath + "/" + resFileName, this.debugShowCatalogs);
    }

    public void testDsScanPreRefactor() {
        String filePath = "test/data/thredds/catalog";
        String inFileName = "testInvDsScan.dsScanPreRefactor.input.xml";
        String res1Name = "/thredds/catalog/testInvDsScan.dsScanPreRefactor.result1.xml";
        String res2Name = "/thredds/catalog/testInvDsScan.dsScanPreRefactor.result2.xml";
        String res3Name = "/thredds/catalog/testInvDsScan.dsScanPreRefactor.result3.xml";
        File inFile = new File(filePath, inFileName);
        InvCatalogFactory fac = InvCatalogFactory.getDefaultFactory((boolean)false);
        InvCatalogImpl catalog = fac.readXML(inFile.toURI());
        TestInvDatasetScan.assertTrue((String)"Read resulted in null catalog.", (catalog != null ? 1 : 0) != 0);
        String baseURI = catalog.getBaseURI().toString();
        String expectedBaseURI = inFile.toURI().toString();
        TestInvDatasetScan.assertTrue((String)("Base URI <" + baseURI + "> not as expected <" + expectedBaseURI + ">."), (boolean)baseURI.equals(expectedBaseURI));
        String targetDsId = "myGridDataID";
        InvDataset targetDs = catalog.findDatasetByID(targetDsId);
        TestInvDatasetScan.assertTrue((String)("Did not find dataset <id=" + targetDsId + ">."), (targetDs != null ? 1 : 0) != 0);
        TestInvDatasetScan.assertTrue((String)("Found dataset <id=" + targetDsId + "> not an InvDatasetScan."), (boolean)(targetDs instanceof InvDatasetScan));
        InvDatasetScan scan = (InvDatasetScan)targetDs;
        URI reqURI = null;
        String reqUriString = baseURI + "/myGridData/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl cat1 = scan.makeCatalogForDirectory("myGridData/catalog.xml", reqURI);
        reqUriString = baseURI + "/myGridData/NCEP/GFS/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl cat2 = scan.makeCatalogForDirectory("myGridData/NCEP/GFS/catalog.xml", reqURI);
        reqUriString = baseURI + "/myGridData/NCEP/GFS/Alaska_191km/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl cat3 = scan.makeCatalogForDirectory("myGridData/NCEP/GFS/Alaska_191km/catalog.xml", reqURI);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat1, res1Name, this.debugShowCatalogs);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat2, res2Name, this.debugShowCatalogs);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat3, res3Name, this.debugShowCatalogs);
    }

    public void testDsScanRefactor() {
        String filePath = "test/data/thredds/catalog";
        String inFileName = "testInvDsScan.dsScanRefactor.input.xml";
        String res1Name = "/thredds/catalog/testInvDsScan.dsScanPreRefactor.result1.xml";
        String res2Name = "/thredds/catalog/testInvDsScan.dsScanPreRefactor.result2.xml";
        String res3Name = "/thredds/catalog/testInvDsScan.dsScanPreRefactor.result3.xml";
        File inFile = new File(filePath, inFileName);
        InvCatalogFactory fac = InvCatalogFactory.getDefaultFactory((boolean)false);
        InvCatalogImpl catalog = fac.readXML(inFile.toURI());
        TestInvDatasetScan.assertTrue((String)"Read resulted in null catalog.", (catalog != null ? 1 : 0) != 0);
        String baseURI = catalog.getBaseURI().toString();
        String expectedBaseURI = inFile.toURI().toString();
        TestInvDatasetScan.assertTrue((String)("Base URI <" + baseURI + "> not as expected <" + expectedBaseURI + ">."), (boolean)baseURI.equals(expectedBaseURI));
        String targetDsId = "myGridDataID";
        InvDataset targetDs = catalog.findDatasetByID(targetDsId);
        TestInvDatasetScan.assertTrue((String)("Did not find dataset <id=" + targetDsId + ">."), (targetDs != null ? 1 : 0) != 0);
        TestInvDatasetScan.assertTrue((String)("Found dataset <id=" + targetDsId + "> not an InvDatasetScan."), (boolean)(targetDs instanceof InvDatasetScan));
        InvDatasetScan scan = (InvDatasetScan)targetDs;
        URI reqURI = null;
        String reqUriString = baseURI + "/myGridData/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl cat1 = scan.makeCatalogForDirectory("myGridData/catalog.xml", reqURI);
        reqUriString = baseURI + "/myGridData/NCEP/GFS/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl cat2 = scan.makeCatalogForDirectory("myGridData/NCEP/GFS/catalog.xml", reqURI);
        reqUriString = baseURI + "/myGridData/NCEP/GFS/Alaska_191km/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl cat3 = scan.makeCatalogForDirectory("myGridData/NCEP/GFS/Alaska_191km/catalog.xml", reqURI);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat1, res1Name, this.debugShowCatalogs);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat2, res2Name, this.debugShowCatalogs);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat3, res3Name, this.debugShowCatalogs);
    }

    public void testDsScanRefactorWithNamer() {
        String filePath = "test/data/thredds/catalog";
        String inFileName = "testInvDsScan.dsScanRefactorWithNamer.input.xml";
        String res1Name = "/thredds/catalog/testInvDsScan.dsScanRefactorWithNamer.result1.xml";
        String res2Name = "/thredds/catalog/testInvDsScan.dsScanRefactorWithNamer.result2.xml";
        String res3Name = "/thredds/catalog/testInvDsScan.dsScanRefactorWithNamer.result3.xml";
        File inFile = new File(filePath, inFileName);
        InvCatalogFactory fac = InvCatalogFactory.getDefaultFactory((boolean)false);
        InvCatalogImpl catalog = fac.readXML(inFile.toURI());
        TestInvDatasetScan.assertTrue((String)"Read resulted in null catalog.", (catalog != null ? 1 : 0) != 0);
        String baseURI = catalog.getBaseURI().toString();
        String expectedBaseURI = inFile.toURI().toString();
        TestInvDatasetScan.assertTrue((String)("Base URI <" + baseURI + "> not as expected <" + expectedBaseURI + ">."), (boolean)baseURI.equals(expectedBaseURI));
        String targetDsId = "myGridDataID";
        InvDataset targetDs = catalog.findDatasetByID(targetDsId);
        TestInvDatasetScan.assertTrue((String)("Did not find dataset <id=" + targetDsId + ">."), (targetDs != null ? 1 : 0) != 0);
        TestInvDatasetScan.assertTrue((String)("Found dataset <id=" + targetDsId + "> not an InvDatasetScan."), (boolean)(targetDs instanceof InvDatasetScan));
        InvDatasetScan scan = (InvDatasetScan)targetDs;
        URI reqURI = null;
        String reqUriString = baseURI + "/myGridData/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl cat1 = scan.makeCatalogForDirectory("myGridData/catalog.xml", reqURI);
        reqUriString = baseURI + "/myGridData/NCEP/GFS/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl cat2 = scan.makeCatalogForDirectory("myGridData/NCEP/GFS/catalog.xml", reqURI);
        reqUriString = baseURI + "/myGridData/NCEP/GFS/Alaska_191km/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl cat3 = scan.makeCatalogForDirectory("myGridData/NCEP/GFS/Alaska_191km/catalog.xml", reqURI);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat1, res1Name, this.debugShowCatalogs);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat2, res2Name, this.debugShowCatalogs);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat3, res3Name, this.debugShowCatalogs);
    }

    public void testDsScanRefactorWithDirExclude() {
        String filePath = "test/data/thredds/catalog";
        String inFileName = "testInvDsScan.dsScanRefactorWithDirExclude.input.xml";
        String res1Name = "/thredds/catalog/testInvDsScan.dsScanPreRefactor.result1.xml";
        String res2Name = "/thredds/catalog/testInvDsScan.dsScanRefactorWithDirExclude.resultNCEP.xml";
        String res3Name = "/thredds/catalog/testInvDsScan.dsScanRefactorWithDirExclude.resultGFS.xml";
        File inFile = new File(filePath, inFileName);
        InvCatalogFactory fac = InvCatalogFactory.getDefaultFactory((boolean)false);
        InvCatalogImpl catalog = fac.readXML(inFile.toURI());
        TestInvDatasetScan.assertTrue((String)"Read resulted in null catalog.", (catalog != null ? 1 : 0) != 0);
        String baseURI = catalog.getBaseURI().toString();
        String expectedBaseURI = inFile.toURI().toString();
        TestInvDatasetScan.assertTrue((String)("Base URI <" + baseURI + "> not as expected <" + expectedBaseURI + ">."), (boolean)baseURI.equals(expectedBaseURI));
        String targetDsId = "myGridDataID";
        InvDataset targetDs = catalog.findDatasetByID(targetDsId);
        TestInvDatasetScan.assertTrue((String)("Did not find dataset <id=" + targetDsId + ">."), (targetDs != null ? 1 : 0) != 0);
        TestInvDatasetScan.assertTrue((String)("Found dataset <id=" + targetDsId + "> not an InvDatasetScan."), (boolean)(targetDs instanceof InvDatasetScan));
        InvDatasetScan scan = (InvDatasetScan)targetDs;
        URI reqURI = null;
        String reqUriString = baseURI + "/myGridData/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl cat1 = scan.makeCatalogForDirectory("myGridData/catalog.xml", reqURI);
        reqUriString = baseURI + "/myGridData/NCEP/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl cat2 = scan.makeCatalogForDirectory("myGridData/NCEP/catalog.xml", reqURI);
        reqUriString = baseURI + "/myGridData/NCEP/GFS/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl cat3 = scan.makeCatalogForDirectory("myGridData/NCEP/GFS/catalog.xml", reqURI);
        reqUriString = baseURI + "/myGridData/NCEP/NAM/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl cat4 = scan.makeCatalogForDirectory("myGridData/NCEP/NAM/catalog.xml", reqURI);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat1, res1Name, this.debugShowCatalogs);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat2, res2Name, this.debugShowCatalogs);
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat3, res3Name, this.debugShowCatalogs);
        TestInvDatasetScan.assertTrue((String)"Unexpected non-null NAM catalog, should be excluded by filter.", (cat4 == null ? 1 : 0) != 0);
    }

    public void testDsScanNonexistentLocation() {
        InvCatalogImpl configCat = null;
        configCat = new InvCatalogImpl("Test InvDatasetScan with non-existent scan location", "1.0.1", null);
        InvService myService = new InvService(this.serviceName, ServiceType.DODS.toString(), "", null, null);
        configCat.addService(myService);
        InvDatasetScan me = new InvDatasetScan(configCat, null, this.dsScanName, this.dsScanPath, this.dsScanDir + "nonExistentDir/", this.dsScanFilter, false, "false", false, null, null, null);
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(myService.getName());
        InvMetadata md = new InvMetadata((InvDataset)me, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, (Object)tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        me.setLocalMetadata(tm2);
        configCat.addDataset((InvDatasetImpl)me);
        configCat.finish();
        URI reqURI = null;
        String reqUriString = this.baseURL + "/" + this.dsScanPath + "/catalog.xml";
        try {
            reqURI = new URI(reqUriString);
        }
        catch (URISyntaxException e) {
            TestInvDatasetScan.assertTrue((String)("Bad URI syntax <" + reqUriString + ">: " + e.getMessage()), (boolean)false);
        }
        InvCatalogImpl catalog = me.makeCatalogForDirectory(this.dsScanPath + "/catalog.xml", reqURI);
    }
}

