/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Locatable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.exception.WWTimeoutException;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.ogc.kml.KMLAbstractContainer;
import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLAbstractGeometry;
import gov.nasa.worldwind.ogc.kml.KMLBalloonStyle;
import gov.nasa.worldwind.ogc.kml.KMLGroundOverlay;
import gov.nasa.worldwind.ogc.kml.KMLPlacemark;
import gov.nasa.worldwind.ogc.kml.KMLRoot;
import gov.nasa.worldwind.ogc.kml.KMLScreenOverlay;
import gov.nasa.worldwind.ogc.kml.KMLVec2;
import gov.nasa.worldwind.ogc.kml.impl.KMLAbstractBalloon;
import gov.nasa.worldwind.ogc.kml.impl.KMLController;
import gov.nasa.worldwind.ogc.kml.impl.KMLGlobeBalloonImpl;
import gov.nasa.worldwind.ogc.kml.impl.KMLScreenBalloonImpl;
import gov.nasa.worldwind.ogc.kml.impl.KMLUtil;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.AbstractBalloon;
import gov.nasa.worldwind.render.AbstractBrowserBalloon;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.Balloon;
import gov.nasa.worldwind.render.BalloonAttributes;
import gov.nasa.worldwind.render.BasicBalloonAttributes;
import gov.nasa.worldwind.render.GlobeAnnotationBalloon;
import gov.nasa.worldwind.render.GlobeBalloon;
import gov.nasa.worldwind.render.GlobeBrowserBalloon;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.ScreenAnnotationBalloon;
import gov.nasa.worldwind.render.ScreenBalloon;
import gov.nasa.worldwind.render.ScreenBrowserBalloon;
import gov.nasa.worldwind.render.Size;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.BrowserOpener;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.examples.kml.KMLViewController;
import gov.nasa.worldwindx.examples.util.BalloonResizeController;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class BalloonController
extends MouseAdapter
implements SelectListener {
    public static final int DEFAULT_BALLOON_OFFSET = 60;
    public static final String FLY_TO = "flyto";
    public static final String BALLOON = "balloon";
    public static final String BALLOON_FLY_TO = "balloonFlyto";
    protected WorldWindow wwd;
    protected Object lastSelectedObject;
    protected Balloon balloon;
    protected int balloonOffset = 60;
    protected long retrievalTimeout = 30000L;
    protected long retrievalPollInterval = 1000L;
    protected BalloonResizeController resizeController;

    public BalloonController(WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.wwd.addSelectListener(this);
        this.wwd.getInputHandler().addMouseListener(this);
        this.wwd.getInputHandler().addMouseMotionListener(this);
    }

    public int getBalloonOffset() {
        return this.balloonOffset;
    }

    public void setBalloonOffset(int n) {
        this.balloonOffset = n;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent == null || mouseEvent.isConsumed()) {
            return;
        }
        try {
            if (this.isBalloonTrigger(mouseEvent)) {
                Balloon balloon;
                boolean bl;
                PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
                if (pickedObjectList == null || pickedObjectList.getTopPickedObject() == null) {
                    this.hideBalloon();
                    return;
                }
                Object object = pickedObjectList.getTopObject();
                PickedObject pickedObject = pickedObjectList.getTopPickedObject();
                boolean bl2 = this.lastSelectedObject == object || this.balloon == object;
                boolean bl3 = bl = this.balloon != null && this.balloon.isVisible();
                if (bl2 && bl) {
                    return;
                }
                if (this.balloon != null && !(object instanceof Balloon)) {
                    this.hideBalloon();
                }
                if ((balloon = this.getBalloon(pickedObject)) != null && !balloon.isVisible()) {
                    this.lastSelectedObject = object;
                    this.showBalloon(balloon, object, mouseEvent.getPoint());
                }
            }
        }
        catch (Exception exception) {
            Logging.logger().warning(exception.getMessage() != null ? exception.getMessage() : exception.toString());
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        PickedObject pickedObject;
        if (mouseEvent == null || mouseEvent.isConsumed()) {
            return;
        }
        PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
        PickedObject pickedObject2 = pickedObject = pickedObjectList != null ? pickedObjectList.getTopPickedObject() : null;
        if (pickedObject != null && this.isResizeControl(pickedObject)) {
            this.createResizeController((Balloon)pickedObject.getObject());
        } else if (this.resizeController != null && !this.resizeController.isResizing()) {
            this.destroyResizeController(null);
        }
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (selectEvent == null || selectEvent.isConsumed() || selectEvent.getMouseEvent() != null && selectEvent.getMouseEvent().isConsumed()) {
            return;
        }
        try {
            Object object;
            PickedObject pickedObject = selectEvent.getTopPickedObject();
            if (pickedObject == null) {
                return;
            }
            Object object2 = selectEvent.getTopObject();
            if (selectEvent.isDragEnd() && this.resizeController != null && !this.resizeController.isResizing()) {
                PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
                Object object3 = object = pickedObjectList != null ? pickedObjectList.getTopPickedObject() : null;
                if (!this.isResizeControl((PickedObject)object)) {
                    this.destroyResizeController(selectEvent);
                }
            }
            if (selectEvent.isLeftClick()) {
                object = this.getUrl(pickedObject);
                if (object != null) {
                    this.onLinkActivated(selectEvent, (String)object);
                } else if (pickedObject.hasKey("gov.nasa.worldwind.avkey.Action") && object2 instanceof AbstractBrowserBalloon) {
                    this.onBalloonAction((AbstractBrowserBalloon)object2, pickedObject.getStringValue("gov.nasa.worldwind.avkey.Action"));
                }
            } else if (selectEvent.isLeftDoubleClick() && (object = this.getUrl(pickedObject)) != null) {
                this.onLinkActivated(selectEvent, (String)object);
            }
        }
        catch (Exception exception) {
            Logging.logger().warning(exception.getMessage() != null ? exception.getMessage() : exception.toString());
        }
    }

    protected boolean isResizeControl(PickedObject pickedObject) {
        return pickedObject != null && "gov.nasa.worldwind.avkey.Resize".equals(pickedObject.getStringValue("gov.nasa.worldwind.avkey.Action")) && pickedObject.getObject() instanceof Balloon;
    }

    protected String getUrl(PickedObject pickedObject) {
        return pickedObject.getStringValue("gov.nasa.worldwind.avkey.URL");
    }

    protected KMLAbstractFeature getContext(PickedObject pickedObject) {
        Object object = pickedObject.getObject();
        Object object2 = pickedObject.getValue("gov.nasa.worldwind.avkey.Context");
        if (object2 == null && object instanceof AVList) {
            object2 = ((AVList)object).getValue("gov.nasa.worldwind.avkey.Context");
        }
        if (object2 instanceof KMLAbstractFeature) {
            return (KMLAbstractFeature)object2;
        }
        return null;
    }

    protected void onBalloonAction(AbstractBrowserBalloon abstractBrowserBalloon, String string) {
        if ("gov.nasa.worldwind.avkey.Close".equals(string)) {
            if (abstractBrowserBalloon == this.balloon) {
                this.hideBalloon();
            } else {
                abstractBrowserBalloon.setVisible(false);
            }
        } else if ("gov.nasa.worldwind.avkey.Back".equals(string)) {
            abstractBrowserBalloon.goBack();
        } else if ("gov.nasa.worldwind.avkey.Forward".equals(string)) {
            abstractBrowserBalloon.goForward();
        }
    }

    protected void createResizeController(Balloon balloon) {
        if (this.resizeController != null) {
            return;
        }
        this.resizeController = new BalloonResizeController(this.wwd, balloon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyResizeController(SelectEvent selectEvent) {
        if (this.resizeController != null) {
            try {
                if (selectEvent != null) {
                    this.resizeController.selected(selectEvent);
                }
                this.resizeController.detach();
                this.resizeController = null;
            }
            finally {
                if (this.wwd instanceof Component) {
                    ((Component)((Object)this.wwd)).setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    protected void onLinkActivated(SelectEvent selectEvent, String string) {
        String string2;
        KMLRoot kMLRoot;
        String string3;
        String string4;
        PickedObject pickedObject = selectEvent.getTopPickedObject();
        String string5 = pickedObject.getStringValue("gov.nasa.worldwind.avkey.MimeType");
        int n = string.indexOf("#");
        if (n != -1) {
            string4 = string.substring(0, n);
            string3 = string.substring(n);
        } else {
            string4 = string;
            string3 = null;
        }
        KMLRoot kMLRoot2 = null;
        boolean bl = this.isKmlUrl(string4, string5);
        boolean bl2 = false;
        KMLAbstractFeature kMLAbstractFeature = this.getContext(pickedObject);
        if (kMLAbstractFeature != null) {
            kMLRoot2 = kMLAbstractFeature.getRoot();
        }
        if (bl) {
            kMLRoot = this.findOpenKmlDocument(string4);
            if (kMLRoot == null) {
                if (this.isLinkActivationTrigger(selectEvent)) {
                    this.requestDocument(string4, kMLRoot2, string3);
                }
                selectEvent.consume();
                return;
            }
        } else {
            kMLRoot = kMLRoot2;
        }
        if (string3 != null && this.onFeatureLinkActivated(kMLRoot, string3, selectEvent)) {
            bl2 = true;
            selectEvent.consume();
        }
        if (!bl && !bl2 && "_blank".equalsIgnoreCase(string2 = pickedObject.getStringValue("gov.nasa.worldwind.avkey.Target"))) {
            if (this.isLinkActivationTrigger(selectEvent)) {
                this.openInNewBrowser(selectEvent, string);
            }
            selectEvent.consume();
        }
    }

    protected boolean isLinkActivationTrigger(SelectEvent selectEvent) {
        return selectEvent.isLeftClick();
    }

    protected void openInNewBrowser(SelectEvent selectEvent, String string) {
        try {
            BrowserOpener.browse(new URL(string));
            selectEvent.consume();
        }
        catch (Exception exception) {
            String string2 = Logging.getMessage("generic.ExceptionAttemptingToInvokeWebBrower", string);
            Logging.logger().warning(string2);
        }
    }

    protected boolean onFeatureLinkActivated(KMLRoot kMLRoot, String string, SelectEvent selectEvent) {
        Object object;
        String string2;
        String[] stringArray = string.split(";");
        String string3 = stringArray[0];
        String string4 = string2 = stringArray.length > 1 ? stringArray[1] : FLY_TO;
        if (!WWUtil.isEmpty(string3) && kMLRoot != null && (object = kMLRoot.resolveReference(string3)) instanceof KMLAbstractFeature) {
            if (selectEvent == null || this.isLinkActivationTrigger(selectEvent)) {
                this.doFeatureLinkActivated((KMLAbstractFeature)object, string2);
            }
            return true;
        }
        return false;
    }

    protected void doFeatureLinkActivated(KMLAbstractFeature kMLAbstractFeature, String string) {
        if (FLY_TO.equals(string) || BALLOON_FLY_TO.equals(string)) {
            this.moveToFeature(kMLAbstractFeature);
        }
        if (BALLOON.equals(string) || BALLOON_FLY_TO.equals(string)) {
            this.showBalloon(kMLAbstractFeature);
        }
    }

    protected boolean isKmlUrl(String string, String string2) {
        if (WWUtil.isEmpty(string)) {
            return false;
        }
        String string3 = WWIO.getSuffix(string);
        return "kml".equalsIgnoreCase(string3) || "kmz".equalsIgnoreCase(string3) || "application/vnd.google-earth.kml+xml".equals(string2) || "application/vnd.google-earth.kmz".equals(string2);
    }

    protected void moveToFeature(KMLAbstractFeature kMLAbstractFeature) {
        KMLViewController kMLViewController = KMLViewController.create(this.wwd);
        kMLViewController.goTo(kMLAbstractFeature);
    }

    public void showBalloon(KMLAbstractFeature kMLAbstractFeature) {
        Balloon balloon = kMLAbstractFeature.getBalloon();
        if (balloon == null && this.canShowBalloon(kMLAbstractFeature)) {
            balloon = this.createBalloon(kMLAbstractFeature);
        }
        if (balloon != null && !balloon.isVisible()) {
            this.lastSelectedObject = kMLAbstractFeature;
            Position position = this.getBalloonPosition(kMLAbstractFeature);
            if (position != null) {
                this.hideBalloon();
                this.showBalloon(balloon, position);
            } else {
                Point point = this.getBalloonPoint(kMLAbstractFeature);
                if (point != null) {
                    this.hideBalloon();
                    this.showBalloon(balloon, null, point);
                } else {
                    Rectangle rectangle = this.wwd.getView().getViewport();
                    Point point2 = new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY());
                    this.hideBalloon();
                    this.showBalloon(balloon, null, point2);
                }
            }
        }
    }

    public boolean canShowBalloon(KMLAbstractFeature kMLAbstractFeature) {
        KMLBalloonStyle kMLBalloonStyle = (KMLBalloonStyle)kMLAbstractFeature.getSubStyle(new KMLBalloonStyle(null), "normal");
        boolean bl = "hide".equals(kMLBalloonStyle.getDisplayMode());
        boolean bl2 = kMLBalloonStyle.hasStyleFields() && !kMLBalloonStyle.hasField("gov.nasa.worldwind.avkey.Unresolved");
        return (bl2 || !WWUtil.isEmpty(kMLAbstractFeature.getDescription()) || kMLAbstractFeature.getExtendedData() != null) && !bl;
    }

    protected boolean isBalloonTrigger(MouseEvent mouseEvent) {
        return mouseEvent.getButton() == 1 && mouseEvent.getClickCount() % 2 == 1;
    }

    protected Balloon getBalloon(PickedObject pickedObject) {
        KMLAbstractFeature kMLAbstractFeature;
        Object object;
        Object object2 = pickedObject.getObject();
        Object object3 = null;
        if (pickedObject.hasKey("gov.nasa.worldwind.avkey.Context") && (object = pickedObject.getValue("gov.nasa.worldwind.avkey.Context")) instanceof KMLAbstractFeature && (object3 = (kMLAbstractFeature = (KMLAbstractFeature)object).getBalloon()) == null && this.canShowBalloon(kMLAbstractFeature)) {
            object3 = this.createBalloon(kMLAbstractFeature);
        }
        if (object3 == null && object2 instanceof AVList) {
            object = (AVList)object2;
            object3 = object.getValue("gov.nasa.worldwind.avkey.Balloon");
        }
        if (object3 instanceof Balloon) {
            return (Balloon)object3;
        }
        return null;
    }

    protected Balloon createBalloon(KMLAbstractFeature kMLAbstractFeature) {
        KMLAbstractBalloon kMLAbstractBalloon;
        KMLBalloonStyle kMLBalloonStyle = (KMLBalloonStyle)kMLAbstractFeature.getSubStyle(new KMLBalloonStyle(null), "normal");
        String string = kMLBalloonStyle.getText();
        if (string == null) {
            string = "";
        }
        if ("gov.nasa.worldwind.avkey.GlobeObject".equals(this.getAttachmentMode(kMLAbstractFeature))) {
            AbstractBalloon abstractBalloon = this.isUseBrowserBalloon() ? new GlobeBrowserBalloon(string, Position.ZERO) : new GlobeAnnotationBalloon(string, Position.ZERO);
            kMLAbstractBalloon = new KMLGlobeBalloonImpl((GlobeBalloon)((Object)abstractBalloon), kMLAbstractFeature);
        } else {
            AbstractBalloon abstractBalloon = this.isUseBrowserBalloon() ? new ScreenBrowserBalloon(string, new Point(0, 0)) : new ScreenAnnotationBalloon(string, new Point(0, 0));
            kMLAbstractBalloon = new KMLScreenBalloonImpl((ScreenBalloon)((Object)abstractBalloon), kMLAbstractFeature);
        }
        kMLAbstractBalloon.setVisible(false);
        kMLAbstractBalloon.setAlwaysOnTop(true);
        kMLAbstractFeature.setBalloon(kMLAbstractBalloon);
        this.configureBalloon(kMLAbstractBalloon, kMLAbstractFeature);
        return kMLAbstractBalloon;
    }

    protected void configureBalloon(Balloon balloon, KMLAbstractFeature kMLAbstractFeature) {
        if (kMLAbstractFeature instanceof KMLAbstractContainer) {
            BasicBalloonAttributes basicBalloonAttributes = new BasicBalloonAttributes();
            Size size = new Size("gov.nasa.worldwind.render.Size.NativeDimension", 0.0, null, "gov.nasa.worldwind.render.Size.NativeDimension", 0.0, null);
            Size size2 = new Size("gov.nasa.worldwind.render.Size.ExplicitDimension", 0.8, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.render.Size.ExplicitDimension", 0.8, "gov.nasa.worldwind.avkey.Fraction");
            basicBalloonAttributes.setSize(size);
            basicBalloonAttributes.setMaximumSize(size2);
            basicBalloonAttributes.setOffset(new Offset(0.5, 0.5, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction"));
            basicBalloonAttributes.setLeaderShape("gov.nasa.worldwind.avkey.ShapeNone");
            balloon.setAttributes(basicBalloonAttributes);
        } else {
            BasicBalloonAttributes basicBalloonAttributes = new BasicBalloonAttributes();
            Size size = new Size("gov.nasa.worldwind.render.Size.NativeDimension", 0.0, null, "gov.nasa.worldwind.render.Size.NativeDimension", 0.0, null);
            Size size3 = new Size("gov.nasa.worldwind.render.Size.ExplicitDimension", 0.5, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.render.Size.ExplicitDimension", 0.4, "gov.nasa.worldwind.avkey.Fraction");
            basicBalloonAttributes.setSize(size);
            basicBalloonAttributes.setMaximumSize(size3);
            balloon.setAttributes(basicBalloonAttributes);
        }
    }

    protected String getAttachmentMode(KMLAbstractFeature kMLAbstractFeature) {
        if (kMLAbstractFeature instanceof KMLPlacemark || kMLAbstractFeature instanceof KMLGroundOverlay) {
            return "gov.nasa.worldwind.avkey.GlobeObject";
        }
        return "gov.nasa.worldwind.avkey.ScreenObject";
    }

    protected boolean isUseBrowserBalloon() {
        return Configuration.isWindowsOS() || Configuration.isMacOS();
    }

    protected void showBalloon(Balloon balloon, Object object, Point point) {
        Position position;
        if (balloon instanceof ScreenBalloon) {
            ((ScreenBalloon)balloon).setScreenLocation(point);
        } else if (balloon instanceof GlobeBalloon && (position = this.getBalloonPosition(object, point)) != null) {
            GlobeBalloon globeBalloon = (GlobeBalloon)balloon;
            globeBalloon.setPosition(position);
            globeBalloon.setAltitudeMode(this.getBalloonAltitudeMode(object));
        }
        if (this.mustAdjustPosition(balloon)) {
            this.adjustPosition(balloon, point);
        }
        this.balloon = balloon;
        this.balloon.setVisible(true);
    }

    protected void showBalloon(Balloon balloon, Position position) {
        Vec4 vec4 = this.wwd.getView().project(this.wwd.getModel().getGlobe().computePointFromPosition(position));
        Point point = new Point((int)vec4.x, (int)((double)this.wwd.getView().getViewport().height - vec4.y));
        if (balloon instanceof ScreenBalloon) {
            ((ScreenBalloon)balloon).setScreenLocation(point);
        } else {
            ((GlobeBalloon)balloon).setPosition(position);
        }
        if (this.mustAdjustPosition(balloon)) {
            this.adjustPosition(balloon, point);
        }
        this.balloon = balloon;
        this.balloon.setVisible(true);
    }

    protected boolean mustAdjustPosition(Balloon balloon) {
        BalloonAttributes balloonAttributes = balloon.getAttributes();
        return !"gov.nasa.worldwind.avkey.ShapeNone".equals(balloonAttributes.getLeaderShape());
    }

    protected void adjustPosition(Balloon balloon, Point point) {
        Rectangle rectangle = this.wwd.getView().getViewport();
        String string = "gov.nasa.worldwind.avkey.Fraction";
        double d = (double)point.x > (double)rectangle.width * 0.75 ? 1.0 : ((double)point.x < (double)rectangle.width * 0.25 ? 0.0 : 0.5);
        int n = this.getBalloonOffset();
        double d2 = -n;
        String string2 = (double)point.y < (double)rectangle.height * 0.5 ? "gov.nasa.worldwind.avkey.InsetPixels" : "gov.nasa.worldwind.avkey.Pixels";
        Offset offset = new Offset(d, d2, string, string2);
        BalloonAttributes balloonAttributes = balloon.getAttributes();
        if (balloonAttributes == null) {
            balloonAttributes = new BasicBalloonAttributes();
            balloon.setAttributes(balloonAttributes);
        }
        balloonAttributes.setOffset(offset);
        BalloonAttributes balloonAttributes2 = balloon.getHighlightAttributes();
        if (balloonAttributes2 != null) {
            balloonAttributes2.setOffset(offset);
        }
    }

    protected void hideBalloon() {
        if (this.balloon != null) {
            this.balloon.setVisible(false);
            this.balloon = null;
        }
        this.lastSelectedObject = null;
    }

    protected Position getBalloonPosition(KMLAbstractFeature kMLAbstractFeature) {
        if (kMLAbstractFeature instanceof KMLPlacemark) {
            return this.getBalloonPositionForPlacemark((KMLPlacemark)kMLAbstractFeature);
        }
        if (kMLAbstractFeature instanceof KMLGroundOverlay) {
            return this.getBalloonPositionForGroundOverlay((KMLGroundOverlay)kMLAbstractFeature);
        }
        return null;
    }

    protected Position getBalloonPosition(Object object, Point point) {
        Position position = null;
        if (object instanceof Locatable) {
            position = ((Locatable)object).getPosition();
        } else if (object instanceof AbstractShape) {
            position = this.computeIntersection((AbstractShape)object, point);
        }
        if (position == null) {
            Line line = this.wwd.getView().computeRayFromScreenPoint(point.x, point.y);
            Intersection[] intersectionArray = this.wwd.getSceneController().getDrawContext().getSurfaceGeometry().intersect(line);
            if (intersectionArray != null && intersectionArray.length > 0) {
                position = this.wwd.getModel().getGlobe().computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
            }
            if (position == null) {
                position = this.wwd.getView().computePositionFromScreenPoint(point.x, point.y);
            }
        }
        return position;
    }

    protected int getBalloonAltitudeMode(Object object) {
        if (object instanceof PointPlacemark) {
            return ((PointPlacemark)object).getAltitudeMode();
        }
        return 0;
    }

    protected Position computeIntersection(AbstractShape abstractShape, Point point) {
        try {
            Terrain terrain = this.wwd.getSceneController().getDrawContext().getTerrain();
            Line line = this.wwd.getView().computeRayFromScreenPoint(point.x, point.y);
            List<Intersection> list = abstractShape.intersect(line, terrain);
            if (list != null && !list.isEmpty()) {
                return list.get(0).getIntersectionPosition();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected Position getBalloonPositionForPlacemark(KMLPlacemark kMLPlacemark) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        KMLAbstractGeometry kMLAbstractGeometry = kMLPlacemark.getGeometry();
        KMLUtil.getPositions(this.wwd.getModel().getGlobe(), kMLAbstractGeometry, arrayList);
        return this.getBalloonPosition(arrayList);
    }

    protected Position getBalloonPositionForGroundOverlay(KMLGroundOverlay kMLGroundOverlay) {
        Position.PositionList positionList = kMLGroundOverlay.getPositions();
        return this.getBalloonPosition(positionList.list);
    }

    protected Position getBalloonPosition(List<? extends Position> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() > 1) {
            Sector sector = Sector.boundingSector(list);
            return new Position(sector.getCentroid(), this.findMaxAltitude(list));
        }
        return null;
    }

    protected Point getBalloonPoint(KMLAbstractFeature kMLAbstractFeature) {
        if (kMLAbstractFeature instanceof KMLScreenOverlay) {
            return this.getBalloonPointForScreenOverlay((KMLScreenOverlay)kMLAbstractFeature);
        }
        return null;
    }

    protected Point getBalloonPointForScreenOverlay(KMLScreenOverlay kMLScreenOverlay) {
        KMLVec2 kMLVec2 = kMLScreenOverlay.getScreenXY();
        Offset offset = new Offset(kMLVec2.getX(), kMLVec2.getY(), KMLUtil.kmlUnitsToWWUnits(kMLVec2.getXunits()), KMLUtil.kmlUnitsToWWUnits(kMLVec2.getYunits()));
        Rectangle rectangle = this.wwd.getView().getViewport();
        Point2D.Double double_ = offset.computeOffset(rectangle.width, rectangle.height, 1.0, 1.0);
        int n = (int)((Point2D)double_).getY();
        return new Point((int)((Point2D)double_).getX(), rectangle.height - n);
    }

    protected double findMaxAltitude(List<? extends Position> list) {
        double d = -1.7976931348623157E308;
        for (Position position : list) {
            double d2 = position.getAltitude();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    protected KMLRoot findOpenKmlDocument(String string) {
        Object object = WorldWind.getSessionCache().get(string);
        if (object instanceof KMLRoot) {
            return (KMLRoot)object;
        }
        return null;
    }

    protected void requestDocument(String string, KMLRoot kMLRoot, String string2) {
        Timer timer = new Timer("BalloonController document retrieval");
        timer.scheduleAtFixedRate((TimerTask)new DocumentRetrievalTask(string, kMLRoot, string2, this.retrievalTimeout), 0L, this.retrievalPollInterval);
    }

    protected void onDocumentLoaded(String string, KMLRoot kMLRoot, String string2) {
        kMLRoot.setField("gov.nasa.worldwind.avkey.DisplayName", (Object)string);
        this.addDocumentLayer(kMLRoot);
        if (string2 != null) {
            this.onFeatureLinkActivated(kMLRoot, string2, null);
        }
    }

    protected void onDocumentFailed(String string, Exception exception) {
        String string2 = Logging.getMessage("generic.ExceptionWhileReading", string + ": " + exception.getMessage());
        Logging.logger().warning(string2);
    }

    protected void addDocumentLayer(KMLRoot kMLRoot) {
        KMLController kMLController = new KMLController(kMLRoot);
        RenderableLayer renderableLayer = new RenderableLayer();
        renderableLayer.setName((String)kMLRoot.getField("gov.nasa.worldwind.avkey.DisplayName"));
        renderableLayer.addRenderable(kMLController);
        this.wwd.getModel().getLayers().add(renderableLayer);
    }

    protected class DocumentRetrievalTask
    extends TimerTask {
        protected String docUrl;
        protected KMLRoot context;
        protected String featureRef;
        protected long timeout;
        protected long start;

        public DocumentRetrievalTask(String string, KMLRoot kMLRoot, String string2, long l) {
            this.docUrl = string;
            this.context = kMLRoot;
            this.featureRef = string2;
            this.timeout = l;
        }

        @Override
        public void run() {
            KMLRoot kMLRoot = null;
            try {
                if (this.start == 0L) {
                    this.start = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() > this.start + this.timeout) {
                    throw new WWTimeoutException(Logging.getMessage("generic.CannotOpenFile", this.docUrl));
                }
                Object object = this.context != null ? this.context.resolveReference(this.docUrl) : WorldWind.getDataFileStore().requestFile(this.docUrl);
                if (object instanceof KMLRoot) {
                    kMLRoot = (KMLRoot)object;
                } else if (object != null) {
                    kMLRoot = KMLRoot.create(object);
                    kMLRoot.parse(new Object[0]);
                }
                if (kMLRoot != null) {
                    final KMLRoot kMLRoot2 = kMLRoot;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BalloonController.this.onDocumentLoaded(DocumentRetrievalTask.this.docUrl, kMLRoot2, DocumentRetrievalTask.this.featureRef);
                        }
                    });
                    this.cancel();
                }
            }
            catch (Exception exception) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BalloonController.this.onDocumentFailed(DocumentRetrievalTask.this.docUrl, exception);
                    }
                });
                this.cancel();
            }
        }
    }
}

