/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.kml;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.Polygon;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.examples.kml.KMLDocumentBuilder;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ExportKML {
    protected static ShapeAttributes normalShapeAttributes;
    protected static ShapeAttributes highlightShapeAttributes;

    protected static PointPlacemark makePointPlacemark() {
        PointPlacemark pointPlacemark = new PointPlacemark(Position.fromDegrees(37.824713, -122.370028, 0.0));
        pointPlacemark.setLabelText("Treasure Island");
        pointPlacemark.setValue("gov.nasa.worldwind.avkey.Server.ShortDescription", "Sample placemark");
        pointPlacemark.setValue("gov.nasa.worldwind.avkey.BalloonText", "This is a <b>Point Placemark</b>");
        pointPlacemark.setLineEnabled(false);
        pointPlacemark.setAltitudeMode(1);
        return pointPlacemark;
    }

    protected static Path makePath() {
        Path path = new Path();
        List<Position> list = Arrays.asList(Position.fromDegrees(37.8304, -122.372, 0.0), Position.fromDegrees(37.8293, -122.3679, 50.0), Position.fromDegrees(37.8282, -122.371, 100.0));
        path.setPositions(list);
        path.setExtrude(true);
        path.setAttributes(normalShapeAttributes);
        path.setHighlightAttributes(highlightShapeAttributes);
        path.setValue("gov.nasa.worldwind.avkey.Server.ShortDescription", "Short description of Path");
        path.setValue("gov.nasa.worldwind.avkey.BalloonText", "This is a Path.");
        return path;
    }

    protected static Polygon makePolygon() {
        Polygon polygon = new Polygon();
        List<Position> list = Arrays.asList(Position.fromDegrees(37.8224479345424, -122.3739784354151, 50.0), Position.fromDegrees(37.82239261906633, -122.3740285701554, 50.0), Position.fromDegrees(37.82240608112512, -122.3744696934806, 50.0), Position.fromDegrees(37.82228167878964, -122.3744693163394, 50.0), Position.fromDegrees(37.82226619249474, -122.3739902862858, 50.0), Position.fromDegrees(37.82219810227204, -122.3739510452131, 50.0), Position.fromDegrees(37.82191990027978, -122.3742004406226, 50.0), Position.fromDegrees(37.82186185177756, -122.3740740264531, 50.0), Position.fromDegrees(37.82213350487949, -122.3738377669854, 50.0), Position.fromDegrees(37.82213842777661, -122.3737599855226, 50.0), Position.fromDegrees(37.82184815805735, -122.3735538230499, 50.0), Position.fromDegrees(37.82188747252212, -122.3734202823307, 50.0), Position.fromDegrees(37.82220302338508, -122.37362176179, 50.0), Position.fromDegrees(37.8222686063349, -122.3735762207482, 50.0), Position.fromDegrees(37.82224254303025, -122.3731468984375, 50.0), Position.fromDegrees(37.82237319467147, -122.3731303943743, 50.0), Position.fromDegrees(37.82238194814573, -122.3735637823936, 50.0), Position.fromDegrees(37.82244505243797, -122.3736008458059, 50.0), Position.fromDegrees(37.82274355652806, -122.3734009024945, 50.0), Position.fromDegrees(37.82280084508153, -122.3735091430554, 50.0), Position.fromDegrees(37.82251198652374, -122.3737489159765, 50.0), Position.fromDegrees(37.82251207172572, -122.3738269699774, 50.0), Position.fromDegrees(37.82280161524027, -122.3740332968739, 50.0), Position.fromDegrees(37.82275318071796, -122.3741825267907, 50.0), Position.fromDegrees(37.8224479345424, -122.3739784354151, 50.0));
        List<Position> list2 = Arrays.asList(Position.fromDegrees(37.82237624346899, -122.3739179072036, 50.0), Position.fromDegrees(37.82226147323489, -122.3739053159649, 50.0), Position.fromDegrees(37.82221834573171, -122.3737889140025, 50.0), Position.fromDegrees(37.82226275093125, -122.3736772434448, 50.0), Position.fromDegrees(37.82237889526623, -122.3736727730745, 50.0), Position.fromDegrees(37.82243486851886, -122.3737811526564, 50.0), Position.fromDegrees(37.82237624346899, -122.3739179072036, 50.0));
        polygon.setOuterBoundary(list);
        polygon.addInnerBoundary(list2);
        polygon.setAltitudeMode(2);
        polygon.setAttributes(normalShapeAttributes);
        polygon.setHighlightAttributes(highlightShapeAttributes);
        polygon.setValue("gov.nasa.worldwind.avkey.Server.ShortDescription", "Short description of Polygon");
        polygon.setValue("gov.nasa.worldwind.avkey.BalloonText", "This is a Polygon.");
        return polygon;
    }

    protected static SurfaceQuad makeSurfaceQuad() {
        return new SurfaceQuad(LatLon.fromDegrees(45.0, 100.0), 10000.0, 20000.0, Angle.ZERO);
    }

    public static void main(String[] stringArray) {
        try {
            normalShapeAttributes = new BasicShapeAttributes();
            normalShapeAttributes.setInteriorMaterial(Material.BLUE);
            normalShapeAttributes.setOutlineMaterial(Material.BLACK);
            highlightShapeAttributes = new BasicShapeAttributes();
            highlightShapeAttributes.setInteriorMaterial(Material.RED);
            highlightShapeAttributes.setOutlineMaterial(Material.BLACK);
            StringWriter stringWriter = new StringWriter();
            KMLDocumentBuilder kMLDocumentBuilder = new KMLDocumentBuilder(stringWriter);
            kMLDocumentBuilder.writeObjects(ExportKML.makeSurfaceQuad(), ExportKML.makePointPlacemark(), ExportKML.makePath(), ExportKML.makePolygon());
            kMLDocumentBuilder.close();
            String string = ((Object)stringWriter).toString();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new StreamSource(new StringReader(string)), new StreamResult(System.out));
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToWriteXml", exception.toString());
            Logging.logger().severe(string);
            exception.printStackTrace();
        }
    }
}

