/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.util.measuretool;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.render.SurfaceEllipse;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.SurfaceSquare;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.UnitsFormat;
import gov.nasa.worldwindx.applications.worldwindow.util.measuretool.WWOMeasureDisplay;
import gov.nasa.worldwindx.applications.worldwindow.util.measuretool.WWOMeasureToolControlPoints;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;

public class WWOMeasureTool
extends AVListImpl
implements Disposable,
MouseListener,
MouseMotionListener,
SelectListener,
PositionListener,
RenderingListener {
    public static final String EVENT_POSITION_ADD = "MeasureTool.AddPosition";
    public static final String EVENT_POSITION_REMOVE = "MeasureTool.RemovePosition";
    public static final String EVENT_POSITION_REPLACE = "MeasureTool.ReplacePosition";
    public static final String EVENT_METRIC_CHANGED = "MeasureTool.MetricChanged";
    public static final String EVENT_ARMED = "MeasureTool.Armed";
    public static final String EVENT_RUBBERBAND_START = "MeasureTool.RubberBandStart";
    public static final String EVENT_RUBBERBAND_STOP = "MeasureTool.RubberBandStop";
    protected final WorldWindow wwd;
    protected BasicDragger dragger;
    protected Renderable shape;
    protected String measureShapeType;
    protected boolean regularShape;
    protected ControlPointList controlPoints;
    protected RenderableLayer controlPointsLayer;
    protected boolean showControlPoints = true;
    protected MeasureDisplay measureDisplay;
    protected boolean showAnnotation = true;
    protected UnitsFormat unitsFormat = new UnitsFormat();
    protected ArrayList<Position> positions = new ArrayList();
    protected Rectangle2D.Double shapeRectangle = null;
    protected Position shapeCenterPosition = null;
    protected Angle shapeOrientation = null;
    protected int shapeIntervals = 64;
    protected boolean armed = false;
    protected boolean active = false;
    protected boolean moving = false;
    protected boolean useRubberBand = true;
    protected boolean freeHand = false;
    protected double freeHandMinSpacing = 100.0;
    protected ControlPoint rubberBandTarget;
    protected ControlPoint movingTarget;
    protected ControlPoint lastPickedObject;
    protected EventListenerList eventListeners = new EventListenerList();

    public WWOMeasureTool(WorldWindow worldWindow, Renderable renderable, String string, RenderableLayer renderableLayer) {
        if (worldWindow == null) {
            String string2 = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (renderable == null) {
            String string3 = Logging.getMessage("nullValue.Shape");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.wwd = worldWindow;
        this.controlPoints = this.createControlPoints();
        this.controlPointsLayer = renderableLayer;
        this.controlPoints.addToLayer(this.controlPointsLayer);
        this.measureDisplay = this.createMeasureDisplay();
        this.measureDisplay.addToLayer(this.controlPointsLayer);
        this.getWwd().getInputHandler().addMouseListener(this);
        this.getWwd().getInputHandler().addMouseMotionListener(this);
        this.getWwd().addPositionListener(this);
        this.getWwd().addSelectListener(this);
        this.getWwd().addRenderingListener(this);
        this.shape = renderable;
        if (this.shape instanceof Polyline) {
            this.setMeasureShape((Polyline)this.shape, string);
        } else {
            this.setMeasureShape((SurfaceShape)this.shape);
        }
    }

    @Override
    public void dispose() {
        this.getWwd().getInputHandler().removeMouseListener(this);
        this.getWwd().getInputHandler().removeMouseMotionListener(this);
        this.getWwd().removePositionListener(this);
        this.getWwd().removeSelectListener(this);
        this.getWwd().removeRenderingListener(this);
        this.controlPoints.removeFromLayer(this.controlPointsLayer);
        this.measureDisplay.removeFromLayer(this.controlPointsLayer);
        this.getControlPoints().clear();
    }

    protected ControlPointList createControlPoints() {
        return new WWOMeasureToolControlPoints(this);
    }

    protected MeasureDisplay createMeasureDisplay() {
        return new WWOMeasureDisplay(this);
    }

    public WorldWindow getWwd() {
        return this.wwd;
    }

    public void setUnitsFormat(UnitsFormat unitsFormat) {
        if (unitsFormat == null) {
            String string = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.unitsFormat = unitsFormat;
    }

    public UnitsFormat getUnitsFormat() {
        return this.unitsFormat;
    }

    public void setLabel(String string, String string2) {
        this.measureDisplay.setLabel(string, string2);
    }

    public String getLabel(String string) {
        return this.measureDisplay.getLabel(string);
    }

    public Renderable getShape() {
        return this.shape;
    }

    public boolean isShowControlPoints() {
        return this.showControlPoints;
    }

    public void setShowControlPoints(boolean bl) {
        this.showControlPoints = bl;
        this.controlPointsLayer.setEnabled(bl);
        this.getWwd().redraw();
    }

    public boolean isShowAnnotation() {
        return this.showAnnotation;
    }

    public void setShowAnnotation(boolean bl) {
        this.showAnnotation = bl;
    }

    public boolean isUseRubberBand() {
        return this.useRubberBand;
    }

    public void setUseRubberBand(boolean bl) {
        this.useRubberBand = bl;
    }

    public boolean isFreeHand() {
        return this.freeHand;
    }

    public void setFreeHand(boolean bl) {
        this.freeHand = bl;
    }

    public double getFreeHandMinSpacing() {
        return this.freeHandMinSpacing;
    }

    public void setFreeHandMinSpacing(double d) {
        this.freeHandMinSpacing = d;
    }

    public void clear() {
        while (this.positions.size() > 0 || this.getControlPoints().size() > 0) {
            this.removeControlPoint();
        }
        this.shapeCenterPosition = null;
        this.shapeOrientation = null;
        this.shapeRectangle = null;
    }

    public String getMeasureShapeType() {
        return this.measureShapeType;
    }

    public ArrayList<? extends Position> getPositions() {
        return this.positions;
    }

    protected ControlPointList getControlPoints() {
        return this.controlPoints;
    }

    protected ControlPoint createControlPoint(Position position) {
        return this.controlPoints.createControlPoint(position);
    }

    public Rectangle2D.Double getShapeRectangle() {
        return this.shapeRectangle;
    }

    protected void setMeasureShape(Polyline polyline, String string) {
        if (polyline == null) {
            String string2 = Logging.getMessage("nullValue.Shape");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.setArmed(false);
        this.clear();
        this.shape = polyline;
        this.regularShape = false;
        int n = 0;
        for (Position position : polyline.getPositions()) {
            this.positions.add(position);
            this.addControlPoint(position, "PositionIndex", n++);
        }
        this.measureShapeType = string != null && string.equals("gov.nasa.worldwind.avkey.ShapePath") ? "gov.nasa.worldwind.avkey.ShapePath" : "gov.nasa.worldwind.avkey.ShapeLine";
        this.firePropertyChange(EVENT_POSITION_REPLACE, null, null);
        this.getWwd().redraw();
    }

    protected void setMeasureShape(SurfaceShape surfaceShape) {
        if (surfaceShape == null) {
            String string = Logging.getMessage("nullValue.Shape");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setArmed(false);
        this.clear();
        if (surfaceShape instanceof SurfaceQuad) {
            this.shape = surfaceShape;
            this.regularShape = true;
            this.measureShapeType = surfaceShape instanceof SurfaceSquare ? "gov.nasa.worldwind.avkey.ShapeSquare" : "gov.nasa.worldwind.avkey.ShapeQuad";
            SurfaceQuad surfaceQuad = (SurfaceQuad)surfaceShape;
            this.shapeCenterPosition = new Position(surfaceQuad.getCenter(), 0.0);
            this.shapeRectangle = new Rectangle2D.Double(0.0, 0.0, surfaceQuad.getWidth(), surfaceQuad.getHeight());
            this.shapeOrientation = surfaceQuad.getHeading();
            this.updateShapeControlPoints();
            this.updatePositionsFromShape();
        } else if (surfaceShape instanceof SurfaceEllipse) {
            this.shape = surfaceShape;
            this.regularShape = true;
            this.measureShapeType = surfaceShape instanceof SurfaceCircle ? "gov.nasa.worldwind.avkey.ShapeCircle" : "gov.nasa.worldwind.avkey.ShapeEllipse";
            SurfaceEllipse surfaceEllipse = (SurfaceEllipse)surfaceShape;
            this.shapeCenterPosition = new Position(surfaceEllipse.getCenter(), 0.0);
            this.shapeRectangle = new Rectangle2D.Double(0.0, 0.0, surfaceEllipse.getMajorRadius() * 2.0, surfaceEllipse.getMinorRadius() * 2.0);
            this.shapeOrientation = surfaceEllipse.getHeading();
            this.updateShapeControlPoints();
            this.updatePositionsFromShape();
        } else {
            this.shape = surfaceShape;
            this.measureShapeType = "gov.nasa.worldwind.avkey.ShapePolygon";
            this.updatePositionsFromShape();
            for (int i = 0; i < this.positions.size() - 1; ++i) {
                this.addControlPoint(this.positions.get(i), "PositionIndex", i);
            }
        }
        this.firePropertyChange(EVENT_POSITION_REPLACE, null, null);
        this.getWwd().redraw();
    }

    protected boolean isRegularShape() {
        return this.regularShape;
    }

    public double getLength() {
        if (this.shape == null) {
            return -1.0;
        }
        if (this.shape instanceof Polyline) {
            return ((Polyline)this.shape).getLength();
        }
        return ((SurfaceShape)this.shape).getPerimeter(this.getWwd().getModel().getGlobe());
    }

    public double getArea() {
        return this.shape != null && this.shape instanceof SurfaceShape ? ((SurfaceShape)this.shape).getArea(this.getWwd().getModel().getGlobe(), true) : -1.0;
    }

    public double getWidth() {
        return this.shapeRectangle != null ? this.shapeRectangle.width : -1.0;
    }

    public double getHeight() {
        return this.shapeRectangle != null ? this.shapeRectangle.height : -1.0;
    }

    public Angle getOrientation() {
        return this.shapeOrientation;
    }

    public Position getCenterPosition() {
        return this.shapeCenterPosition;
    }

    public void addControlPoint() {
        Position position = this.getWwd().getCurrentPosition();
        if (position == null) {
            return;
        }
        if (this.isRegularShape()) {
            if (this.shapeCenterPosition == null) {
                this.shapeCenterPosition = position;
                this.updateShapeControlPoints();
            } else if (this.shapeRectangle == null) {
                this.updateShapeProperties("East", position);
                this.updateShapeControlPoints();
            }
        } else if (!this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapePolygon") || this.positions.size() <= 1) {
            this.positions.add(position);
            this.addControlPoint(this.positions.get(this.positions.size() - 1), "PositionIndex", this.positions.size() - 1);
            if (this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapePolygon") && this.positions.size() == 2) {
                this.positions.add(this.positions.get(0));
            }
            if (this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapeLine") && this.positions.size() > 1) {
                this.shapeOrientation = LatLon.greatCircleAzimuth(this.positions.get(0), this.positions.get(1));
            }
        } else {
            this.positions.add(this.positions.size() - 1, position);
            this.addControlPoint(this.positions.get(this.positions.size() - 2), "PositionIndex", this.positions.size() - 2);
        }
        this.updateMeasureShape();
        this.firePropertyChange(EVENT_POSITION_ADD, null, position);
        this.getWwd().redraw();
    }

    public void removeControlPoint() {
        Position position = null;
        if (this.isRegularShape()) {
            if (this.shapeRectangle != null) {
                this.shapeRectangle = null;
                this.shapeOrientation = null;
                this.positions.clear();
                while (this.getControlPoints().size() > 1) {
                    this.getControlPoints().remove(1);
                }
            } else if (this.shapeCenterPosition != null) {
                this.shapeCenterPosition = null;
                this.getControlPoints().clear();
            }
        } else {
            if (this.positions.size() == 0) {
                return;
            }
            if (!this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapePolygon") || this.positions.size() == 1) {
                position = this.positions.get(this.positions.size() - 1);
                this.positions.remove(this.positions.size() - 1);
            } else {
                position = this.positions.get(this.positions.size() - 2);
                this.positions.remove(this.positions.size() - 2);
                if (this.positions.size() == 2) {
                    this.positions.remove(1);
                }
            }
            if (this.getControlPoints().size() > 0) {
                this.getControlPoints().remove(this.getControlPoints().size() - 1);
            }
        }
        this.updateMeasureShape();
        this.firePropertyChange(EVENT_POSITION_REMOVE, position, null);
        this.getWwd().redraw();
    }

    public void moveControlPoint(ControlPoint controlPoint) {
        if (controlPoint == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (controlPoint.getValue("Control") != null) {
            this.updateShapeProperties((String)controlPoint.getValue("Control"), controlPoint.getPosition());
            this.updateShapeControlPoints();
        }
        if (controlPoint.getValue("PositionIndex") != null) {
            int n = (Integer)controlPoint.getValue("PositionIndex");
            Position position = this.computeSurfacePosition(controlPoint.getPosition());
            this.positions.set(n, position);
            if (this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapePolygon") && this.positions.size() > 2 && n == 0) {
                this.positions.set(this.positions.size() - 1, position);
            }
            if (this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapeLine") && this.positions.size() > 1) {
                this.shapeOrientation = LatLon.greatCircleAzimuth(this.positions.get(0), this.positions.get(1));
            }
        }
        this.updateMeasureShape();
    }

    public void moveMeasureShape(Angle angle, Angle angle2) {
        if (angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.isRegularShape()) {
            if (this.getControlPoints().size() > 0) {
                ControlPoint controlPoint = this.getControlPoints().get(0);
                controlPoint.setPosition(new Position(LatLon.greatCircleEndPosition((LatLon)controlPoint.getPosition(), angle, angle2), 0.0));
                this.moveControlPoint(controlPoint);
            }
        } else {
            for (int i = 0; i < this.positions.size(); ++i) {
                Position position = this.computeSurfacePosition(LatLon.greatCircleEndPosition((LatLon)this.positions.get(i), angle, angle2));
                this.positions.set(i, position);
                if (this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapePolygon") && i >= this.positions.size() - 1) continue;
                this.getControlPoints().get(i).setPosition(new Position(position, 0.0));
            }
            if (this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapeLine") && this.positions.size() > 1) {
                this.shapeOrientation = LatLon.greatCircleAzimuth(this.positions.get(0), this.positions.get(1));
            }
            this.updateMeasureShape();
        }
    }

    protected Position computeSurfacePosition(LatLon latLon) {
        Vec4 vec4 = this.getWwd().getSceneController().getTerrain().getSurfacePoint(latLon.getLatitude(), latLon.getLongitude());
        if (vec4 != null) {
            return this.getWwd().getModel().getGlobe().computePositionFromPoint(vec4);
        }
        return new Position(latLon, this.getWwd().getModel().getGlobe().getElevation(latLon.getLatitude(), latLon.getLongitude()));
    }

    protected void updateShapeProperties(String string, Position position) {
        if (string.equals("Center")) {
            this.shapeCenterPosition = position;
        } else {
            double d;
            double d2;
            double d3 = string.equals("East") ? 90.0 : (string.equals("South") ? 180.0 : (string.equals("West") ? 270.0 : 0.0));
            this.shapeOrientation = LatLon.greatCircleAzimuth(this.shapeCenterPosition, position).subtractDegrees(d3);
            Angle angle = LatLon.greatCircleDistance(this.shapeCenterPosition, position);
            double d4 = Math.max(angle.radians * this.getWwd().getModel().getGlobe().getRadius(), 0.1);
            if (string.equals("East") || string.equals("West")) {
                d2 = d4 * 2.0;
                double d5 = d = this.shapeRectangle != null ? this.shapeRectangle.height : d2;
                if (this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapeCircle") || this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapeSquare")) {
                    d = d2;
                } else if (this.isActive()) {
                    d = d2 * 0.6;
                }
            } else {
                d = d4 * 2.0;
                double d6 = d2 = this.shapeRectangle != null ? this.shapeRectangle.width : d;
                if (this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapeCircle") || this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapeSquare")) {
                    d2 = d;
                } else if (this.isActive()) {
                    d2 = d * 0.6;
                }
            }
            this.shapeRectangle = new Rectangle2D.Double(0.0, 0.0, d2, d);
        }
    }

    protected void updateShapeControlPoints() {
        if (this.shapeCenterPosition != null && this.getControlPoints().size() < 1) {
            this.addControlPoint(Position.ZERO, "Control", "Center");
        }
        if (this.shapeCenterPosition != null) {
            this.getControlPoints().get(0).setPosition(new Position(this.shapeCenterPosition, 0.0));
        }
        if (this.shapeRectangle != null && this.getControlPoints().size() < 5) {
            this.addControlPoint(Position.ZERO, "Control", "North");
            this.addControlPoint(Position.ZERO, "Control", "East");
            this.addControlPoint(Position.ZERO, "Control", "South");
            this.addControlPoint(Position.ZERO, "Control", "West");
        }
        if (this.shapeRectangle != null) {
            Angle angle = Angle.fromRadians(this.shapeRectangle.width / 2.0 / this.getWwd().getModel().getGlobe().getRadius());
            Angle angle2 = Angle.fromRadians(this.shapeRectangle.height / 2.0 / this.getWwd().getModel().getGlobe().getRadius());
            Position position = new Position(LatLon.greatCircleEndPosition((LatLon)this.shapeCenterPosition, this.shapeOrientation, angle2), 0.0);
            this.getControlPoints().get(1).setPosition(position);
            position = new Position(LatLon.greatCircleEndPosition((LatLon)this.shapeCenterPosition, this.shapeOrientation.addDegrees(90.0), angle), 0.0);
            this.getControlPoints().get(2).setPosition(position);
            position = new Position(LatLon.greatCircleEndPosition((LatLon)this.shapeCenterPosition, this.shapeOrientation.addDegrees(180.0), angle2), 0.0);
            this.getControlPoints().get(3).setPosition(position);
            position = new Position(LatLon.greatCircleEndPosition((LatLon)this.shapeCenterPosition, this.shapeOrientation.addDegrees(270.0), angle), 0.0);
            this.getControlPoints().get(4).setPosition(position);
        }
    }

    protected void updateMeasureShape() {
        if (this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapeLine") || this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapePath")) {
            if (this.positions.size() > 1 && this.shape != null) {
                ((Polyline)this.shape).setPositions(this.positions);
            }
        } else if (this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapePolygon")) {
            if (this.shape != null) {
                ((SurfacePolygon)this.shape).setLocations(this.positions);
            }
        } else if (this.isRegularShape() && this.shape != null && this.shapeRectangle != null) {
            if (this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapeQuad") || this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapeSquare")) {
                ((SurfaceQuad)this.shape).setCenter(this.shapeCenterPosition);
                ((SurfaceQuad)this.shape).setSize(this.shapeRectangle.width, this.shapeRectangle.height);
                ((SurfaceQuad)this.shape).setHeading(this.shapeOrientation);
            }
            if (this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapeEllipse") || this.measureShapeType.equals("gov.nasa.worldwind.avkey.ShapeCircle")) {
                ((SurfaceEllipse)this.shape).setCenter(this.shapeCenterPosition);
                ((SurfaceEllipse)this.shape).setRadii(this.shapeRectangle.width / 2.0, this.shapeRectangle.height / 2.0);
                ((SurfaceEllipse)this.shape).setHeading(this.shapeOrientation);
            }
            this.updatePositionsFromShape();
        }
    }

    protected void updatePositionsFromShape() {
        Globe globe = this.getWwd().getModel().getGlobe();
        this.positions.clear();
        Iterable<? extends LatLon> iterable = ((SurfaceShape)this.shape).getLocations(globe);
        if (iterable != null) {
            for (LatLon latLon : iterable) {
                this.positions.add(new Position(latLon, 0.0));
            }
        }
    }

    protected void addControlPoint(Position position, String string, Object object) {
        ControlPoint controlPoint = this.createControlPoint(new Position(position, 0.0));
        controlPoint.setValue(string, object);
        this.getControlPoints().add(controlPoint);
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean bl) {
        this.active = bl;
    }

    protected boolean isMoving() {
        return this.moving;
    }

    protected void setMoving(boolean bl) {
        this.moving = bl;
    }

    public boolean isArmed() {
        return this.armed;
    }

    public void setArmed(boolean bl) {
        if (this.armed != bl) {
            this.armed = bl;
            this.firePropertyChange(EVENT_ARMED, !bl, bl);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isArmed() && this.useRubberBand && mouseEvent.getButton() == 1) {
            if ((mouseEvent.getModifiersEx() & 0x400) != 0 && !mouseEvent.isControlDown()) {
                this.setActive(true);
                this.addControlPoint();
                if (this.getControlPoints().size() == 1) {
                    this.addControlPoint();
                }
                this.rubberBandTarget = this.getControlPoints().get(this.isRegularShape() ? 2 : this.getControlPoints().size() - 1);
                this.firePropertyChange(EVENT_RUBBERBAND_START, null, null);
            }
            mouseEvent.consume();
        } else if (!this.isArmed() && mouseEvent.getButton() == 1 && mouseEvent.isAltDown()) {
            this.setMoving(true);
            this.movingTarget = this.lastPickedObject;
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isArmed() && this.useRubberBand && mouseEvent.getButton() == 1) {
            if (this.useRubberBand && this.getPositions().size() == 1) {
                this.removeControlPoint();
            }
            this.setActive(false);
            this.rubberBandTarget = null;
            this.autoDisarm();
            mouseEvent.consume();
            this.firePropertyChange(EVENT_RUBBERBAND_STOP, null, null);
        } else if (this.isMoving() && mouseEvent.getButton() == 1) {
            this.setMoving(false);
            this.movingTarget = null;
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isArmed() && mouseEvent.getButton() == 1) {
            if (mouseEvent.isControlDown()) {
                this.removeControlPoint();
            } else if (!this.useRubberBand) {
                this.addControlPoint();
                this.autoDisarm();
            }
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isArmed() && (mouseEvent.getModifiersEx() & 0x400) != 0) {
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void moved(PositionEvent positionEvent) {
        if (!this.active && !this.moving) {
            return;
        }
        this.doMoved();
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (this.isArmed() && this.useRubberBand) {
            return;
        }
        if (this.dragger == null) {
            this.dragger = new BasicDragger(this.getWwd());
        }
        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
            this.highlight(selectEvent.getTopObject());
        }
        this.doSelected(selectEvent);
    }

    @Override
    public void stageChanged(RenderingEvent renderingEvent) {
    }

    protected void doMoved() {
        if (this.active && this.rubberBandTarget != null && this.getWwd().getCurrentPosition() != null) {
            if (!this.freeHand || !this.getMeasureShapeType().equals("gov.nasa.worldwind.avkey.ShapePath") && !this.getMeasureShapeType().equals("gov.nasa.worldwind.avkey.ShapePolygon")) {
                Position position = this.rubberBandTarget.getPosition();
                this.rubberBandTarget.setPosition(new Position(this.getWwd().getCurrentPosition(), 0.0));
                this.moveControlPoint(this.rubberBandTarget);
                this.firePropertyChange(EVENT_POSITION_REPLACE, position, this.rubberBandTarget.getPosition());
                this.getWwd().redraw();
            } else {
                Position position = this.rubberBandTarget.getPosition();
                Position position2 = this.getWwd().getCurrentPosition();
                double d = LatLon.greatCircleDistance((LatLon)position, (LatLon)position2).radians * this.getWwd().getModel().getGlobe().getRadius();
                if (d >= this.freeHandMinSpacing) {
                    this.addControlPoint();
                    this.rubberBandTarget = this.getControlPoints().get(this.getControlPoints().size() - 1);
                    this.getWwd().redraw();
                }
            }
        } else if (this.moving && this.movingTarget != null && this.getWwd().getCurrentPosition() != null) {
            Position position = this.movingTarget.getPosition();
            Position position3 = this.getWwd().getCurrentPosition();
            this.moveToPosition(position, position3);
        }
    }

    protected void moveToPosition(Position position, Position position2) {
        Angle angle = LatLon.greatCircleDistance(position, position2);
        Angle angle2 = LatLon.greatCircleAzimuth(position, position2);
        this.moveMeasureShape(angle2, angle);
        this.firePropertyChange(EVENT_POSITION_REPLACE, position, position2);
    }

    public void addSelectListener(SelectListener selectListener) {
        this.eventListeners.add(SelectListener.class, selectListener);
    }

    protected void callSelectListeners(final SelectEvent selectEvent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (SelectListener selectListener : (SelectListener[])WWOMeasureTool.this.eventListeners.getListeners(SelectListener.class)) {
                    selectListener.selected(selectEvent);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected void doSelected(SelectEvent selectEvent) {
        if (selectEvent.getTopObject() != null) {
            if (selectEvent.getTopObject() instanceof ControlPoint) {
                ControlPoint controlPoint = (ControlPoint)selectEvent.getTopObject();
                if (controlPoint.getParent() != this) {
                    return;
                }
                if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && !this.dragger.isDragging()) {
                    this.highlight(controlPoint);
                } else if (this.movingTarget == null && (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag"))) {
                    this.dragSelected(selectEvent);
                }
            } else if (this.measureDisplay.isAnnotation(selectEvent.getTopObject())) {
                Object position = null;
                if (selectEvent.getObjects().getTerrainObject() != null) {
                    Position object = selectEvent.getObjects().getTerrainObject().getPosition();
                }
                if (this.isShowAnnotation()) {
                    void var2_5;
                    this.measureDisplay.updateMeasureDisplay((Position)var2_5);
                }
            } else if (selectEvent.getTopObject() == this.shape) {
                for (SelectListener selectListener : (SelectListener[])this.eventListeners.getListeners(SelectListener.class)) {
                    selectListener.selected(selectEvent);
                }
                Object var2_7 = null;
                if (selectEvent.getObjects().getTerrainObject() != null) {
                    Position position = selectEvent.getObjects().getTerrainObject().getPosition();
                }
                if (this.isShowAnnotation()) {
                    void var2_9;
                    this.measureDisplay.updateMeasureDisplay((Position)var2_9);
                }
            } else if (this.isShowAnnotation()) {
                this.measureDisplay.updateMeasureDisplay(null);
            }
        }
    }

    protected void dragSelected(SelectEvent selectEvent) {
        ControlPoint controlPoint = (ControlPoint)selectEvent.getTopObject();
        LatLon latLon = controlPoint.getPosition();
        if (controlPoint.getValue("PositionIndex") != null) {
            latLon = this.getPositions().get((Integer)controlPoint.getValue("PositionIndex"));
        }
        this.dragger.selected(selectEvent);
        this.moveControlPoint(controlPoint);
        if (this.isShowAnnotation()) {
            this.measureDisplay.updateMeasureDisplay(controlPoint.getPosition());
        }
        this.firePropertyChange(EVENT_POSITION_REPLACE, latLon, controlPoint.getPosition());
        this.getWwd().redraw();
    }

    protected void highlight(Object object) {
        if (this.lastPickedObject == object) {
            return;
        }
        if (object != null && object instanceof ControlPoint && ((ControlPoint)object).getParent() != this) {
            return;
        }
        if (this.lastPickedObject != null) {
            this.lastPickedObject.highlight(false);
            this.lastPickedObject = null;
            if (this.isShowAnnotation()) {
                this.measureDisplay.updateMeasureDisplay(null);
            }
        }
        if (object != null && object instanceof ControlPoint) {
            this.lastPickedObject = (ControlPoint)object;
            this.lastPickedObject.highlight(true);
            if (this.isShowAnnotation()) {
                this.measureDisplay.updateMeasureDisplay(this.lastPickedObject.getPosition());
            }
        }
    }

    protected void autoDisarm() {
        if ((this.isRegularShape() || this.getMeasureShapeType().equals("gov.nasa.worldwind.avkey.ShapeLine")) && this.getControlPoints().size() > 1) {
            this.setArmed(false);
        }
    }

    public static interface ControlPointList {
        public int size();

        public ControlPoint createControlPoint(Position var1);

        public ControlPoint get(int var1);

        public void add(ControlPoint var1);

        public void remove(ControlPoint var1);

        public void remove(int var1);

        public void clear();

        public void render(DrawContext var1);

        public void addToLayer(RenderableLayer var1);

        public void removeFromLayer(RenderableLayer var1);
    }

    public static interface ControlPoint {
        public WWOMeasureTool getParent();

        public Object setValue(String var1, Object var2);

        public Object getValue(String var1);

        public void setPosition(Position var1);

        public Position getPosition();

        public void highlight(boolean var1);
    }

    public static interface MeasureDisplay {
        public static final String ANGLE_LABEL = "MeasureTool.AngleLabel";
        public static final String AREA_LABEL = "MeasureTool.AreaLabel";
        public static final String LENGTH_LABEL = "MeasureTool.LengthLabel";
        public static final String PERIMETER_LABEL = "MeasureTool.PerimeterLabel";
        public static final String RADIUS_LABEL = "MeasureTool.RadiusLabel";
        public static final String HEIGHT_LABEL = "MeasureTool.HeightLabel";
        public static final String WIDTH_LABEL = "MeasureTool.WidthLabel";
        public static final String HEADING_LABEL = "MeasureTool.HeadingLabel";
        public static final String CENTER_LATITUDE_LABEL = "MeasureTool.CenterLatitudeLabel";
        public static final String CENTER_LONGITUDE_LABEL = "MeasureTool.CenterLongitudeLabel";
        public static final String LATITUDE_LABEL = "MeasureTool.LatitudeLabel";
        public static final String LONGITUDE_LABEL = "MeasureTool.LongitudeLabel";
        public static final String ACCUMULATED_LABEL = "MeasureTool.AccumulatedLabel";
        public static final String MAJOR_AXIS_LABEL = "MeasureTool.MajorAxisLabel";
        public static final String MINOR_AXIS_LABEL = "MeasureTool.MinorAxisLabel";

        public void updateMeasureDisplay(Position var1);

        public void addToLayer(RenderableLayer var1);

        public void removeFromLayer(RenderableLayer var1);

        public void setLabel(String var1, String var2);

        public String getLabel(String var1);

        public boolean isAnnotation(Object var1);
    }
}

