/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.util;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.LayerPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class LayerTree
implements Iterable<Layer> {
    protected String name;
    protected LayerList layers = new LayerList();
    protected List<LayerTree> children = new ArrayList<LayerTree>();
    protected Controller controller;

    public abstract void createLayers(Object var1, AVList var2);

    public LayerTree(Controller controller) {
        this.controller = controller;
    }

    public String getDisplayName() {
        return this.name;
    }

    public void setDisplayName(String string) {
        this.name = string;
    }

    public LayerTree(LayerList layerList) {
        this.layers = layerList;
    }

    public LayerList getLayers() {
        return this.layers;
    }

    public void setLayers(LayerList layerList) {
        this.layers = layerList;
    }

    public List<LayerTree> getChildren() {
        return this.children;
    }

    public void setChildren(List<LayerTree> list) {
        this.children = list;
    }

    public boolean hasLayers() {
        return this.getLayers() != null && this.getLayers().size() > 0;
    }

    public boolean hasChildren() {
        return this.getChildren().size() > 0;
    }

    public Object getChild(String string) {
        for (Layer object : this.layers) {
            if (!object.getName().equals(string)) continue;
            return object;
        }
        if (!this.hasChildren()) {
            return null;
        }
        for (LayerTree layerTree : this.getChildren()) {
            if (!layerTree.getDisplayName().equals(string)) continue;
            return layerTree;
        }
        return null;
    }

    public Layer getLayer(List<String> list) {
        LayerTree layerTree = this;
        for (int i = 1; i < list.size(); ++i) {
            Object object = layerTree.getChild(list.get(i));
            if (object instanceof Layer) {
                return (Layer)object;
            }
            if (!(object instanceof LayerTree)) break;
            layerTree = (LayerTree)object;
        }
        return null;
    }

    @Override
    public Iterator<Layer> iterator() {
        return new LayerIterator();
    }

    public Iterator<LayerPath> getPathIterator(LayerPath layerPath) {
        return new LayerPathIterator(layerPath);
    }

    private class LayerPathIterator
    implements Iterator<LayerPath> {
        protected ArrayList<LayerPath> paths = new ArrayList();
        protected Iterator<LayerPath> pathIterator;
        protected LayerPath basePath;

        public LayerPathIterator(LayerPath layerPath) {
            this.basePath = layerPath != null ? layerPath : new LayerPath();
            this.buildPathList(LayerTree.this);
            this.pathIterator = this.paths.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.pathIterator.hasNext();
        }

        @Override
        public LayerPath next() {
            return this.pathIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported for LayerIterator");
        }

        protected void buildPathList(LayerTree layerTree) {
            this.buildPath(layerTree, this.basePath);
        }

        protected void buildPath(LayerTree layerTree, LayerPath layerPath) {
            LayerPath layerPath2;
            for (Layer object : layerTree.getLayers()) {
                layerPath2 = new LayerPath(layerPath);
                layerPath2.add(object.getName());
                this.paths.add(layerPath2);
            }
            for (LayerTree layerTree2 : layerTree.getChildren()) {
                layerPath2 = new LayerPath(layerPath);
                layerPath2.add(layerTree2.getDisplayName());
                this.buildPath(layerTree2, layerPath2);
            }
        }
    }

    private class LayerIterator
    implements Iterator<Layer> {
        protected ArrayList<Layer> layers = new ArrayList();
        protected Iterator<Layer> layerListIterator;

        public LayerIterator() {
            this.buildLayerList(LayerTree.this);
            this.layerListIterator = this.layers.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.layerListIterator.hasNext();
        }

        @Override
        public Layer next() {
            return this.layerListIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported for LayerIterator");
        }

        protected void buildLayerList(LayerTree layerTree) {
            for (Layer object : layerTree.getLayers()) {
                this.layers.add(object);
            }
            for (LayerTree layerTree2 : layerTree.getChildren()) {
                this.buildLayerList(layerTree2);
            }
        }
    }
}

