/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.core;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.RenderingExceptionListener;
import gov.nasa.worldwind.exception.WWAbsentRequirementException;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.WWPanel;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;

public class WWPanelImpl
extends AbstractFeature
implements WWPanel {
    private JPanel panel = new JPanel(new BorderLayout());
    private WorldWindowGLCanvas wwd = new WorldWindowGLCanvas();

    public WWPanelImpl(Registry registry) {
        super("World Wind Panel", "gov.nasa.worldwindx.applications.worldwindow.WWPanel", registry);
        this.wwd.addRenderingExceptionListener(new RenderingExceptionListener(){

            @Override
            public void exceptionThrown(Throwable throwable) {
                if (throwable instanceof WWAbsentRequirementException) {
                    String string = "This computer is not capable of running ";
                    string = string + Configuration.getStringValue("gov.nasa.worldwindx.applications.worldwindow.ApplicationDisplayName");
                    string = string + ".";
                    Util.getLogger().severe(string);
                    System.exit(-1);
                }
            }
        });
        Model model = (Model)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ModelClassName");
        this.wwd.setModel(model);
        this.wwd.getSceneController().getScreenCreditController().setEnabled(false);
        this.wwd.setPreferredSize(new Dimension(1024, 768));
        this.panel.add((Component)((Object)this.wwd), "Center");
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
    }

    @Override
    public WorldWindow getWWd() {
        return this.wwd;
    }

    @Override
    public JPanel getJPanel() {
        return this.panel;
    }

    @Override
    public Dimension getSize() {
        return this.panel.getSize();
    }

    @Override
    public void addLayer(Layer layer) {
        if (layer != null) {
            this.wwd.getModel().getLayers().add(layer);
        }
    }

    @Override
    public void removeLayer(Layer layer) {
        this.wwd.getModel().getLayers().remove(layer);
    }

    @Override
    public void insertBeforeNamedLayer(Layer layer, String string) {
        if (layer == null) {
            return;
        }
        if (string == null) {
            this.wwd.getModel().getLayers().add(layer);
            return;
        }
        int n = 0;
        LayerList layerList = this.wwd.getModel().getLayers();
        for (Layer layer2 : layerList) {
            if (layer2.getName().indexOf(string) == -1) continue;
            n = layerList.indexOf(layer2);
            break;
        }
        layerList.add(n, layer);
    }

    @Override
    public void insertAfterNamedLayer(Layer layer, String string) {
        if (layer == null) {
            return;
        }
        if (string == null) {
            this.wwd.getModel().getLayers().add(layer);
            return;
        }
        int n = 0;
        LayerList layerList = this.wwd.getModel().getLayers();
        for (Layer layer2 : layerList) {
            if (layer2.getName().indexOf(string) == -1) continue;
            n = layerList.indexOf(layer2);
        }
        layerList.add(n + 1, layer);
    }
}

