/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.core;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.ogc.kml.KMLRoot;
import gov.nasa.worldwind.ogc.kml.impl.KMLController;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.LayerManager;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.LayerPath;
import gov.nasa.worldwindx.examples.util.ShapefileLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLStreamException;

public class SimpleImporter {
    protected static final String DEFAULT_GROUP = "Recently Opened";
    protected static final AtomicInteger nextLayerNumber = new AtomicInteger(0);
    protected Object source;
    protected Controller controller;

    public SimpleImporter(Object object, Controller controller) {
        this.source = object;
        this.controller = controller;
    }

    protected LayerPath getDefaultPathToParent() {
        return new LayerPath(DEFAULT_GROUP, new String[0]);
    }

    protected void addLayer(final Layer layer, final LayerPath layerPath) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LayerPath layerPath2 = new LayerPath(layerPath != null ? layerPath : SimpleImporter.this.getDefaultPathToParent(), layer.getName());
                SimpleImporter.this.doAddLayer(layer, layerPath2);
            }
        });
    }

    protected void doAddLayer(Layer layer, LayerPath layerPath) {
        LayerManager layerManager = this.controller.getLayerManager();
        layerManager.addLayer(layer, layerPath.lastButOne());
        layerManager.selectLayer(layer, true);
        layerManager.expandPath(layerPath.lastButOne());
    }

    public String formName(Object object, String string) {
        if (object instanceof File) {
            return ((File)object).getName();
        }
        if (object instanceof URL) {
            return ((URL)object).getPath();
        }
        if (object instanceof URI) {
            return ((URI)object).getPath();
        }
        if (object instanceof String && WWIO.makeURL((String)object) != null) {
            return WWIO.makeURL((String)object).getPath();
        }
        return (string != null ? string : "Layer ") + nextLayerNumber.addAndGet(1);
    }

    public void startImport() {
        if (this.source == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            throw new IllegalStateException(string);
        }
        if (this.isKML(this.source)) {
            this.openKML(this.source);
        } else if (this.isShapfile(this.source)) {
            this.openShapefile(this.source);
        } else {
            String string = Logging.getMessage("generic.UnrecognizedSourceType", this.source.toString());
            throw new IllegalArgumentException(string);
        }
    }

    protected boolean isKML(Object object) {
        return object != null && (object.toString().endsWith(".kml") || object.toString().endsWith(".kmz"));
    }

    protected void openKML(Object object) {
        try {
            KMLRoot kMLRoot = KMLRoot.create(object);
            if (kMLRoot == null) {
                String string = Logging.getMessage("generic.UnrecognizedSourceType", object.toString(), object.toString());
                throw new IllegalArgumentException(string);
            }
            kMLRoot.parse(new Object[0]);
            KMLController kMLController = new KMLController(kMLRoot);
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.addRenderable(kMLController);
            renderableLayer.setName(this.formName(object, null));
            this.addLayer(renderableLayer, null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
    }

    protected boolean isShapfile(Object object) {
        return object != null && object.toString().endsWith(".shp");
    }

    protected void openShapefile(Object object) {
        ShapefileLoader shapefileLoader = new ShapefileLoader();
        Layer layer = shapefileLoader.createLayerFromSource(object);
        if (layer != null) {
            layer.setName(this.formName(object, null));
            this.addLayer(layer, null);
        }
    }
}

