/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar.segmentplane;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.applications.sar.segmentplane.SegmentPlane;
import java.awt.Color;
import java.awt.Font;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;

public class SegmentPlaneAttributes {
    private Map<Object, GeometryAttributes> geometryAttributes = new HashMap<Object, GeometryAttributes>();
    private Map<Object, LabelAttributes> labelAttributes = new HashMap<Object, LabelAttributes>();

    public SegmentPlaneAttributes copy() {
        SegmentPlaneAttributes segmentPlaneAttributes = new SegmentPlaneAttributes();
        HashMap<Object, GeometryAttributes> hashMap = new HashMap<Object, GeometryAttributes>();
        for (Map.Entry<Object, GeometryAttributes> object : this.geometryAttributes.entrySet()) {
            hashMap.put(object.getKey(), object.getValue().copy());
        }
        segmentPlaneAttributes.setAllGeometryAttributes(hashMap);
        HashMap hashMap2 = new HashMap();
        for (Map.Entry<Object, LabelAttributes> entry : this.labelAttributes.entrySet()) {
            hashMap2.put(entry.getKey(), entry.getValue().copy());
        }
        segmentPlaneAttributes.setAllLabelAttributes(hashMap2);
        return segmentPlaneAttributes;
    }

    public Map<Object, GeometryAttributes> getAllGeometryAttributes() {
        return Collections.unmodifiableMap(this.geometryAttributes);
    }

    public void setAllGeometryAttributes(Map<Object, ? extends GeometryAttributes> map) {
        if (map == null) {
            String string = Logging.getMessage("nullValue.MapIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.geometryAttributes.clear();
        this.geometryAttributes.putAll(map);
    }

    public Map<Object, LabelAttributes> getAllLabelAttributes() {
        return Collections.unmodifiableMap(this.labelAttributes);
    }

    public void setAllLabelAttributes(Map<Object, ? extends LabelAttributes> map) {
        if (map == null) {
            String string = Logging.getMessage("nullValue.MapIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.labelAttributes.clear();
        this.labelAttributes.putAll(map);
    }

    public GeometryAttributes getGeometryAttributes(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.geometryAttributes.get(object);
    }

    public void setGeometryAttributes(Object object, GeometryAttributes geometryAttributes) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometryAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.geometryAttributes.put(object, geometryAttributes);
    }

    public LabelAttributes getLabelAttributes(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.labelAttributes.get(object);
    }

    public void setLabelAttributes(Object object, LabelAttributes labelAttributes) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (labelAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.labelAttributes.put(object, labelAttributes);
    }

    public static void applyGeometryAttributes(DrawContext drawContext, GeometryAttributes geometryAttributes, boolean bl) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (geometryAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!drawContext.isPickingMode()) {
            SegmentPlaneAttributes.applyMaterial(drawContext, geometryAttributes.getMaterial(), geometryAttributes.getOpacity(), bl);
        }
    }

    public static void applyGeometryAttributesAsLine(DrawContext drawContext, GeometryAttributes geometryAttributes) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (geometryAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        SegmentPlaneAttributes.applyLineWidth(drawContext, geometryAttributes.getSize(), geometryAttributes.getPicksize());
    }

    protected static void applyMaterial(DrawContext drawContext, Material material, double d, boolean bl) {
        GL2 gL2 = drawContext.getGL().getGL2();
        if (bl) {
            material.apply(gL2, 1032, (float)d);
        } else {
            float[] fArray = new float[4];
            material.getDiffuse().getRGBComponents(fArray);
            fArray[3] = (float)d;
            gL2.glColor4fv(fArray, 0);
        }
    }

    protected static void applyLineWidth(DrawContext drawContext, double d, double d2) {
        GL gL = drawContext.getGL();
        if (drawContext.isPickingMode()) {
            gL.glLineWidth((float)d2);
        } else {
            gL.glLineWidth((float)d);
        }
    }

    public static class LabelAttributes {
        private boolean visible;
        private Color color;
        private Font font;
        private String horizontalAlignment;
        private String verticalAlignment;
        private double minActiveDistance;
        private double maxActiveDistance;
        private Vec4 offset;

        public LabelAttributes(Color color, Font font, String string, String string2) {
            if (color == null) {
                String string3 = Logging.getMessage("nullValue.ColorIsNull");
                Logging.logger().severe(string3);
                throw new IllegalArgumentException(string3);
            }
            if (font == null) {
                String string4 = Logging.getMessage("nullValue.FontIsNull");
                Logging.logger().severe(string4);
                throw new IllegalArgumentException(string4);
            }
            if (string == null) {
                String string5 = Logging.getMessage("nullValue.HorizontalAlignmentIsNull");
                Logging.logger().severe(string5);
                throw new IllegalArgumentException(string5);
            }
            if (string2 == null) {
                String string6 = Logging.getMessage("nullValue.VerticalAlignmentIsNull");
                Logging.logger().severe(string6);
                throw new IllegalArgumentException(string6);
            }
            this.visible = true;
            this.color = color;
            this.font = font;
            this.horizontalAlignment = string;
            this.verticalAlignment = string2;
            this.minActiveDistance = 0.0;
            this.maxActiveDistance = Double.MAX_VALUE;
            this.offset = Vec4.ZERO;
        }

        public LabelAttributes() {
            this(Color.WHITE, Font.decode("Arial-12"), "gov.nasa.worldwind.avkey.Left", "gov.nasa.worldwind.avkey.Bottom");
        }

        public LabelAttributes copy() {
            return this.copyTo(new LabelAttributes());
        }

        protected LabelAttributes copyTo(LabelAttributes labelAttributes) {
            labelAttributes.setVisible(this.isVisible());
            labelAttributes.setColor(this.getColor());
            labelAttributes.setFont(this.getFont());
            labelAttributes.setHorizontalAlignment(this.getHorizontalAlignment());
            labelAttributes.setVerticalAlignment(this.getVerticalAlignment());
            labelAttributes.setMinActiveDistance(this.getMinActiveDistance());
            labelAttributes.setMaxActiveDistance(this.getMaxActiveDistance());
            labelAttributes.setOffset(this.getOffset());
            return labelAttributes;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            if (color == null) {
                String string = Logging.getMessage("nullValue.ColorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.color = color;
        }

        public Font getFont() {
            return this.font;
        }

        public void setFont(Font font) {
            if (font == null) {
                String string = Logging.getMessage("nullValue.FontIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.font = font;
        }

        public String getHorizontalAlignment() {
            return this.horizontalAlignment;
        }

        public void setHorizontalAlignment(String string) {
            if (string == null) {
                String string2 = Logging.getMessage("nullValue.HorizontalAlignmentIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            this.horizontalAlignment = string;
        }

        public String getVerticalAlignment() {
            return this.verticalAlignment;
        }

        public void setVerticalAlignment(String string) {
            if (string == null) {
                String string2 = Logging.getMessage("nullValue.VerticalAlignmentIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            this.verticalAlignment = string;
        }

        public double getMinActiveDistance() {
            return this.minActiveDistance;
        }

        public void setMinActiveDistance(double d) {
            this.minActiveDistance = d;
        }

        public double getMaxActiveDistance() {
            return this.maxActiveDistance;
        }

        public void setMaxActiveDistance(double d) {
            this.maxActiveDistance = d;
        }

        public Vec4 getOffset() {
            return this.offset;
        }

        public void setOffset(Vec4 vec4) {
            if (vec4 == null) {
                String string = Logging.getMessage("nullValue.Vec4IsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.offset = vec4;
        }

        public String getText(SegmentPlane segmentPlane, Position position, AVList aVList) {
            if (segmentPlane == null) {
                String string = Logging.getMessage("nullValue.SegmentPlaneIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (position == null) {
                String string = Logging.getMessage("nullValue.PositionIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Lat ").append(position.getLatitude().toString());
            stringBuilder.append("\n");
            stringBuilder.append("Lon ").append(position.getLongitude());
            stringBuilder.append("\n");
            stringBuilder.append("Alt ").append(position.getElevation()).append("m");
            return stringBuilder.toString();
        }
    }

    public static class GeometryAttributes {
        private boolean visible;
        private boolean pickEnabled;
        private Material material;
        private double opacity;
        private double size;
        private double pickSize;
        private Vec4 offset;

        public GeometryAttributes(Material material, double d) {
            if (material == null) {
                String string = Logging.getMessage("nullValue.MaterialIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (d < 0.0 || d > 1.0) {
                String string = Logging.getMessage("generic.ArgumentOutOfRange", "opacity < 0 or opacity > 1");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.visible = true;
            this.pickEnabled = true;
            this.material = material;
            this.opacity = d;
            this.size = 1.0;
            this.pickSize = 1.0;
            this.offset = Vec4.ZERO;
        }

        public GeometryAttributes() {
            this(Material.WHITE, 1.0);
        }

        public GeometryAttributes copy() {
            return this.copyTo(new GeometryAttributes());
        }

        public GeometryAttributes copyTo(GeometryAttributes geometryAttributes) {
            geometryAttributes.setVisible(this.isVisible());
            geometryAttributes.setEnablePicking(this.isEnablePicking());
            geometryAttributes.setMaterial(this.getMaterial());
            geometryAttributes.setOpacity(this.getOpacity());
            geometryAttributes.setSize(this.getSize());
            geometryAttributes.setPickSize(this.getPicksize());
            geometryAttributes.setOffset(this.getOffset());
            return geometryAttributes;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }

        public boolean isEnablePicking() {
            return this.pickEnabled;
        }

        public void setEnablePicking(boolean bl) {
            this.pickEnabled = bl;
        }

        public Material getMaterial() {
            return this.material;
        }

        public void setMaterial(Material material) {
            if (material == null) {
                String string = Logging.getMessage("nullValue.MaterialIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.material = material;
        }

        public double getOpacity() {
            return this.opacity;
        }

        public void setOpacity(double d) {
            if (d < 0.0 || d > 1.0) {
                String string = Logging.getMessage("generic.ArgumentOutOfRange", "opacity < 0 or opacity > 1");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.opacity = d;
        }

        public double getSize() {
            return this.size;
        }

        public void setSize(double d) {
            if (d < 0.0) {
                String string = Logging.getMessage("generic.ArgumentOutOfRange", "size < 0");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.size = d;
        }

        public double getPicksize() {
            return this.pickSize;
        }

        public void setPickSize(double d) {
            if (d < 0.0) {
                String string = Logging.getMessage("generic.ArgumentOutOfRange", "size < 0");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.pickSize = d;
        }

        public Vec4 getOffset() {
            return this.offset;
        }

        public void setOffset(Vec4 vec4) {
            if (vec4 == null) {
                String string = Logging.getMessage("nullValue.Vec4IsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.offset = vec4;
        }
    }
}

