/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.applications.sar.SARPosition;
import gov.nasa.worldwindx.applications.sar.SARSegmentPlane;
import gov.nasa.worldwindx.applications.sar.SARTrack;
import gov.nasa.worldwindx.applications.sar.segmentplane.SegmentPlaneAttributes;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;

public class SARTrackExtensionTool
implements MouseListener,
PositionListener,
PropertyChangeListener {
    private boolean armed;
    private WorldWindow wwd;
    private SARTrack track;
    protected SARSegmentPlane segmentPlane = new SARSegmentPlane();
    protected Position potentialNextPosition;
    protected boolean waitingForNextPosition = true;
    protected boolean ignoreTrackChangeEvents = false;
    protected SegmentPlaneAttributes.GeometryAttributes segmentEndGeomAttribs;
    protected SegmentPlaneAttributes.LabelAttributes segmentEndLabelAttribs;

    public SARTrackExtensionTool() {
        this.segmentPlane.addPropertyChangeListener(this);
        this.segmentEndGeomAttribs = this.segmentPlane.getAttributes().getGeometryAttributes("SegmentPlane.SegmentEnd").copy();
        this.segmentEndLabelAttribs = this.segmentPlane.getAttributes().getLabelAttributes("SegmentPlane.SegmentEnd").copy();
    }

    public boolean isArmed() {
        return this.armed;
    }

    public void setArmed(boolean bl) {
        boolean bl2 = this.armed;
        this.armed = bl;
        this.segmentPlane.setArmed(bl);
        if (!bl2 && this.armed) {
            this.start();
        } else if (bl2 && !this.armed) {
            this.stop();
        }
    }

    public WorldWindow getWwd() {
        return this.wwd;
    }

    public void setWorldWindow(WorldWindow worldWindow) {
        if (this.wwd == worldWindow) {
            return;
        }
        if (this.wwd != null) {
            this.wwd.getInputHandler().removeMouseListener(this);
            this.wwd.removePositionListener(this);
        }
        this.wwd = worldWindow;
        this.segmentPlane.setWorldWindow(worldWindow);
        if (this.wwd != null) {
            this.wwd.getInputHandler().addMouseListener(this);
            this.wwd.addPositionListener(this);
        }
    }

    public SARTrack getTrack() {
        return this.track;
    }

    public void setTrack(SARTrack sARTrack) {
        if (this.track == sARTrack) {
            return;
        }
        if (this.track != null) {
            this.track.removePropertyChangeListener(this);
        }
        this.track = sARTrack;
        this.onTrackChanged();
        if (this.track != null) {
            this.track.addPropertyChangeListener(this);
        }
    }

    public boolean canMoveToNextTrackPoint() {
        return this.track != null && !this.waitingForNextPosition;
    }

    public void moveToNextTrackPoint() {
        if (this.track == null || this.waitingForNextPosition) {
            return;
        }
        this.start();
    }

    public boolean canRemoveLastTrackPoint() {
        return this.track != null && this.track.size() != 0;
    }

    public void removeLastTrackPoint() {
        if (this.track == null || this.track.size() == 0) {
            return;
        }
        int n = this.track.size() - 1;
        this.track.removePosition(n);
        this.waitingForNextPosition = true;
    }

    protected void start() {
        if (this.track.size() >= 1) {
            this.snapPlaneToLastTrackPoint();
            this.segmentPlane.setVisible(true);
        } else {
            this.segmentPlane.setVisible(false);
        }
        this.waitingForNextPosition = true;
    }

    protected void stop() {
        this.segmentPlane.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNextPosition(Position position) {
        SARPosition sARPosition = this.positionToTrackPosition(position);
        this.ignoreTrackChangeEvents = true;
        try {
            this.track.appendPosition(sARPosition);
        }
        finally {
            this.ignoreTrackChangeEvents = false;
        }
        this.segmentPlane.getAttributes().setGeometryAttributes("SegmentPlane.SegmentEnd", this.segmentEndGeomAttribs.copy());
        this.segmentPlane.getAttributes().setLabelAttributes("SegmentPlane.SegmentEnd", this.segmentEndLabelAttribs.copy());
        this.snapPlaneToLastTrackSegment();
    }

    protected void setPotentialNextPosition(Position position) {
        this.potentialNextPosition = position;
        if (this.potentialNextPosition != null) {
            Position[] positionArray = this.segmentPlane.getSegmentPositions();
            this.segmentPlane.setSegmentPositions(positionArray[0], this.potentialNextPosition);
            this.segmentPlane.getAttributes().setGeometryAttributes("SegmentPlane.SegmentEnd", this.createPotentialNextPositionGeomAttributes());
            this.segmentPlane.getAttributes().setLabelAttributes("SegmentPlane.SegmentEnd", this.createPotentialNextPositionLabelAttributes());
            this.showSegmentEndPoint(true);
        } else {
            this.showSegmentEndPoint(false);
        }
    }

    protected PickedObject getTopPickedObject() {
        return this.wwd.getSceneController().getPickedObjectList() != null ? this.wwd.getSceneController().getPickedObjectList().getTopPickedObject() : null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent == null || mouseEvent.isConsumed()) {
            return;
        }
        if (!this.armed || this.wwd == null) {
            return;
        }
        if (mouseEvent.getButton() == 1 && this.waitingForNextPosition && this.potentialNextPosition != null) {
            this.setNextPosition(this.potentialNextPosition);
            this.waitingForNextPosition = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void moved(PositionEvent positionEvent) {
        if (positionEvent == null) {
            return;
        }
        if (!this.armed || this.wwd == null) {
            return;
        }
        if (this.waitingForNextPosition) {
            Object object;
            Position position = null;
            PickedObject pickedObject = this.getTopPickedObject();
            if (pickedObject != null && ((object = pickedObject.getValue("gov.nasa.worldwind.avkey.PickedObject.ID")) == "SegmentPlane.PlaneBackground" || this.segmentPlane.isSnapToGrid() && object == "SegmentPlane.PlaneGrid")) {
                position = pickedObject.getPosition();
            }
            this.setPotentialNextPosition(position);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "SegmentPlane.SegmentEnd") {
            this.snapTrackPointToPlanePoint(string);
        } else if (!(string != "TrackController.TrackModified" && string != "TrackController.TrackOffset" || this.ignoreTrackChangeEvents)) {
            this.start();
        }
    }

    protected void onTrackChanged() {
        SegmentPlaneAttributes.LabelAttributes labelAttributes = this.segmentPlane.getAttributes().getLabelAttributes("SegmentPlane.HorizontalAxisLabels");
        if (labelAttributes != null) {
            Color color = this.track != null ? WWUtil.makeColorBrighter(this.track.getColor()) : WWUtil.makeColorBrighter(Color.RED);
            labelAttributes.setColor(color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void snapTrackPointToPlanePoint(String string) {
        if (this.track == null) {
            return;
        }
        if (this.track.size() == 0) {
            return;
        }
        if (this.waitingForNextPosition && string == "SegmentPlane.SegmentEnd") {
            return;
        }
        Position[] positionArray = this.segmentPlane.getSegmentPositions();
        this.ignoreTrackChangeEvents = true;
        try {
            if (string == "SegmentPlane.SegmentEnd") {
                int n = this.track.size() - 1;
                SARPosition sARPosition = this.positionToTrackPosition(positionArray[1]);
                this.track.set(n, sARPosition);
            }
        }
        finally {
            this.ignoreTrackChangeEvents = false;
        }
    }

    protected void snapPlaneToLastTrackPoint() {
        if (this.track == null) {
            return;
        }
        if (this.track.size() == 0) {
            return;
        }
        int n = this.track.size() - 1;
        SARPosition sARPosition = this.track.get(n);
        SARPosition sARPosition2 = this.computeNextTrackPosition();
        if (sARPosition2 == null) {
            sARPosition2 = sARPosition;
        }
        Position position = this.trackPositionToPosition(sARPosition);
        Position position2 = this.trackPositionToPosition(sARPosition2);
        double[] dArray = this.segmentPlane.computeAltitudesToFitPositions(Arrays.asList(position, position2));
        LatLon[] latLonArray = this.segmentPlane.computeLocationsToFitPositions(position, position2);
        this.segmentPlane.setPlaneAltitudes(dArray[0], dArray[1]);
        this.segmentPlane.setPlaneLocations(latLonArray[0], latLonArray[1]);
        this.segmentPlane.setSegmentPositions(position, position2);
        this.showSegmentEndPoint(false);
        this.wwd.redraw();
    }

    protected void snapPlaneToLastTrackSegment() {
        if (this.track == null) {
            return;
        }
        if (this.track.size() < 2) {
            return;
        }
        int n = this.track.size() - 1;
        SARPosition sARPosition = this.track.get(n - 1);
        SARPosition sARPosition2 = this.track.get(n);
        Position position = this.trackPositionToPosition(sARPosition);
        Position position2 = this.trackPositionToPosition(sARPosition2);
        double[] dArray = this.segmentPlane.computeAltitudesToFitPositions(Arrays.asList(position, position2));
        LatLon[] latLonArray = this.segmentPlane.computeLocationsToFitPositions(position, position2);
        this.segmentPlane.setPlaneAltitudes(dArray[0], dArray[1]);
        this.segmentPlane.setPlaneLocations(latLonArray[0], latLonArray[1]);
        this.segmentPlane.setSegmentPositions(position, position2);
        this.showSegmentEndPoint(true);
        this.wwd.redraw();
    }

    protected void showSegmentEndPoint(boolean bl) {
        this.segmentPlane.setObjectVisible("SegmentPlane.SegmentEnd", bl, bl);
        this.segmentPlane.setObjectVisible("SegmentPlane.Altimeter", bl, false);
    }

    protected SARPosition computeNextTrackPosition(Point point) {
        View view = this.wwd.getView();
        Line line = view.computeRayFromScreenPoint(point.getX(), point.getY());
        Position position = this.segmentPlane.getIntersectionPosition(line);
        return this.positionToTrackPosition(position);
    }

    protected SARPosition computeNextTrackPosition() {
        if (this.track.size() < 2) {
            return null;
        }
        Globe globe = this.wwd.getModel().getGlobe();
        double[] dArray = this.segmentPlane.getGridCellDimensions();
        int n = this.track.size() - 1;
        SARPosition sARPosition = this.track.get(n);
        Vec4 vec4 = globe.computePointFromPosition(sARPosition);
        double d = this.segmentPlane.getObjectSize("SegmentPlane.SegmentEnd", vec4);
        double d2 = Math.ceil(2.0 * d / dArray[0]);
        if (d2 < 1.0) {
            d2 = 1.0;
        }
        Angle angle = LatLon.rhumbAzimuth(this.track.get(n - 1), sARPosition);
        Angle angle2 = Angle.fromRadians((d2 *= dArray[0]) / globe.getRadius());
        LatLon latLon = LatLon.rhumbEndPosition((LatLon)sARPosition, angle, angle2);
        return new SARPosition(latLon.getLatitude(), latLon.getLongitude(), sARPosition.getElevation());
    }

    protected SARPosition positionToTrackPosition(Position position) {
        double d = this.track.getOffset();
        return new SARPosition(position.getLatitude(), position.getLongitude(), position.getElevation() - d);
    }

    protected Position trackPositionToPosition(Position position) {
        double d = this.track.getOffset();
        return new Position(position.getLatitude(), position.getLongitude(), position.getElevation() + d);
    }

    protected SegmentPlaneAttributes.GeometryAttributes createPotentialNextPositionGeomAttributes() {
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes = new SegmentPlaneAttributes.GeometryAttributes(Material.BLUE, 1.0);
        geometryAttributes.setSize(8.0);
        geometryAttributes.setPickSize(0.0);
        return geometryAttributes;
    }

    protected SegmentPlaneAttributes.LabelAttributes createPotentialNextPositionLabelAttributes() {
        SARSegmentPlane.MessageLabelAttributes messageLabelAttributes = new SARSegmentPlane.MessageLabelAttributes(Color.WHITE, Font.decode("Arial-18"), "gov.nasa.worldwind.avkey.Left", "gov.nasa.worldwind.avkey.Center", "Click to add");
        messageLabelAttributes.setOffset(new Vec4(15.0, 0.0, 0.0));
        return messageLabelAttributes;
    }
}

