/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwindx.applications.dataimporter.ColorAllocator;
import gov.nasa.worldwindx.applications.dataimporter.FileSetPreviewImageGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;

public class FileSet
extends AVListImpl {
    protected static final int MAX_FILES_FOR_PREVIEW_IMAGE = 20;
    protected static final int PREVIEW_IMAGE_SIZE = 1024;
    protected static final int ICON_IMAGE_SIZE = 32;
    public static final String FILE_SET_CODE = "gov.nasa.worldwindx.dataimport.FileSet.FileSetCode";
    public static final String FILE_SET_ABBREVIATION = "gov.nasa.worldwindx.dataimport.FileSet.FileSetAbbreviation";
    public static final String FILE_SET_SCALE = "gov.nasa.worldwindx.dataimport.FileSet.FileSetScale";
    public static final String FILE_SET_GSD = "gov.nasa.worldwindx.dataimport.FileSet.FileSetGSD";
    public static final String SECTOR_LIST = "SectorList";
    public static final String IMAGE_ICON = "ImageIcon";
    public static final String IMAGE_IN_PROGRESS = "ImageInProgress";
    List<File> files = new ArrayList<File>();
    protected static ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 5, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(200));

    public FileSet() {
        this.setValue("gov.nasa.worldwind.avkey.Color", ColorAllocator.getNextColor());
    }

    public void clear() {
        Layer layer = (Layer)this.getValue("gov.nasa.worldwind.avkey.LayerObject");
        if (layer != null) {
            layer.dispose();
            this.removeKey("gov.nasa.worldwind.avkey.LayerObject");
        }
        this.removeKey("gov.nasa.worldwind.avkey.Image");
        this.removeKey(IMAGE_ICON);
    }

    public int getLength() {
        return this.files.size();
    }

    public void addFile(File file) {
        this.files.add(file);
    }

    public List<File> getFiles() {
        return this.files;
    }

    public boolean isImagery() {
        return "Imagery".equals(this.getDataType());
    }

    public boolean isElevation() {
        return "Elevation".equals(this.getDataType());
    }

    public String getDataType() {
        return this.getStringValue("gov.nasa.worldwind.avkey.DataType");
    }

    public void setDataType(String string) {
        this.setValue("gov.nasa.worldwind.avkey.DataType", string);
    }

    public String getName() {
        return this.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
    }

    public void setName(String string) {
        if (string != null) {
            this.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
        }
    }

    public String getDatasetType() {
        return this.getStringValue("gov.nasa.worldwind.avkey.DatasetTypeKey");
    }

    public void setDatasetType(String string) {
        if (string != null) {
            this.setValue("gov.nasa.worldwind.avkey.DatasetTypeKey", string);
        }
    }

    public String getScale() {
        return this.getStringValue(FILE_SET_SCALE);
    }

    public void setScale(String string) {
        if (string != null) {
            this.setValue(FILE_SET_SCALE, string);
        }
    }

    public Sector getSector() {
        return (Sector)this.getValue("gov.nasa.worldwind.avKey.Sector");
    }

    public void setSector(Sector sector) {
        this.setValue("gov.nasa.worldwind.avKey.Sector", sector);
    }

    public Object[] getSectorList() {
        return (Object[])this.getValue(SECTOR_LIST);
    }

    public void addSectorList(Object[] objectArray) {
        Object[] objectArray2 = (Object[])this.getValue(SECTOR_LIST);
        if (objectArray2 == null) {
            this.setValue(SECTOR_LIST, objectArray);
            return;
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(objectArray2.length + objectArray.length);
        arrayList.add(objectArray2);
        arrayList.add(objectArray);
        this.setValue(SECTOR_LIST, arrayList.toArray());
    }

    public Color getColor() {
        return (Color)this.getValue("gov.nasa.worldwind.avkey.Color");
    }

    public void setColor(Color color) {
        this.setValue("gov.nasa.worldwind.avkey.Color", color);
    }

    public int getMaxFilesForPreviewImage() {
        return 20;
    }

    public ImageIcon getImageIcon() {
        if (this.getValue(IMAGE_ICON) != null) {
            return (ImageIcon)this.getValue(IMAGE_ICON);
        }
        return this.makeImageIcon();
    }

    public BufferedImage getImage() {
        if (!this.isImagery() || this.getLength() > this.getMaxFilesForPreviewImage()) {
            return null;
        }
        if (this.getValue("gov.nasa.worldwind.avkey.Image") != null) {
            return (BufferedImage)this.getValue("gov.nasa.worldwind.avkey.Image");
        }
        this.makeImage();
        return null;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.setValue("gov.nasa.worldwind.avkey.Image", bufferedImage);
        this.removeKey(IMAGE_IN_PROGRESS);
        this.firePropertyChange(new PropertyChangeEvent(this, "gov.nasa.worldwind.avkey.Image", false, true));
    }

    protected void makeImage() {
        if (this.getValue(IMAGE_IN_PROGRESS) != null) {
            return;
        }
        this.setValue(IMAGE_IN_PROGRESS, true);
        FileSetPreviewImageGenerator fileSetPreviewImageGenerator = new FileSetPreviewImageGenerator(this, 1024, 1024);
        threadPoolExecutor.submit(fileSetPreviewImageGenerator);
    }

    protected ImageIcon makeImageIcon() {
        BufferedImage bufferedImage = this.getImage();
        if (bufferedImage == null) {
            return null;
        }
        BufferedImage bufferedImage2 = new BufferedImage(32, 32, bufferedImage.getType());
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        while (!graphics2D.drawImage(bufferedImage, 0, 0, 32, 32, null)) {
        }
        graphics2D.dispose();
        ImageIcon imageIcon = new ImageIcon(bufferedImage2);
        this.setValue(IMAGE_ICON, imageIcon);
        return imageIcon;
    }
}

