/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import uk.ac.rdg.resc.ncwms.coords.HorizontalGrid;
import uk.ac.rdg.resc.ncwms.coords.chrono.ThreeSixtyDayChronology;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidDimensionValueException;
import uk.ac.rdg.resc.ncwms.exceptions.WmsException;
import uk.ac.rdg.resc.ncwms.util.Range;
import uk.ac.rdg.resc.ncwms.util.Ranges;
import uk.ac.rdg.resc.ncwms.wms.Layer;
import uk.ac.rdg.resc.ncwms.wms.ScalarLayer;
import uk.ac.rdg.resc.ncwms.wms.SimpleVectorLayer;
import uk.ac.rdg.resc.ncwms.wms.VectorLayer;

public class WmsUtils {
    public static final Set<String> SUPPORTED_VERSIONS = new HashSet<String>();
    private static final DateTimeFormatter ISO_DATE_TIME_FORMATTER = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter ISO_DATE_TIME_PARSER = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter ISO_TIME_FORMATTER = ISODateTimeFormat.time().withZone(DateTimeZone.UTC);
    public static final Comparator<DateTime> DATE_TIME_COMPARATOR = new Comparator<DateTime>(){

        @Override
        public int compare(DateTime dt1, DateTime dt2) {
            return dt1.compareTo((Object)dt2);
        }
    };

    private WmsUtils() {
        throw new AssertionError();
    }

    public static String dateTimeToISO8601(DateTime dateTime) {
        return ISO_DATE_TIME_FORMATTER.print((ReadableInstant)dateTime);
    }

    public static DateTime iso8601ToDateTime(String isoDateTime, Chronology chronology) {
        return ISO_DATE_TIME_PARSER.withChronology(chronology).parseDateTime(isoDateTime);
    }

    public static String formatUTCTimeOnly(DateTime dateTime) {
        return ISO_TIME_FORMATTER.print((ReadableInstant)dateTime);
    }

    public static int findTimeIndex(List<DateTime> dtList, DateTime target) {
        return Collections.binarySearch(dtList, target, DATE_TIME_COMPARATOR);
    }

    public static void createDirectory(File dir) throws Exception {
        if (dir.exists()) {
            if (dir.isDirectory()) {
                return;
            }
            throw new Exception(dir.getPath() + " already exists but it is a regular file");
        }
        boolean created = dir.mkdirs();
        if (!created) {
            throw new Exception("Could not create directory " + dir.getPath());
        }
    }

    public static String createUniqueLayerName(String datasetId, String layerId) {
        return datasetId + "/" + layerId;
    }

    public static double[] parseBbox(String bboxStr) throws WmsException {
        String[] bboxEls = bboxStr.split(",");
        if (bboxEls.length != 4) {
            throw new WmsException("Invalid bounding box format: need four elements");
        }
        double[] bbox = new double[4];
        try {
            for (int i = 0; i < bbox.length; ++i) {
                bbox[i] = Double.parseDouble(bboxEls[i]);
            }
        }
        catch (NumberFormatException nfe) {
            throw new WmsException("Invalid bounding box format: all elements must be numeric");
        }
        if (bbox[0] >= bbox[2] || bbox[1] >= bbox[3]) {
            throw new WmsException("Invalid bounding box format");
        }
        return bbox;
    }

    public static List<Float> getMagnitudes(List<Float> eastData, List<Float> northData) {
        if (eastData == null || northData == null) {
            throw new NullPointerException();
        }
        if (eastData.size() != northData.size()) {
            throw new IllegalArgumentException("east and north data components must be the same length");
        }
        ArrayList<Float> mag = new ArrayList<Float>(eastData.size());
        for (int i = 0; i < eastData.size(); ++i) {
            Float east = eastData.get(i);
            Float north = northData.get(i);
            Float val = null;
            if (east != null && north != null) {
                val = Float.valueOf((float)Math.sqrt(east.floatValue() * east.floatValue() + north.floatValue() * north.floatValue()));
            }
            mag.add(val);
        }
        if (mag.size() != eastData.size()) {
            throw new AssertionError();
        }
        return mag;
    }

    public static boolean isOpendapLocation(String location) {
        return location.startsWith("http://") || location.startsWith("dods://") || location.startsWith("https://");
    }

    public static boolean isNcmlAggregation(String location) {
        return location.endsWith(".xml") || location.endsWith(".ncml");
    }

    public static Range<Float> estimateValueRange(Layer layer) throws IOException {
        if (layer instanceof ScalarLayer) {
            List<Float> dataSample = WmsUtils.readDataSample((ScalarLayer)layer);
            return Ranges.findMinMax(dataSample);
        }
        if (layer instanceof VectorLayer) {
            VectorLayer vecLayer = (VectorLayer)layer;
            List<Float> eastDataSample = WmsUtils.readDataSample(vecLayer.getEastwardComponent());
            List<Float> northDataSample = WmsUtils.readDataSample(vecLayer.getEastwardComponent());
            List<Float> magnitudes = WmsUtils.getMagnitudes(eastDataSample, northDataSample);
            return Ranges.findMinMax(magnitudes);
        }
        throw new IllegalStateException("Unrecognized layer type");
    }

    private static List<Float> readDataSample(ScalarLayer layer) throws IOException {
        try {
            return layer.readPointList(layer.getDefaultTimeValue(), layer.getDefaultElevationValue(), new HorizontalGrid(100, 100, layer.getGeographicBoundingBox()));
        }
        catch (InvalidDimensionValueException idve) {
            throw new IllegalStateException(idve);
        }
    }

    public static List<VectorLayer> findVectorLayers(Collection<? extends ScalarLayer> scalarLayers) {
        LinkedHashMap<String, ScalarLayer[]> components = new LinkedHashMap<String, ScalarLayer[]>();
        for (ScalarLayer scalarLayer : scalarLayers) {
            String vectorKey;
            if (scalarLayer.getTitle().contains("eastward")) {
                vectorKey = scalarLayer.getTitle().replaceFirst("eastward_", "");
                if (!components.containsKey(vectorKey)) {
                    components.put(vectorKey, new ScalarLayer[2]);
                }
                ((ScalarLayer[])components.get((Object)vectorKey))[0] = scalarLayer;
                continue;
            }
            if (!scalarLayer.getTitle().contains("northward")) continue;
            vectorKey = scalarLayer.getTitle().replaceFirst("northward_", "");
            if (!components.containsKey(vectorKey)) {
                components.put(vectorKey, new ScalarLayer[2]);
            }
            ((ScalarLayer[])components.get((Object)vectorKey))[1] = scalarLayer;
        }
        ArrayList<VectorLayer> vectorLayers = new ArrayList<VectorLayer>();
        for (String key : components.keySet()) {
            ScalarLayer[] comps = (ScalarLayer[])components.get(key);
            if (comps[0] == null || comps[1] == null) continue;
            SimpleVectorLayer vec = new SimpleVectorLayer(key, comps[0], comps[1]);
            vectorLayers.add(vec);
        }
        return vectorLayers;
    }

    public static boolean isVectorLayer(Layer layer) {
        return layer instanceof VectorLayer;
    }

    public static String getTimeAxisUnits(Chronology chronology) {
        if (chronology instanceof ISOChronology) {
            return "ISO8601";
        }
        if (chronology instanceof ThreeSixtyDayChronology) {
            return "360_day";
        }
        return "unknown";
    }

    static {
        SUPPORTED_VERSIONS.add("1.1.1");
        SUPPORTED_VERSIONS.add("1.3.0");
    }
}

