/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.graphics;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidFormatException;
import uk.ac.rdg.resc.ncwms.graphics.GifFormat;
import uk.ac.rdg.resc.ncwms.graphics.JpegFormat;
import uk.ac.rdg.resc.ncwms.graphics.KmzFormat;
import uk.ac.rdg.resc.ncwms.graphics.PngFormat;
import uk.ac.rdg.resc.ncwms.wms.Layer;

public abstract class ImageFormat {
    private static final Map<String, ImageFormat> formats = new HashMap<String, ImageFormat>();

    public static Set<String> getSupportedMimeTypes() {
        return formats.keySet();
    }

    public static ImageFormat get(String mimeType) throws InvalidFormatException {
        ImageFormat format = formats.get(mimeType);
        if (format == null) {
            throw new InvalidFormatException("The image format " + mimeType + " is not supported by this server");
        }
        return format;
    }

    public abstract String getMimeType();

    public abstract boolean supportsMultipleFrames();

    public abstract boolean supportsFullyTransparentPixels();

    public abstract boolean supportsPartiallyTransparentPixels();

    public abstract boolean requiresLegend();

    public abstract void writeImage(List<BufferedImage> var1, OutputStream var2, Layer var3, List<String> var4, String var5, double[] var6, BufferedImage var7) throws IOException;

    static {
        ImageIO.setUseCache(false);
        for (ImageFormat format : new ImageFormat[]{new PngFormat(), new GifFormat(), new JpegFormat(), new KmzFormat()}) {
            formats.put(format.getMimeType(), format);
        }
    }
}

