/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.coords;

import java.util.AbstractList;
import java.util.List;
import uk.ac.rdg.resc.ncwms.coords.CrsHelper;
import uk.ac.rdg.resc.ncwms.coords.HorizontalPosition;
import uk.ac.rdg.resc.ncwms.coords.LonLatPosition;

public abstract class PointList {
    public abstract CrsHelper getCrsHelper();

    public abstract HorizontalPosition getPoint(int var1);

    public abstract int size();

    public static PointList fromList(final List<HorizontalPosition> list, final CrsHelper crsHelper) {
        return new PointList(){

            @Override
            public CrsHelper getCrsHelper() {
                return crsHelper;
            }

            @Override
            public HorizontalPosition getPoint(int index) {
                return (HorizontalPosition)list.get(index);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public List<HorizontalPosition> asList() {
                return list;
            }
        };
    }

    public static PointList fromPoint(final HorizontalPosition point, final CrsHelper crsHelper) {
        return new PointList(){

            @Override
            public CrsHelper getCrsHelper() {
                return crsHelper;
            }

            @Override
            public HorizontalPosition getPoint(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException();
                }
                return point;
            }

            @Override
            public int size() {
                return 1;
            }
        };
    }

    public static PointList fromPoint(HorizontalPosition point) {
        if (point.getCoordinateReferenceSystem() == null) {
            throw new IllegalArgumentException("The horizontal position must have an associated coordinate reference system");
        }
        return PointList.fromPoint(point, CrsHelper.fromCrs(point.getCoordinateReferenceSystem()));
    }

    public static PointList fromPoint(LonLatPosition lonLat) {
        return PointList.fromPoint(lonLat, CrsHelper.CRS_84);
    }

    public List<HorizontalPosition> asList() {
        return new AbstractList<HorizontalPosition>(){

            @Override
            public HorizontalPosition get(int index) {
                return PointList.this.getPoint(index);
            }

            @Override
            public int size() {
                return PointList.this.size();
            }
        };
    }
}

