/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.coords;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.ac.rdg.resc.ncwms.coords.CrsHelper;
import uk.ac.rdg.resc.ncwms.coords.HorizontalPosition;
import uk.ac.rdg.resc.ncwms.coords.HorizontalPositionImpl;
import uk.ac.rdg.resc.ncwms.coords.InvalidLineStringException;

public final class LineString {
    private final List<HorizontalPosition> controlPoints;
    private final transient double[] controlPointDistances;
    private double pathLength;
    private CrsHelper crsHelper;

    public LineString(String lineStringSpec, CrsHelper crsHelper) throws InvalidLineStringException {
        String[] pointsStr = lineStringSpec.split(",");
        if (pointsStr.length < 2) {
            throw new InvalidLineStringException("At least two points are required to generate a transect");
        }
        if (crsHelper == null) {
            throw new NullPointerException("CrsHelper cannot be null");
        }
        this.crsHelper = crsHelper;
        ArrayList<HorizontalPositionImpl> ctlPoints = new ArrayList<HorizontalPositionImpl>();
        for (String s : pointsStr) {
            String[] coords = s.trim().split(" +");
            if (coords.length != 2) {
                throw new InvalidLineStringException("Coordinates format error");
            }
            try {
                ctlPoints.add(new HorizontalPositionImpl(Double.parseDouble(coords[0].trim()), Double.parseDouble(coords[1].trim())));
            }
            catch (NumberFormatException nfe) {
                throw new InvalidLineStringException("Coordinates format error");
            }
        }
        this.controlPoints = Collections.unmodifiableList(ctlPoints);
        this.controlPointDistances = new double[this.controlPoints.size()];
        this.controlPointDistances[0] = this.pathLength = 0.0;
        for (int i = 1; i < this.controlPoints.size(); ++i) {
            HorizontalPosition p1 = this.controlPoints.get(i - 1);
            HorizontalPosition p2 = this.controlPoints.get(i);
            double dx = p2.getX() - p1.getX();
            double dy = p2.getY() - p1.getY();
            this.pathLength += Math.sqrt(dx * dx + dy * dy);
            this.controlPointDistances[i] = this.pathLength;
        }
    }

    public List<HorizontalPosition> getControlPoints() {
        return this.controlPoints;
    }

    public double getFractionalControlPointDistance(int index) {
        if (index < 0 || index >= this.controlPointDistances.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.controlPointDistances[index] / this.pathLength;
    }

    public List<HorizontalPosition> getPointsOnPath(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("Must request at least 2 points");
        }
        ArrayList<HorizontalPosition> points = new ArrayList<HorizontalPosition>(n);
        points.add(this.controlPoints.get(0));
        for (int i = 1; i < n - 1; ++i) {
            double s = this.pathLength * (double)i / (double)(n - 1);
            points.add(this.interpolatePoint(s));
        }
        points.add(this.controlPoints.get(this.controlPoints.size() - 1));
        return Collections.unmodifiableList(points);
    }

    private HorizontalPosition interpolatePoint(double s) {
        if (s < 0.0 || s > this.pathLength) {
            throw new IllegalArgumentException("s does not lie on the path");
        }
        int i = this.getPreviousControlPointIndex(s);
        double dlast = s - this.controlPointDistances[i];
        double dnext = this.controlPointDistances[i + 1] - s;
        double dfrac = dlast / (dlast + dnext);
        HorizontalPosition cplast = this.controlPoints.get(i);
        HorizontalPosition cpnext = this.controlPoints.get(i + 1);
        double x = (1.0 - dfrac) * cplast.getX() + dfrac * cpnext.getX();
        double y = (1.0 - dfrac) * cplast.getY() + dfrac * cpnext.getY();
        return new HorizontalPositionImpl(x, y);
    }

    private int getPreviousControlPointIndex(double s) {
        for (int i = 1; i < this.controlPointDistances.length; ++i) {
            if (!(this.controlPointDistances[i] > s)) continue;
            return i - 1;
        }
        throw new AssertionError();
    }

    public CrsHelper getCrsHelper() {
        return this.crsHelper;
    }
}

