/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.coords;

import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.unidata.geoloc.ProjectionImpl;
import uk.ac.rdg.resc.ncwms.coords.LatLonCoordSys;
import uk.ac.rdg.resc.ncwms.coords.LonLatPosition;
import uk.ac.rdg.resc.ncwms.coords.OneDCoordAxis;
import uk.ac.rdg.resc.ncwms.coords.OneDCoordSys;
import uk.ac.rdg.resc.ncwms.coords.TwoDCoordSys;

public abstract class HorizontalCoordSys {
    private int xAxisSize;
    private int yAxisSize;

    protected HorizontalCoordSys() {
    }

    public static HorizontalCoordSys fromCoordSys(GridCoordSystem coordSys) {
        HorizontalCoordSys horizCoordSys;
        boolean isLatLon;
        ProjectionImpl proj = coordSys.getProjection();
        CoordinateAxis xAxis = coordSys.getXHorizAxis();
        CoordinateAxis yAxis = coordSys.getYHorizAxis();
        boolean bl = isLatLon = xAxis.getAxisType() == AxisType.Lon && yAxis.getAxisType() == AxisType.Lat;
        if (xAxis instanceof CoordinateAxis1D && yAxis instanceof CoordinateAxis1D) {
            OneDCoordAxis xAxis1D = OneDCoordAxis.create((CoordinateAxis1D)xAxis);
            OneDCoordAxis yAxis1D = OneDCoordAxis.create((CoordinateAxis1D)yAxis);
            horizCoordSys = isLatLon ? new LatLonCoordSys(xAxis1D, yAxis1D) : new OneDCoordSys(xAxis1D, yAxis1D, proj);
        } else if (xAxis instanceof CoordinateAxis2D && yAxis instanceof CoordinateAxis2D) {
            if (!isLatLon) {
                throw new UnsupportedOperationException("Can't create a HorizontalCoordSys from 2D coordinate axes that are not longitude and latitude.");
            }
            horizCoordSys = TwoDCoordSys.generate(coordSys);
        } else {
            throw new IllegalStateException("Inconsistent axis types");
        }
        horizCoordSys.xAxisSize = (int)xAxis.getSize();
        horizCoordSys.yAxisSize = (int)yAxis.getSize();
        return horizCoordSys;
    }

    public abstract int[] lonLatToGrid(LonLatPosition var1);

    public final LonLatPosition gridToLonLat(int[] gridCoords) {
        if (gridCoords == null) {
            return null;
        }
        if (gridCoords.length != 2) {
            throw new IllegalArgumentException("gridCoords must be of length 2");
        }
        return this.gridToLonLat(gridCoords[0], gridCoords[1]);
    }

    public abstract LonLatPosition gridToLonLat(int var1, int var2);

    public final int getXAxisSize() {
        return this.xAxisSize;
    }

    public final int getYAxisSize() {
        return this.yAxisSize;
    }
}

