/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.controller;

import uk.ac.rdg.resc.ncwms.controller.GetMapDataRequest;
import uk.ac.rdg.resc.ncwms.controller.RequestParams;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidPointException;
import uk.ac.rdg.resc.ncwms.exceptions.WmsException;

public class GetFeatureInfoDataRequest
extends GetMapDataRequest {
    private int pixelColumn;
    private int pixelRow;
    private int featureCount;

    public GetFeatureInfoDataRequest(RequestParams params, String version) throws WmsException {
        this.layers = params.getMandatoryString("query_layers").split(",");
        this.init(params, version);
        this.featureCount = params.getPositiveInt("feature_count", 1);
        this.pixelColumn = params.getMandatoryPositiveInt("i");
        if (this.pixelColumn > this.getWidth() - 1) {
            throw new InvalidPointException("i");
        }
        this.pixelRow = params.getMandatoryPositiveInt("j");
        if (this.pixelRow > this.getHeight() - 1) {
            throw new InvalidPointException("j");
        }
    }

    public int getPixelColumn() {
        return this.pixelColumn;
    }

    public int getPixelRow() {
        return this.pixelRow;
    }

    public int getFeatureCount() {
        return this.featureCount;
    }
}

