/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="SoilWaterBalance", author="Peter Krause, Christian Fischer", description="Calculates a simplified soil water balance for each HRU including a maximum infiltration limit")
public class SoilWaterBalanceWithTwoStorages
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute slope", unit="\u00b0", lowerBound=0.0, upperBound=90.0)
    public Attribute.Double slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area", unit="m\u00b2", lowerBound=0.0)
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU attribute maximum MPS", defaultValue="Infinity", unit="mm", lowerBound=0.0)
    public Attribute.Double maxMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU state var actual MPS", unit="mm", lowerBound=0.0)
    public Attribute.Double actMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU state var relative saturation of MPS", unit="-", lowerBound=0.0, upperBound=1.0)
    public Attribute.Double satMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU excess storage", unit="L", lowerBound=0.0)
    public Attribute.Double excStor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="infiltration capacity", defaultValue="Infinity", unit="mm", lowerBound=0.0)
    public Attribute.Double maxInf;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="direct runoff", unit="L", lowerBound=0.0)
    public Attribute.Double dirQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="groundwater recharge", unit="L", lowerBound=0.0)
    public Attribute.Double gwRecharge;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="total runoff", unit="L", lowerBound=0.0)
    public Attribute.Double totQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="potential ET", unit="L", lowerBound=0.0)
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="actual ET", unit="L", lowerBound=0.0)
    public Attribute.Double actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="precipitation", unit="L", lowerBound=0.0)
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="snow melt", unit="L", lowerBound=0.0)
    public Attribute.Double snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="lateral-vertical distribution coefficient", unit="-", lowerBound=0.0)
    public Attribute.Double latVertDist;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="lateral recession constant", unit="1/t", defaultValue="1.0", lowerBound=0.0)
    public Attribute.Double recConst;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ET reduction factor", unit="-", lowerBound=0.0, upperBound=1.0)
    public Attribute.Double linETRed;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum excStor", unit="mm", lowerBound=0.0, defaultValue="Infinity")
    public Attribute.Double maxExcStor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="infiltration excess flow", unit="mm", lowerBound=0.0)
    public Attribute.Double infExcStor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU attribute maximum percolation", unit="mm", lowerBound=0.0)
    public Attribute.Double maxPerc;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="PET adjustment factor", unit="-", lowerBound=0.0)
    public Attribute.Double petMult;

    protected double calculateMaxExcStorage() {
        return this.maxExcStor.getValue() * this.area.getValue();
    }

    protected double calculateMaxInfiltrationCapacity() {
        return this.maxInf.getValue() * this.area.getValue();
    }

    protected void calculatePotET() {
        this.potET.setValue(this.potET.getValue() * this.petMult.getValue());
    }

    protected void putInflowToSoil() {
        double deltaMPS;
        double actMPS = this.actMPS.getValue();
        double maxMPS = this.maxMPS.getValue();
        double infCap = this.calculateMaxInfiltrationCapacity();
        double infExcStor = this.infExcStor.getValue();
        double excStor = this.excStor.getValue();
        double inflow = this.precip.getValue() + this.snowMelt.getValue();
        if (inflow <= (deltaMPS = maxMPS - actMPS)) {
            if (inflow <= infCap) {
                actMPS += inflow;
                infCap = 0.0;
                inflow = 0.0;
            } else {
                actMPS += infCap;
                inflow -= infCap;
                infCap = 0.0;
                infExcStor = inflow;
                inflow = 0.0;
            }
        } else if (deltaMPS <= infCap) {
            actMPS = maxMPS;
            infCap -= deltaMPS;
            excStor = inflow -= deltaMPS;
            inflow = 0.0;
        } else {
            infExcStor = inflow -= infCap;
            inflow = 0.0;
            actMPS += infCap;
            infCap = 0.0;
        }
        this.actMPS.setValue(actMPS);
        this.satMPS.setValue(actMPS / maxMPS);
        this.infExcStor.setValue(infExcStor);
        this.excStor.setValue(excStor);
    }

    protected void takeETfromStorage(Attribute.Double storageParameter) {
        double actET = this.actET.getValue();
        double potET = this.potET.getValue();
        double storage = storageParameter.getValue();
        double deltaET = potET - actET;
        if (deltaET == 0.0) {
            return;
        }
        if (storage >= deltaET) {
            actET = potET;
            storage -= deltaET;
        } else {
            actET += storage;
            storage = 0.0;
        }
        this.potET.setValue(potET);
        this.actET.setValue(actET);
        storageParameter.setValue(storage);
    }

    protected void takeETfromMPS() {
        double actET = this.actET.getValue();
        double potET = this.potET.getValue();
        double actMPS = this.actMPS.getValue();
        double maxMPS = this.maxMPS.getValue();
        double deltaET = potET - actET;
        double linRed = this.linETRed.getValue();
        double reduceET = 1.0;
        if (actMPS < linRed * maxMPS) {
            reduceET = actMPS / (linRed * maxMPS);
        }
        if (actMPS >= (deltaET *= reduceET)) {
            actET += deltaET;
            actMPS -= deltaET;
            deltaET = 0.0;
        } else {
            actET += actMPS;
            actMPS = 0.0;
        }
        this.actET.setValue(actET);
        this.actMPS.setValue(actMPS);
    }

    protected void calculateRunoffComponents() {
        double excStor = this.excStor.getValue();
        double maxExcStor = this.calculateMaxExcStorage();
        double k_factor = this.recConst.getValue();
        double overlandFlow = this.infExcStor.getValue();
        double interflow = 0.0;
        double dirQ = 0.0;
        double gwRecharge = 0.0;
        double slope_weight = Math.tan(this.slope.getValue() * (Math.PI / 180)) * this.latVertDist.getValue();
        if (slope_weight > 1.0) {
            slope_weight = 1.0;
        }
        if ((excStor = excStor - (interflow = slope_weight * excStor * (1.0 / k_factor)) - (gwRecharge = (1.0 - slope_weight) * excStor * (1.0 / k_factor))) > maxExcStor) {
            dirQ = excStor - maxExcStor;
            excStor = maxExcStor;
        }
        double delta = 0.0;
        if (gwRecharge > this.maxPerc.getValue()) {
            delta = gwRecharge - this.maxPerc.getValue();
            interflow += delta;
            gwRecharge = this.maxPerc.getValue();
        }
        dirQ = dirQ + interflow + overlandFlow;
        this.excStor.setValue(excStor);
        this.gwRecharge.setValue(gwRecharge);
        this.dirQ.setValue(dirQ);
        this.totQ.setValue(dirQ + gwRecharge);
        this.infExcStor.setValue(0.0);
    }

    public void run() {
        this.calculatePotET();
        this.putInflowToSoil();
        this.takeETfromStorage(this.infExcStor);
        this.takeETfromStorage(this.excStor);
        this.takeETfromMPS();
        this.calculateRunoffComponents();
    }
}

