/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.Geometry;
import org.postgis.Polygon;
import org.postgresql.util.PGtokenizer;

public class MultiPolygon
extends Geometry {
    Polygon[] polygons;

    public MultiPolygon() {
        this.type = Geometry.MULTIPOLYGON;
    }

    public MultiPolygon(Polygon[] polygons) {
        this();
        this.polygons = polygons;
        this.dimension = polygons[0].dimension;
    }

    public MultiPolygon(String value) throws SQLException {
        this();
        value = value.trim();
        if (value.indexOf("MULTIPOLYGON") == 0) {
            PGtokenizer t = new PGtokenizer(PGtokenizer.removePara((String)value.substring(12).trim()), ',');
            int npolygons = t.getSize();
            this.polygons = new Polygon[npolygons];
            int p = 0;
            while (p < npolygons) {
                this.polygons[p] = new Polygon(t.getToken(p));
                ++p;
            }
        } else {
            throw new SQLException("postgis.multipolygongeometry");
        }
        this.dimension = this.polygons[0].dimension;
    }

    public String toString() {
        return "MULTIPOLYGON " + this.getValue();
    }

    public String getValue() {
        StringBuffer b = new StringBuffer("(");
        int p = 0;
        while (p < this.polygons.length) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.polygons[p].getValue());
            ++p;
        }
        b.append(")");
        return b.toString();
    }

    public int numPolygons() {
        return this.polygons.length;
    }

    public Polygon getPolygon(int idx) {
        if (idx >= 0 & idx < this.polygons.length) {
            return this.polygons[idx];
        }
        return null;
    }
}

