/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.IOException;
import org.unijena.j2k.physicalCalculations.HourlySolarRadiationCalculationMethods;

@JAMSComponentDescription(title="CalcHourlyMaximumSunshine", author="Peter Krause", description="Calculates maximum possible sunshine duration for hours per day")
public class CalcHourlyMaximumSunshine
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="maximum sunshine [0|1]")
    public Attribute.Double maxSunshine;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="extraterrestic radiation [MJ/m\u00b2]")
    public Attribute.Double actExtRad;

    public void init() throws Attribute.Entity.NoSuchAttributeException, IOException {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        double maximumSunshine = HourlySolarRadiationCalculationMethods.calc_HourlyMaxSunshine(this.actExtRad.getValue());
        this.maxSunshine.setValue(maximumSunshine);
    }

    public void cleanup() throws Attribute.Entity.NoSuchAttributeException, IOException {
    }
}

