/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.tools.FileTools;
import java.io.File;
import java.util.List;
import org.unijena.j2k.J2KFunctions;

@JAMSComponentDescription(title="EntityParaReader", author="Sven Kralisch & Christian Fischer", description="This component reads an ASCII files containing data of JAMS entities and creates a collection accordingly. ", date="2017-11-23", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class EntityParaReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity parameter file name")
    public Attribute.String entityFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of entity objects")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute containing the entity identifiers", defaultValue="ID")
    public Attribute.String entityIDAttribute;
    List<Attribute.Entity> entityList;

    public void init() {
        this.getModel().getRuntime().println("Reading model entities...", 2);
        String fileName = this.entityFileName.getValue();
        if (new File(fileName).exists()) {
            fileName = this.entityFileName.getValue();
        } else if (this.getModel().getWorkspaceDirectory() != null) {
            fileName = FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.entityFileName.getValue());
        }
        if (!new File(fileName).exists()) {
            this.getModel().getRuntime().sendErrorMsg("Couldn't read entity file " + fileName + "!\nIf you are not using an absolute path, please ensure you have defined a workspace directory!");
        }
        this.entityList = J2KFunctions.readParas(fileName, this.getModel());
        for (Attribute.Entity e : this.entityList) {
            try {
                e.setId((long)e.getDouble(this.entityIDAttribute.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"ID\" while reading J2K entity parameter file (" + this.entityFileName.getValue() + ")!");
            }
        }
        this.entities.setEntities(this.entityList);
    }
}

