/*
 * Decompiled with CFR 0.152.
 */
package javax.units;

import javax.units.BaseUnit;
import javax.units.Converter;
import javax.units.DerivedUnit;
import javax.units.ProductUnit;
import javax.units.Unit;

public final class AlternateUnit
extends DerivedUnit {
    private final Unit _baseUnits;

    private AlternateUnit(String string, Unit unit) {
        super(string);
        this._baseUnits = unit;
    }

    static AlternateUnit getInstance(String string, Unit unit) {
        AlternateUnit alternateUnit = new AlternateUnit(string, AlternateUnit.getBaseUnits(unit));
        return (AlternateUnit)AlternateUnit.getInstance(alternateUnit);
    }

    private static Unit getBaseUnits(Unit unit) {
        if (unit instanceof BaseUnit) {
            return unit;
        }
        if (unit instanceof AlternateUnit) {
            return ((AlternateUnit)unit)._baseUnits;
        }
        if (unit instanceof ProductUnit) {
            ProductUnit productUnit = (ProductUnit)unit;
            Unit unit2 = ONE;
            for (int i = 0; i < productUnit.size(); ++i) {
                ProductUnit.Element element = productUnit.get(i);
                Unit unit3 = AlternateUnit.getBaseUnits(element.getUnit());
                unit3 = unit3.pow(element.getPow());
                unit3 = unit3.root(element.getRoot());
                unit2 = unit2.multiply(unit3);
            }
            return unit2;
        }
        throw new UnsupportedOperationException("Unit: " + unit + " is not a system unit");
    }

    public final String getSymbol() {
        return this._symbol;
    }

    public Unit getSystemUnit() {
        return this;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof AlternateUnit && ((AlternateUnit)object)._baseUnits == this._baseUnits && ((AlternateUnit)object)._symbol.equals(this._symbol);
    }

    int calculateHashCode() {
        return this._symbol.hashCode();
    }

    Unit getCtxDimension() {
        return this._baseUnits.getCtxDimension();
    }

    Converter getCtxToDimension() {
        return this._baseUnits.getCtxToDimension();
    }
}

