/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.spi.ImageConverter;
import org.apache.xmlgraphics.image.loader.spi.ImageLoaderFactory;
import org.apache.xmlgraphics.image.loader.spi.ImagePreloader;
import org.apache.xmlgraphics.util.Service;

public class ImageImplRegistry {
    protected static Log log = LogFactory.getLog((Class)ImageImplRegistry.class);
    private List preloaders = new ArrayList();
    private int lastPreloaderIdentifier;
    private int lastPreloaderSort;
    private Map loaders = new HashMap();
    private List converters = new ArrayList();
    private int converterModifications;
    private static ImageImplRegistry defaultInstance;

    public ImageImplRegistry() {
        this.discoverClasspathImplementations();
    }

    public static ImageImplRegistry getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new ImageImplRegistry();
        }
        return defaultInstance;
    }

    public void discoverClasspathImplementations() {
        Iterator iter = Service.providers(ImagePreloader.class, true);
        while (iter.hasNext()) {
            this.registerPreloader((ImagePreloader)iter.next());
        }
        iter = Service.providers(ImageLoaderFactory.class, true);
        while (iter.hasNext()) {
            this.registerLoaderFactory((ImageLoaderFactory)iter.next());
        }
        iter = Service.providers(ImageConverter.class, true);
        while (iter.hasNext()) {
            this.registerConverter((ImageConverter)iter.next());
        }
    }

    public void registerPreloader(ImagePreloader preloader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered " + preloader.getClass().getName() + " with priority " + preloader.getPriority()));
        }
        this.preloaders.add(this.newPreloaderHolder(preloader));
    }

    private synchronized PreloaderHolder newPreloaderHolder(ImagePreloader preloader) {
        PreloaderHolder holder = new PreloaderHolder();
        holder.preloader = preloader;
        holder.identifier = ++this.lastPreloaderIdentifier;
        return holder;
    }

    private synchronized void sortPreloaders() {
        if (this.lastPreloaderIdentifier != this.lastPreloaderSort) {
            Collections.sort(this.preloaders, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int p2;
                    PreloaderHolder h1 = (PreloaderHolder)o1;
                    PreloaderHolder h2 = (PreloaderHolder)o2;
                    int p1 = h1.preloader.getPriority();
                    int diff = p1 - (p2 = h2.preloader.getPriority());
                    if (diff != 0) {
                        return diff;
                    }
                    diff = h1.identifier - h2.identifier;
                    return diff;
                }
            });
            this.lastPreloaderSort = this.lastPreloaderIdentifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLoaderFactory(ImageLoaderFactory loaderFactory) {
        if (!loaderFactory.isAvailable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ImageLoaderFactory reports not available: " + loaderFactory.getClass().getName()));
            }
            return;
        }
        String[] mimes = loaderFactory.getSupportedMIMETypes();
        int ci = mimes.length;
        for (int i = 0; i < ci; ++i) {
            String mime = mimes[i];
            Map map = this.loaders;
            synchronized (map) {
                HashMap<ImageFlavor, ArrayList<ImageLoaderFactory>> flavorMap = (HashMap<ImageFlavor, ArrayList<ImageLoaderFactory>>)this.loaders.get(mime);
                if (flavorMap == null) {
                    flavorMap = new HashMap<ImageFlavor, ArrayList<ImageLoaderFactory>>();
                    this.loaders.put(mime, flavorMap);
                }
                ImageFlavor[] flavors = loaderFactory.getSupportedFlavors(mime);
                int cj = flavors.length;
                for (int j = 0; j < cj; ++j) {
                    ImageFlavor flavor = flavors[j];
                    ArrayList<ImageLoaderFactory> factoryList = (ArrayList<ImageLoaderFactory>)flavorMap.get(flavor);
                    if (factoryList == null) {
                        factoryList = new ArrayList<ImageLoaderFactory>();
                        flavorMap.put(flavor, factoryList);
                    }
                    factoryList.add(loaderFactory);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Registered " + loaderFactory.getClass().getName() + ": MIME = " + mime + ", Flavor = " + flavor));
                }
                continue;
            }
        }
    }

    public Collection getImageConverters() {
        return Collections.unmodifiableList(this.converters);
    }

    public int getImageConverterModifications() {
        return this.converterModifications;
    }

    public void registerConverter(ImageConverter converter) {
        this.converters.add(converter);
        ++this.converterModifications;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered: " + converter.getClass().getName()));
        }
    }

    public Iterator getPreloaderIterator() {
        this.sortPreloaders();
        final Iterator iter = this.preloaders.iterator();
        return new Iterator(){

            public boolean hasNext() {
                return iter.hasNext();
            }

            public Object next() {
                Object obj = iter.next();
                if (obj != null) {
                    return ((PreloaderHolder)obj).preloader;
                }
                return null;
            }

            public void remove() {
                iter.remove();
            }
        };
    }

    public ImageLoaderFactory getImageLoaderFactory(ImageInfo imageInfo, ImageFlavor flavor) {
        List factoryList;
        String mime = imageInfo.getMimeType();
        Map flavorMap = (Map)this.loaders.get(mime);
        if (flavorMap != null && (factoryList = (List)flavorMap.get(flavor)) != null && factoryList.size() > 0) {
            Iterator iter = factoryList.iterator();
            int bestPenalty = Integer.MAX_VALUE;
            ImageLoaderFactory bestFactory = null;
            while (iter.hasNext()) {
                int penalty;
                ImageLoaderFactory factory = (ImageLoaderFactory)iter.next();
                if (!factory.isSupported(imageInfo) || (penalty = factory.getUsagePenalty(mime, flavor)) >= bestPenalty) continue;
                bestPenalty = penalty;
                bestFactory = factory;
            }
            return bestFactory;
        }
        return null;
    }

    public ImageLoaderFactory[] getImageLoaderFactories(ImageInfo imageInfo, ImageFlavor flavor) {
        List factoryList;
        String mime = imageInfo.getMimeType();
        TreeSet<ImageLoaderFactory> matches = new TreeSet<ImageLoaderFactory>(new ImageLoaderFactoryComparator(mime, flavor));
        Map flavorMap = (Map)this.loaders.get(mime);
        if (flavorMap != null && (factoryList = (List)flavorMap.get(flavor)) != null && factoryList.size() > 0) {
            Iterator iter = factoryList.iterator();
            while (iter.hasNext()) {
                ImageLoaderFactory factory = (ImageLoaderFactory)iter.next();
                if (!factory.isSupported(imageInfo)) continue;
                matches.add(factory);
            }
        }
        if (matches.size() == 0) {
            return null;
        }
        return matches.toArray(new ImageLoaderFactory[matches.size()]);
    }

    public ImageLoaderFactory[] getImageLoaderFactories(String mime) {
        Map flavorMap = (Map)this.loaders.get(mime);
        if (flavorMap != null) {
            HashSet factories = new HashSet();
            Iterator iter = flavorMap.values().iterator();
            while (iter.hasNext()) {
                List factoryList = (List)iter.next();
                factories.addAll(factoryList);
            }
            int factoryCount = factories.size();
            if (factoryCount > 0) {
                return factories.toArray(new ImageLoaderFactory[factoryCount]);
            }
        }
        return null;
    }

    private static class ImageLoaderFactoryComparator
    implements Comparator {
        private String mime;
        private ImageFlavor targetFlavor;

        public ImageLoaderFactoryComparator(String mime, ImageFlavor targetFlavor) {
            this.mime = mime;
            this.targetFlavor = targetFlavor;
        }

        public int compare(Object o1, Object o2) {
            ImageLoaderFactory f1 = (ImageLoaderFactory)o1;
            ImageLoaderFactory f2 = (ImageLoaderFactory)o2;
            return f1.getUsagePenalty(this.mime, this.targetFlavor) - f2.getUsagePenalty(this.mime, this.targetFlavor);
        }
    }

    private class PreloaderHolder {
        private ImagePreloader preloader;
        private int identifier;

        private PreloaderHolder() {
        }

        public String toString() {
            return this.preloader + " " + this.identifier;
        }
    }
}

