/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.RandomGroupsData;
import nom.tam.util.ArrayFuncs;

public class RandomGroupsHDU
extends BasicHDU {
    Object dataArray;

    public RandomGroupsHDU(Header header, Data data) {
        this.myHeader = header;
        this.myData = data;
    }

    protected boolean canBePrimary() {
        return true;
    }

    protected void setPrimaryHDU(boolean bl) {
        try {
            super.setPrimaryHDU(bl);
        }
        catch (FitsException fitsException) {
            System.err.println("Unreachable catch in RandomGroupsHDU");
        }
        if (bl) {
            this.myHeader.setSimple(true);
        } else {
            this.myHeader.setXtension("IMAGE");
        }
    }

    static Header manufactureHeader(Data data) throws FitsException {
        if (data == null) {
            throw new FitsException("Attempt to create null Random Groups data");
        }
        Header header = new Header();
        data.fillHeader(header);
        return header;
    }

    public static boolean isHeader(Header header) {
        if (header.getBooleanValue("SIMPLE")) {
            return header.getBooleanValue("GROUPS");
        }
        String string = header.getStringValue("XTENSION");
        if (string.trim().equals("IMAGE")) {
            return header.getBooleanValue("GROUPS");
        }
        return false;
    }

    public boolean isHeader() {
        return RandomGroupsHDU.isHeader(this.myHeader);
    }

    public static boolean isData(Object object) {
        String string;
        Object[][] objectArray;
        return object instanceof Object[][] && (objectArray = (Object[][])object).length > 0 && objectArray[0].length == 2 && ArrayFuncs.getBaseClass(objectArray[0][0]) == ArrayFuncs.getBaseClass(objectArray[0][1]) && ((string = objectArray[0][0].getClass().getName()).length() == 2 && string.charAt(1) != 'Z' || string.charAt(1) != 'C');
    }

    public Data manufactureData() throws FitsException {
        return RandomGroupsHDU.manufactureData(this.myHeader);
    }

    public static Data manufactureData(Header header) throws FitsException {
        int n = header.getIntValue("GCOUNT", -1);
        int n2 = header.getIntValue("PCOUNT", -1);
        if (!header.getBooleanValue("GROUPS") || header.getIntValue("NAXIS1", -1) != 0 || n < 0 || n2 < 0 || header.getIntValue("NAXIS") < 2) {
            throw new FitsException("Invalid Random Groups Parameters");
        }
        Object object = n > 0 ? new Object[n][2] : new Object[][]{};
        Object[] objectArray = RandomGroupsHDU.generateSampleRow(header);
        int n3 = 0;
        while (n3 < n) {
            ((Object[][])object)[n3][0] = ((Object[])ArrayFuncs.deepClone(objectArray))[0];
            object[n3][1] = ((Object[])ArrayFuncs.deepClone(objectArray))[1];
            ++n3;
        }
        return new RandomGroupsData((Object[][])object);
    }

    static Object[] generateSampleRow(Header header) throws FitsException {
        Class<Number> clazz;
        int n = header.getIntValue("NAXIS", 0) - 1;
        int[] nArray = new int[n];
        int n2 = header.getIntValue("BITPIX", 0);
        switch (n2) {
            case 8: {
                clazz = Byte.TYPE;
                break;
            }
            case 16: {
                clazz = Short.TYPE;
                break;
            }
            case 32: {
                clazz = Integer.TYPE;
                break;
            }
            case 64: {
                clazz = Long.TYPE;
                break;
            }
            case -32: {
                clazz = Float.TYPE;
                break;
            }
            case -64: {
                clazz = Double.TYPE;
                break;
            }
            default: {
                throw new FitsException("Invalid BITPIX:" + n2);
            }
        }
        int n3 = 0;
        while (n3 < n) {
            long l = header.getIntValue("NAXIS" + (n3 + 2), 0);
            if (l < 0L) {
                throw new FitsException("Invalid array dimension:" + l);
            }
            nArray[n - n3 - 1] = (int)l;
            ++n3;
        }
        Object[] objectArray = new Object[]{ArrayFuncs.newInstance(clazz, header.getIntValue("PCOUNT")), ArrayFuncs.newInstance(clazz, nArray)};
        return objectArray;
    }

    public static Data encapsulate(Object object) throws FitsException {
        if (object instanceof Object[][]) {
            return new RandomGroupsData((Object[][])object);
        }
        throw new FitsException("Attempt to encapsulate invalid data in Random Group");
    }

    public void info() {
        System.out.println("Random Groups HDU");
        if (this.myHeader != null) {
            System.out.println("   HeaderInformation:");
            System.out.println("     Ngroups:" + this.myHeader.getIntValue("GCOUNT"));
            System.out.println("     Npar:   " + this.myHeader.getIntValue("PCOUNT"));
            System.out.println("     BITPIX: " + this.myHeader.getIntValue("BITPIX"));
            System.out.println("     NAXIS:  " + this.myHeader.getIntValue("NAXIS"));
            int n = 0;
            while (n < this.myHeader.getIntValue("NAXIS")) {
                System.out.println("      NAXIS" + (n + 1) + "= " + this.myHeader.getIntValue("NAXIS" + (n + 1)));
                ++n;
            }
        } else {
            System.out.println("    No Header Information");
        }
        Object[][] objectArray = null;
        if (this.myData != null) {
            try {
                objectArray = (Object[][])this.myData.getData();
            }
            catch (FitsException fitsException) {
                objectArray = null;
            }
        }
        if (objectArray == null || objectArray.length < 1 || objectArray[0].length != 2) {
            System.out.println("    Invalid/unreadable data");
        } else {
            System.out.println("    Number of groups:" + objectArray.length);
            System.out.println("    Parameters: " + ArrayFuncs.arrayDescription(objectArray[0][0]));
            System.out.println("    Data:" + ArrayFuncs.arrayDescription(objectArray[0][1]));
        }
    }
}

