/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xml.type.util;

import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.eclipse.emf.ecore.xml.type.internal.QName;
import org.eclipse.emf.ecore.xml.type.internal.RegEx;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;
import org.eclipse.emf.ecore.xml.type.internal.XMLDuration;

public final class XMLTypeUtil {
    public static final int EQUALS = 0;
    public static final int LESS_THAN = -1;
    public static final int GREATER_THAN = 1;
    public static final int INDETERMINATE = 2;
    private static final CharArrayThreadLocal VALUE = new CharArrayThreadLocal();

    public static int compareCalendar(Object calendar1, Object calendar2) {
        return XMLCalendar.compare((XMLCalendar)calendar1, (XMLCalendar)calendar2);
    }

    public static int compareDuration(Object duration1, Object duration2) {
        return XMLDuration.compare((XMLDuration)duration1, (XMLDuration)duration2);
    }

    public static boolean isSpace(char value) {
        return DataValue.XMLChar.isSpace(value);
    }

    public static String normalize(String value, boolean collapse) {
        if (value == null) {
            return null;
        }
        int length = value.length();
        if (length == 0) {
            return "";
        }
        char[] valueArray = VALUE.get(length);
        value.getChars(0, length, valueArray, 0);
        StringBuffer buffer = null;
        boolean skipSpace = collapse;
        int i = 0;
        int offset = 0;
        while (i < length) {
            char c = valueArray[i];
            if (XMLTypeUtil.isSpace(c)) {
                if (skipSpace) {
                    if (buffer == null) {
                        buffer = new StringBuffer(value);
                    }
                    buffer.deleteCharAt(i - offset++);
                } else {
                    skipSpace = collapse;
                    if (c != ' ') {
                        if (buffer == null) {
                            buffer = new StringBuffer(value);
                        }
                        buffer.setCharAt(i - offset, ' ');
                    }
                }
            } else {
                skipSpace = false;
            }
            ++i;
        }
        if (skipSpace) {
            if (buffer == null) {
                return value.substring(0, length - 1);
            }
            length = buffer.length();
            if (length > 0) {
                return buffer.substring(0, length - 1);
            }
            return "";
        }
        if (buffer == null) {
            return value;
        }
        return buffer.toString();
    }

    public static EValidator.PatternMatcher createPatternMatcher(String pattern) {
        return new PatternMatcherImpl(pattern);
    }

    public static Object createQName(String namespaceUri, String localPart, String prefix) {
        return new QName(namespaceUri, localPart, prefix);
    }

    public static void setQNameValues(Object qname, String namespaceUri, String localPart, String prefix) {
        QName qn = (QName)qname;
        qn.setLocalPart(localPart);
        qn.setNamespaceURI(namespaceUri);
        qn.setPrefix(prefix);
    }

    public static String getQNameNamespaceURI(Object qname) {
        return ((QName)qname).getNamespaceURI();
    }

    public static String getQNameLocalPart(Object qname) {
        return ((QName)qname).getLocalPart();
    }

    public static String getQNamePrefix(Object qname) {
        return ((QName)qname).getPrefix();
    }

    private static class CharArrayThreadLocal
    extends ThreadLocal {
        private Thread cachedThread;
        private char[] cachedResult;

        private CharArrayThreadLocal() {
        }

        public final char[] get(int capacity) {
            Thread currentThread = Thread.currentThread();
            char[] result = this.cachedResult;
            if (this.cachedThread != currentThread) {
                this.cachedThread = currentThread;
                result = (char[])this.get();
            }
            if (result.length < capacity) {
                result = new char[capacity];
                this.set(result);
            }
            this.cachedResult = result;
            return result;
        }

        protected Object initialValue() {
            return new char[20];
        }
    }

    private static class PatternMatcherImpl
    implements EValidator.PatternMatcher {
        protected RegEx.RegularExpression regularExpression;

        public PatternMatcherImpl(String pattern) {
            this.regularExpression = new RegEx.RegularExpression(pattern, "X");
        }

        public boolean matches(String value) {
            return this.regularExpression.matches(value);
        }

        public String toString() {
            return this.regularExpression.getPattern();
        }
    }
}

