/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.plugins.waterml2;

import jams.workspace.plugins.waterml2.GMLLocation;
import jams.workspace.plugins.waterml2.OM2Metadata;
import jams.workspace.plugins.waterml2.Result;
import jams.workspace.plugins.waterml2.WaterML2Exception;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimeseriesObservation {
    private OM2Metadata metadata;
    private Result result;
    private String id;
    private String name;
    private GMLLocation location;

    public TimeseriesObservation(Node node_TimeseriesObservation) throws WaterML2Exception {
        Element e = (Element)node_TimeseriesObservation;
        this.id = e.getAttribute("gml:id");
        NodeList list = node_TimeseriesObservation.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeName().matches(".*type")) continue;
            if (node.getNodeName().matches(".*metadata")) {
                this.setMetadata(new OM2Metadata(node));
                continue;
            }
            if (node.getNodeName().matches(".*relatedObservation") || node.getNodeName().matches(".*phenomenonTime") || node.getNodeName().matches(".*resultTime") || node.getNodeName().matches(".*validTime") || node.getNodeName().matches(".*procedure") || node.getNodeName().matches(".*parameter") || node.getNodeName().matches(".*observedProperty") || node.getNodeName().matches(".*featureOfInterest") || node.getNodeName().matches(".*resultQuality")) continue;
            if (node.getNodeName().matches(".*result")) {
                this.setResult(new Result(node));
                continue;
            }
            if (node.getNodeName().matches(".*location")) {
                this.location = new GMLLocation(node);
                continue;
            }
            if (!node.getNodeName().matches(".*name") || node.getFirstChild() == null) continue;
            this.name = node.getFirstChild().getNodeValue();
        }
    }

    public GMLLocation getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Result getResult() {
        return this.result;
    }

    private void setResult(Result result) {
        this.result = result;
    }

    public OM2Metadata getMetadata() {
        return this.metadata;
    }

    private void setMetadata(OM2Metadata metadata) {
        this.metadata = metadata;
    }
}

