/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.plugins.waterml2;

import jams.workspace.plugins.waterml2.WaterML2Exception;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GMLPoint {
    double x;
    double y;
    double h;
    int dimension = 0;

    public GMLPoint(Node nodePoint) throws WaterML2Exception {
        Element elem = (Element)nodePoint;
        String srsName = elem.getAttribute("srsName");
        String dim = elem.getAttribute("srsDimension");
        try {
            this.dimension = Integer.parseInt(dim);
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            throw new WaterML2Exception("error: srs dimension in wrong number format:" + dim);
        }
        NodeList list = nodePoint.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!node.getNodeName().matches(".*pos") || node.getFirstChild() == null) continue;
            String pos = node.getFirstChild().getNodeValue();
            StringTokenizer tok = new StringTokenizer(pos, " ");
            if (tok.countTokens() != this.dimension) {
                throw new WaterML2Exception("error: wrong number of dimensions:" + pos);
            }
            try {
                this.x = Double.parseDouble(tok.nextToken());
                this.y = Double.parseDouble(tok.nextToken());
                this.h = Double.parseDouble(tok.nextToken());
                continue;
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                throw new WaterML2Exception("error: location in wrong number format:" + pos);
            }
        }
    }
}

