/*
 * Decompiled with CFR 0.152.
 */
package jams.components.machineLearning.kernels;

import Jama.Matrix;
import jams.components.machineLearning.kernels.MeanModell;

public class QuadraticMeanModell
extends MeanModell {
    double average;

    public QuadraticMeanModell(int inputSize) {
        this.inputSize = inputSize;
        this.parameterCount = 2 * inputSize;
        this.beta = new double[this.parameterCount];
    }

    @Override
    public String[] getMeanModelParameterNames() {
        int i;
        this.meanModelParameterNames = new String[2 * this.inputSize];
        for (i = 0; i < this.inputSize; ++i) {
            this.meanModelParameterNames[i] = "linRegCoeff_" + i;
        }
        for (i = 0; i < this.inputSize; ++i) {
            this.meanModelParameterNames[i + this.inputSize] = "quadRegCoeff_" + i;
        }
        return this.meanModelParameterNames;
    }

    @Override
    public Matrix Transform(double[][] data, double[] result) {
        int i;
        double sum = 0.0;
        this.average = 0.0;
        Matrix transformed = new Matrix(result.length, 1);
        for (i = 0; i < data.length; ++i) {
            sum = 0.0;
            for (int j = 0; j < this.inputSize; ++j) {
                sum += this.beta[j] * data[i][j] + this.beta[j + this.inputSize] * data[i][j] * data[i][j];
            }
            transformed.set(i, 0, result[i] - sum);
            this.average += result[i] - sum;
        }
        this.average /= (double)data.length;
        for (i = 0; i < data.length; ++i) {
            transformed.set(i, 0, transformed.get(i, 0) - this.average);
        }
        return transformed;
    }

    @Override
    public double[] ReTransform(double[][] data, Matrix prediction) {
        double sum = 0.0;
        double[] transformed = new double[prediction.getRowDimension()];
        for (int i = 0; i < data.length; ++i) {
            sum = 0.0;
            for (int j = 0; j < this.inputSize; ++j) {
                sum += this.beta[j] * data[i][j] + this.beta[j + this.inputSize] * data[i][j] * data[i][j];
            }
            transformed[i] = prediction.get(i, 0) + sum + this.average;
        }
        return transformed;
    }
}

