/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import com.vividsolutions.jts.algorithm.CentroidArea;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.AreaFunction;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

@JAMSComponentDescription(title="ShapeEntityReader", author="Sven Kralisch", description="Reads a shape file and creates a list of JAMS entities containing an entity for each feature. An attribute name must be provided in order to identify the id field used in the shape file")
public class ShapeEntityReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the shape file")
    public Attribute.String shapeFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of identifying attribute in shape file")
    public Attribute.String idName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the area attribute to be created", defaultValue="area")
    public Attribute.String areaAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the x attribute to be created", defaultValue="x")
    public Attribute.String xAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the y attribute to be created", defaultValue="y")
    public Attribute.String yAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Entity collection to be created")
    public Attribute.EntityCollection entities;

    public void init() {
        System.out.println("ShapeEntityReader.init. shape-file name " + this.shapeFileName);
        System.out.println("ShapeEntityReader.init. shape-file id " + this.idName);
        String workSpaceDirectory = this.getModel().getWorkspaceDirectory().getPath();
        String fileName = this.shapeFileName.getValue();
        boolean isCompleteFileName = false;
        if (fileName.indexOf(":") > -1) {
            isCompleteFileName = true;
        }
        if (!isCompleteFileName) {
            fileName = workSpaceDirectory + File.separator + fileName;
        }
        try {
            URL shapeUrl = new File(fileName).toURI().toURL();
            System.out.println("ShapeEntityReader.init. try to get shape-file from " + shapeUrl.toString());
            ShapefileDataStore store = new ShapefileDataStore(shapeUrl);
            FeatureIterator featureIterator = store.getFeatureSource().getFeatures().features();
            List atts = ((SimpleFeatureType)store.getFeatureSource().getSchema()).getAttributeDescriptors();
            int idAttributeIndex = -1;
            for (int i = 0; i < atts.size(); ++i) {
                if (!((AttributeDescriptor)atts.get(i)).getName().toString().equals(this.idName.getValue()) || ((AttributeDescriptor)atts.get(i)).getType().getBinding() != Long.class && ((AttributeDescriptor)atts.get(i)).getType().getBinding() != Integer.class) continue;
                idAttributeIndex = i;
            }
            ArrayList<Attribute.Entity> entityList = new ArrayList<Attribute.Entity>();
            while (featureIterator.hasNext()) {
                SimpleFeature f = (SimpleFeature)featureIterator.next();
                Attribute.Entity e = this.getModel().getRuntime().getDataFactory().createEntity();
                for (int i = 0; i < atts.size(); ++i) {
                    e.setObject(((AttributeDescriptor)atts.get(i)).getName().toString(), (Object)this.getModel().getRuntime().getDataFactory().createInstance(f.getAttribute(i)));
                }
                Geometry geom = (Geometry)f.getDefaultGeometry();
                AreaFunction af = new AreaFunction();
                e.setDouble(this.areaAttribute.getValue(), af.getArea(geom));
                CentroidArea c2d = new CentroidArea();
                c2d.add(geom);
                Coordinate coord = c2d.getCentroid();
                e.setDouble(this.xAttribute.getValue(), coord.x);
                e.setDouble(this.yAttribute.getValue(), coord.y);
                if (idAttributeIndex != -1) {
                    try {
                        long id = Long.parseLong(f.getAttribute(idAttributeIndex).toString());
                        e.setId(id);
                    }
                    catch (NumberFormatException nfe) {
                        this.getModel().getRuntime().sendErrorMsg("Could not parse " + f.getAttribute(idAttributeIndex) + " as long value!");
                    }
                }
                entityList.add(e);
            }
            this.entities.setEntities(entityList);
        }
        catch (IOException ex) {
            this.getModel().getRuntime().sendErrorMsg("An error occured while trying to load entities from " + new File(fileName).getAbsolutePath() + " (" + ex.getMessage() + ")");
        }
    }
}

