/*
 * Decompiled with CFR 0.152.
 */
package jams.components.interpolation;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.JAMSDataFactory;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jgrasstools.gears.utils.math.matrixes.ColumnVector;
import org.jgrasstools.gears.utils.math.matrixes.LinearSystem;
import org.jgrasstools.gears.utils.math.matrixes.MatrixException;

public class RegionalisationLocalKriging
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of data values for current time step")
    public Attribute.DoubleArray dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Regression coefficients")
    public Attribute.DoubleArray regCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="use only stations for elevation correction", defaultValue="false")
    public Attribute.Boolean localElevationCorrection;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station x coordinates")
    public Attribute.DoubleArray statX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station y coordinates")
    public Attribute.DoubleArray statY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station elevations")
    public Attribute.DoubleArray statElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Array of station's weights")
    public Attribute.DoubleArray statWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Array position of weights")
    public Attribute.IntegerArray statOrder;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="regionalised data value")
    public Attribute.Double dataValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Attribute name elevation")
    public Attribute.Double entityElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Number of neighbor stations", defaultValue="3")
    public Attribute.Integer nNs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Apply elevation correction to measured data")
    public Attribute.Boolean elevationCorrection;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Minimum r\u00b2 value for elevation correction application")
    public Attribute.Double rsqThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible minimum value for data set", defaultValue="-Infinity")
    public Attribute.Double fixedMinimum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible maximum value for data set", defaultValue="Infinity")
    public Attribute.Double fixedMaximum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity x-coordinate")
    public Attribute.Double entityX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity y-coordinate")
    public Attribute.Double entityY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calculation with geographical coordinates lat, long", defaultValue="false")
    public Attribute.Boolean latLong;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Type of semivariogram: Spherical Model (0), Exponential Model (1), Gaussian Model (2), Sillian Model (3)", defaultValue="0")
    public Attribute.Integer pSemivariogramType;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Value of nugget")
    public Attribute.Double pNug;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Value of range")
    public Attribute.Double pA;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Value of sill")
    public Attribute.Double pS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The interpolation mode (0 = interpolate on irregular grid, 1 = interpolate on regular grid)", defaultValue="0")
    public Attribute.Integer pMode;
    Projection proj = null;
    private double[] data;
    private double[] elev;
    private double[] weights;
    private double[] dist;
    int n = 0;
    int nNS = 0;
    boolean invalidDatasetReported = false;
    boolean entityIsStation;
    int counter = 0;

    public void init() {
        boolean isLatLon = this.latLong != null && this.latLong.getValue();
        this.proj = isLatLon ? Projection.LATLON : Projection.ANY;
        this.n = this.statX.getValue().length;
        this.nNS = Math.min(this.nNs.getValue(), this.statX.getValue().length);
        this.dist = new double[this.n];
        this.data = new double[this.nNS];
        this.elev = new double[this.nNS];
        this.weights = new double[this.nNS + 1];
    }

    private double rad(double decDeg) {
        return decDeg * Math.PI / 180.0;
    }

    public void calcDistances(double entityX, double entityY, double[] statX, double[] statY) {
        double R = 6378137.0;
        if (this.proj == Projection.ANY) {
            for (int s = 0; s < statX.length; ++s) {
                double x = entityX - statX[s];
                double y = entityY - statY[s];
                this.dist[s] = Math.sqrt(x * x + y * y);
            }
        } else {
            for (int s = 0; s < statX.length; ++s) {
                this.dist[s] = 6378137.0 * Math.acos(Math.sin(this.rad(entityY)) * Math.sin(this.rad(statY[s])) + Math.cos(this.rad(entityY)) * Math.cos(this.rad(statY[s])) * Math.cos(this.rad(statX[s]) - this.rad(entityX)));
                this.dist[s] = Math.abs(Math.pow(this.dist[s], 2.0));
            }
        }
    }

    private int minIndex(double[] v) {
        double min = Double.POSITIVE_INFINITY;
        int p = 0;
        for (int i = 0; i < v.length; ++i) {
            if (!(v[i] < min)) continue;
            min = v[i];
            p = i;
        }
        return p;
    }

    public double[][] fillStationKrigingArrays(double entityX, double entityY, double entityZ, double[] statX, double[] statY, double[] statZ, int nn, int[] neighborStations) {
        double[] xStation = new double[nn + 1];
        double[] yStation = new double[nn + 1];
        double[] zStation = new double[nn + 1];
        for (int i = 0; i < nn; ++i) {
            int t = neighborStations[i];
            xStation[i] = statX[t];
            yStation[i] = statY[t];
            zStation[i] = statZ[t];
        }
        xStation[nn] = entityX;
        yStation[nn] = entityY;
        zStation[nn] = entityZ;
        double[][] filledArrays = new double[][]{xStation, yStation, zStation};
        return filledArrays;
    }

    private double[][] covMatrixCalculating(double[] x, double[] y, double[] z, int nn) {
        double[][] ap = new double[nn + 1][nn + 1];
        for (int j = 0; j < nn; ++j) {
            for (int i = 0; i < nn; ++i) {
                double tmp;
                double rx = x[i] - x[j];
                double ry = y[i] - y[j];
                double rz = 0.0;
                if (this.pMode.getValue() == 0) {
                    rz = z[i] - z[j];
                }
                ap[j][i] = tmp = this.variogram(this.pNug.getValue(), this.pA.getValue(), this.pS.getValue(), rx, ry, rz);
                ap[i][j] = tmp;
            }
        }
        for (int i = 0; i < nn; ++i) {
            ap[i][nn] = 1.0;
            ap[nn][i] = 1.0;
        }
        ap[nn][nn] = 0.0;
        return ap;
    }

    private double[] knownTermsCalculation(double[] x, double[] y, double[] z, int nn) {
        double[] gamma = new double[nn + 1];
        for (int i = 0; i < nn; ++i) {
            double rx = x[i] - x[nn];
            double ry = y[i] - y[nn];
            double rz = z[i] - z[nn];
            gamma[i] = this.variogram(this.pNug.getValue(), this.pA.getValue(), this.pS.getValue(), rx, ry, rz);
        }
        gamma[nn] = 1.0;
        return gamma;
    }

    private double variogram(double nugget, double range, double sill, double rx, double ry, double rz) {
        if (this.pMode.getValue() != 0) {
            rz = 0.0;
        }
        double valueVariogram = 0.0;
        double h2 = Math.sqrt(rx * rx + rz * rz + ry * ry);
        double scale = sill - nugget;
        switch (this.pSemivariogramType.getValue()) {
            case 0: {
                if (h2 >= range) {
                    valueVariogram = nugget + scale;
                    break;
                }
                valueVariogram = nugget + scale * (3.0 * h2 / (2.0 * range) - h2 * h2 * h2 / (2.0 * range * range * range));
                break;
            }
            case 1: {
                valueVariogram = nugget + scale * (1.0 - Math.exp(-3.0 * h2 / range));
                break;
            }
            case 2: {
                valueVariogram = nugget + scale * (1.0 - Math.exp(-3.0 * Math.pow(h2, 2.0)) / (range * range));
                break;
            }
            case 3: {
                valueVariogram = 1.0 - Math.exp(-3.0 * h2 / (range * range));
                valueVariogram = nugget + scale * valueVariogram * valueVariogram;
            }
        }
        return valueVariogram;
    }

    public void initAll() {
        int[] wA = this.statOrder.getValue();
        double[] weights = this.statWeights.getValue();
        this.entityIsStation = false;
        if (weights == null || weights.length != this.nNS + 1) {
            weights = new double[this.nNS + 1];
        }
        if (wA == null || wA.length != this.nNS) {
            wA = new int[this.nNS];
        }
        this.calcDistances(this.entityX.getValue(), this.entityY.getValue(), this.statX.getValue(), this.statY.getValue());
        for (int p = 0; p < this.nNS; ++p) {
            int min;
            wA[p] = min = this.minIndex(this.dist);
            if (this.dist[min] == 0.0) {
                Arrays.fill(wA, 0);
                Arrays.fill(weights, 0.0);
                wA[p] = min;
                weights[p] = 1.0;
                this.entityIsStation = true;
                break;
            }
            this.dist[min] = Double.MAX_VALUE;
        }
        double[][] filledArrays = this.fillStationKrigingArrays(this.entityX.getValue(), this.entityY.getValue(), this.entityElevation.getValue(), this.statX.getValue(), this.statY.getValue(), this.statElevation.getValue(), this.nNS, wA);
        double[] xStation = filledArrays[0];
        double[] yStation = filledArrays[1];
        double[] zStation = filledArrays[2];
        if (!this.entityIsStation) {
            try {
                double[][] covarianceMatrix = this.covMatrixCalculating(xStation, yStation, zStation, this.nNS);
                double[] knownTerm = this.knownTermsCalculation(xStation, yStation, zStation, this.nNS);
                ColumnVector knownTermColumn = new ColumnVector(knownTerm);
                LinearSystem linearSystem = new LinearSystem(covarianceMatrix);
                ColumnVector solution = linearSystem.solve(knownTermColumn, true);
                weights = solution.copyValues1D();
            }
            catch (MatrixException ex) {
                Logger.getLogger(RegionalisationLocalKriging.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.statWeights.setValue(weights);
        this.statOrder.setValue(wA);
    }

    public void run() {
        double[] regCoeff = this.regCoeff.getValue();
        double gradient = regCoeff[1];
        double rsq = regCoeff[2];
        double[] sourceElevations = this.statElevation.getValue();
        double[] sourceData = this.dataArray.getValue();
        double[] sourceWeights = this.statWeights.getValue();
        double targetElevation = this.entityElevation.getValue();
        int[] wA = this.statOrder.getValue();
        double value = 0.0;
        double deltaElev = 0.0;
        if (this.localElevationCorrection.getValue()) {
            int element;
            double xq = 0.0;
            double yq = 0.0;
            int counter = 0;
            for (element = 0; element < this.nNS; ++element) {
                int t = wA[element];
                if (sourceData[t] == JAMS.getMissingDataValue()) continue;
                xq += sourceElevations[t];
                yq += sourceData[t];
                ++counter;
            }
            xq /= (double)counter;
            yq /= (double)counter;
            double covxy = 0.0;
            double covx = 0.0;
            double covy = 0.0;
            for (element = 0; element < this.nNS; ++element) {
                int t = wA[element];
                if (sourceData[t] == JAMS.getMissingDataValue()) continue;
                double p = sourceElevations[t] - xq;
                double q = sourceData[t] - yq;
                covxy += p * q;
                covx += p * p;
                covy += q * q;
            }
            gradient = covxy / covx;
            rsq = covxy * covxy / (covx * covy);
        }
        Arrays.fill(this.data, 0.0);
        Arrays.fill(this.elev, 0.0);
        Arrays.fill(this.weights, 0.0);
        int counter = 0;
        int element = 0;
        boolean valid = false;
        while (counter < this.nNS) {
            int t = wA[element];
            if (sourceData[t] == JAMS.getMissingDataValue()) {
                if (++element < wA.length) continue;
                break;
            }
            valid = true;
            this.data[counter] = sourceData[t];
            this.elev[counter] = sourceElevations[t];
            this.weights[counter] = sourceWeights[element];
            ++counter;
            if (++element < wA.length) continue;
            break;
        }
        if (valid) {
            for (int i = 0; i < counter; ++i) {
                if (rsq >= this.rsqThreshold.getValue() && this.elevationCorrection.getValue()) {
                    deltaElev = targetElevation - this.elev[i];
                    double tVal = (deltaElev * gradient + this.data[i]) * this.weights[i];
                    value += tVal;
                    continue;
                }
                value += this.data[i] * this.weights[i];
            }
        } else {
            if (!this.invalidDatasetReported) {
                this.getModel().getRuntime().sendHalt("Invalid dataset found while regionalizing data in component " + this.getInstanceName() + ".\nThis might occur if all of the provided values are missing data values.");
                this.invalidDatasetReported = true;
            }
            value = JAMS.getMissingDataValue();
        }
        value = Math.max(this.fixedMinimum.getValue(), value);
        value = Math.min(this.fixedMaximum.getValue(), value);
        this.dataValue.setValue(value);
    }

    public static void main(String[] args) {
        RegionalisationLocalKriging reg = new RegionalisationLocalKriging();
        reg.dataValue = JAMSDataFactory.createDouble();
        reg.elevationCorrection = JAMSDataFactory.createBoolean();
        reg.entityElevation = JAMSDataFactory.createDouble();
        reg.entityX = JAMSDataFactory.createDouble();
        reg.entityY = JAMSDataFactory.createDouble();
        reg.fixedMaximum = JAMSDataFactory.createDouble();
        reg.fixedMinimum = JAMSDataFactory.createDouble();
        reg.latLong = JAMSDataFactory.createBoolean();
        reg.nNs = JAMSDataFactory.createInteger();
        reg.rsqThreshold = JAMSDataFactory.createDouble();
        reg.regCoeff = JAMSDataFactory.createDoubleArray();
        reg.statElevation = JAMSDataFactory.createDoubleArray();
        reg.statOrder = JAMSDataFactory.createIntegerArray();
        reg.statWeights = JAMSDataFactory.createDoubleArray();
        reg.statX = JAMSDataFactory.createDoubleArray();
        reg.statY = JAMSDataFactory.createDoubleArray();
        reg.dataArray = JAMSDataFactory.createDoubleArray();
        reg.localElevationCorrection = JAMSDataFactory.createBoolean();
        reg.elevationCorrection.setValue(true);
        reg.fixedMinimum.setValue(-999999.0);
        reg.fixedMaximum.setValue(999999.0);
        reg.nNs.setValue(4);
        reg.latLong.setValue(false);
        reg.localElevationCorrection.setValue(true);
        reg.statElevation.setValue(new double[]{100.0, 200.0, 300.0, 400.0});
        reg.statX.setValue(new double[]{0.0, 0.0, 1.0, 1.0});
        reg.statY.setValue(new double[]{0.0, 1.0, 0.0, 1.0});
        reg.regCoeff.setValue(new double[3]);
        reg.rsqThreshold.setValue(-1.0);
        reg.pNug = JAMSDataFactory.createDouble();
        reg.pS = JAMSDataFactory.createDouble();
        reg.pA = JAMSDataFactory.createDouble();
        reg.pMode = JAMSDataFactory.createInteger();
        reg.pSemivariogramType = JAMSDataFactory.createInteger();
        reg.pNug.setValue(0.0);
        reg.pS.setValue(1.0);
        reg.pA.setValue(5.0);
        reg.pSemivariogramType.setValue(0);
        reg.pMode.setValue(1);
        reg.init();
        double[] entityX = new double[]{0.5, 0.0, 1.0, 0.0, 1.0, 0.25, 0.5, 0.75, 0.25, 0.5};
        double[] entityY = new double[]{0.5, 1.0, 0.0, 0.0, 1.0, 0.25, 0.25, 0.25, 0.75, 0.75};
        double[] entityElevation = new double[]{100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0};
        double[][] dataArray = new double[][]{{1.0, 2.0, 1.0, 2.0}, {2.0, 3.0, 4.0, 5.0}, {0.0, 0.0, 0.0, 1.0}, {2.0, 0.0, 0.0, 0.0}, {4.0, 2.0, 1.0, 0.0}, {5.0, 5.0, 5.0, 5.0}, {1.0, 2.0, 1.0, 2.0}, {0.0, 0.0, 0.0, 0.0}};
        for (int i = 0; i < 10; ++i) {
            System.out.println("Entity " + i + "---------------------------------------");
            reg.entityX.setValue(entityX[i]);
            reg.entityY.setValue(entityY[i]);
            reg.entityElevation.setValue(entityElevation[i]);
            reg.initAll();
            System.out.print("Station Order: ");
            System.out.println(Arrays.toString(reg.statOrder.getValue()));
            System.out.print("Local Kriging Weights: ");
            System.out.println(Arrays.toString(reg.statWeights.getValue()));
            for (int j = 0; j < 8; ++j) {
                reg.dataArray.setValue(dataArray[j]);
                reg.run();
                System.out.println("Timestep: " + j + " | Local Kriging -> " + reg.dataValue.getValue());
            }
            System.out.println();
        }
    }

    public static enum Projection {
        LATLON,
        ANY;

    }
}

